/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone.chest;

import com.teammetallurgy.atum.blocks.QuandaryBlock;
import com.teammetallurgy.atum.blocks.base.ChestBaseBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.SarcophagusTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumTileEntities;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.SyncHandStackSizePacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class SarcophagusBlock
extends ChestBaseBlock {
    public SarcophagusBlock() {
        super(() -> AtumTileEntities.SARCOPHAGUS, AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151658_d).func_200943_b(4.0f));
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader reader) {
        return new SarcophagusTileEntity();
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        TileEntity tileEntity;
        BlockState state = event.getState();
        if (state.func_177230_c() instanceof SarcophagusBlock && (tileEntity = event.getWorld().func_175625_s(event.getPos())) instanceof SarcophagusTileEntity && !((SarcophagusTileEntity)tileEntity).isOpenable) {
            event.setCanceled(true);
        }
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SarcophagusTileEntity && !((SarcophagusTileEntity)tileEntity).isOpenable) {
            return 6000000.0f;
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        SarcophagusTileEntity sarcophagus;
        TileEntity tileEntity = world.func_175625_s(pos);
        Direction facing = (Direction)state.func_177229_b((Property)field_176459_a);
        BlockPos posLeft = pos.func_177972_a(facing.func_176746_e());
        TileEntity tileLeft = world.func_175625_s(posLeft);
        if (world.func_180495_p(posLeft).func_177230_c() == this && tileLeft instanceof SarcophagusTileEntity) {
            sarcophagus = (SarcophagusTileEntity)tileLeft;
            if (world.func_175659_aa() != Difficulty.PEACEFUL && !sarcophagus.hasSpawned) {
                this.func_225533_a_(state, world, pos.func_177972_a(facing.func_176746_e()), player, hand, hit);
                return ActionResultType.PASS;
            }
        }
        if (tileEntity instanceof SarcophagusTileEntity) {
            sarcophagus = (SarcophagusTileEntity)tileEntity;
            if (world.func_175659_aa() != Difficulty.PEACEFUL && !sarcophagus.hasSpawned) {
                if (QuandaryBlock.Helper.canSpawnPharaoh(world, pos, facing, player, sarcophagus)) {
                    return ActionResultType.PASS;
                }
                if (!sarcophagus.isOpenable) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.atum.cannot_spawn_pharaoh").func_240699_a_(TextFormatting.RED), true);
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187945_hs, SoundCategory.HOSTILE, 0.7f, 0.4f, false);
                    return ActionResultType.PASS;
                }
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof SarcophagusTileEntity && ((SarcophagusTileEntity)tileEntity).isOpenable ? super.func_220052_b(state, world, pos) : null;
    }

    @Override
    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SarcophagusTileEntity) {
            SarcophagusTileEntity sarcophagus = (SarcophagusTileEntity)tileEntity;
            sarcophagus.hasSpawned = true;
            sarcophagus.setOpenable();
            sarcophagus.func_145836_u();
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                TileEntity tileEntityOffset = world.func_175625_s(pos.func_177972_a(horizontal));
                if (!(tileEntityOffset instanceof SarcophagusTileEntity)) continue;
                ((SarcophagusTileEntity)tileEntityOffset).hasSpawned = true;
                ((SarcophagusTileEntity)tileEntityOffset).setOpenable();
                tileEntityOffset.func_145836_u();
            }
        }
    }

    @SubscribeEvent
    public static void onPlaced(BlockEvent.EntityPlaceEvent event) {
        BlockState placedState = event.getPlacedBlock();
        if (placedState.func_177230_c() instanceof SarcophagusBlock && !SarcophagusBlock.canPlaceRightSac(event.getWorld(), event.getPos(), (Direction)placedState.func_177229_b((Property)field_176459_a))) {
            event.setCanceled(true);
            if (event.getEntity() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
                ItemStack placedStack = new ItemStack((IItemProvider)placedState.func_177230_c().func_199767_j());
                Hand hand = player.func_184614_ca().func_77973_b() == placedStack.func_77973_b() ? Hand.MAIN_HAND : Hand.OFF_HAND;
                NetworkHandler.sendTo(player, new SyncHandStackSizePacket(placedStack, hand == Hand.MAIN_HAND ? 1 : 0));
            }
        }
    }

    private static boolean canPlaceRightSac(IWorld world, BlockPos pos, Direction facing) {
        BlockPos posOffset = pos.func_177972_a(facing.func_176735_f());
        BlockState offsetState = world.func_180495_p(posOffset);
        if (offsetState.func_177230_c() instanceof SarcophagusBlock) {
            return offsetState.func_177229_b((Property)field_196314_b) == ChestType.LEFT && offsetState.func_177229_b((Property)field_176459_a) == facing;
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AtumBlocks.SARCOPHAGUS);
    }
}

