/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.khnumite;

import com.teammetallurgy.atum.blocks.stone.khnumite.IKhnumite;
import com.teammetallurgy.atum.entity.stone.StoneguardEntity;
import com.teammetallurgy.atum.entity.stone.StonewardenEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class KhnumiteFaceBlock
extends HorizontalBlock
implements IKhnumite {
    private BlockPattern stoneguardBasePattern;
    private BlockPattern stoneguardPattern;
    private BlockPattern stonewardenBasePattern;
    private BlockPattern stonewardenPattern;

    public KhnumiteFaceBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151667_k).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.trySpawnStonemob(world, pos);
        }
    }

    private void trySpawnStonemob(World world, BlockPos pos) {
        block15: {
            BlockPattern.PatternHelper patternHelper;
            block14: {
                patternHelper = this.getStonewardenPattern().func_177681_a((IWorldReader)world, pos);
                if (patternHelper == null) break block14;
                for (int x = 0; x < this.getStonewardenPattern().func_177684_c(); ++x) {
                    for (int y = 0; y < this.getStonewardenPattern().func_177685_b(); ++y) {
                        BlockPos patternPos = patternHelper.func_177670_a(x, y, 0).func_177508_d();
                        if (!(world.func_180495_p(patternPos).func_177230_c() instanceof IKhnumite)) continue;
                        world.func_180501_a(patternPos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
                BlockPos stonewardenPos = patternHelper.func_177670_a(1, 2, 0).func_177508_d();
                StonewardenEntity stonewarden = (StonewardenEntity)AtumEntities.STONEWARDEN_FRIENDLY.func_200721_a(world);
                if (stonewarden == null) break block15;
                stonewarden.setPlayerCreated(true);
                if (world instanceof ServerWorld) {
                    stonewarden.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
                    stonewarden.func_70012_b((double)stonewardenPos.func_177958_n() + 0.5, (double)stonewardenPos.func_177956_o() + 0.05, (double)stonewardenPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                    world.func_217376_c((Entity)stonewarden);
                }
                for (ServerPlayerEntity playerMP : world.func_217357_a(ServerPlayerEntity.class, stonewarden.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(playerMP, (Entity)stonewarden);
                }
                for (int x = 0; x < this.getStonewardenPattern().func_177684_c(); ++x) {
                    for (int y = 0; y < this.getStonewardenPattern().func_177685_b(); ++y) {
                        CachedBlockInfo worldState1 = patternHelper.func_177670_a(x, y, 0);
                        world.func_195593_d(worldState1.func_177508_d(), Blocks.field_150350_a);
                    }
                }
                break block15;
            }
            patternHelper = this.getStoneguardPattern().func_177681_a((IWorldReader)world, pos);
            if (patternHelper != null) {
                for (int x = 0; x < this.getStoneguardPattern().func_177684_c(); ++x) {
                    for (int y = 0; y < this.getStoneguardPattern().func_177685_b(); ++y) {
                        CachedBlockInfo worldState = patternHelper.func_177670_a(x, y, 0);
                        if (!(world.func_180495_p(worldState.func_177508_d()).func_177230_c() instanceof IKhnumite)) continue;
                        world.func_180501_a(worldState.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
                StoneguardEntity stoneguard = (StoneguardEntity)AtumEntities.STONEGUARD_FRIENDLY.func_200721_a(world);
                if (stoneguard != null) {
                    stoneguard.setPlayerCreated(true);
                    if (world instanceof ServerWorld) {
                        stoneguard.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
                        BlockPos stoneguardPos = patternHelper.func_177670_a(0, 2, 0).func_177508_d();
                        stoneguard.func_70012_b((double)stoneguardPos.func_177958_n() + 0.5, (double)stoneguardPos.func_177956_o() + 0.05, (double)stoneguardPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                        world.func_217376_c((Entity)stoneguard);
                    }
                    for (ServerPlayerEntity playerMP : world.func_217357_a(ServerPlayerEntity.class, stoneguard.func_174813_aQ().func_186662_g(5.0))) {
                        CriteriaTriggers.field_192133_m.func_192229_a(playerMP, (Entity)stoneguard);
                    }
                    for (int x = 0; x < this.getStoneguardPattern().func_177684_c(); ++x) {
                        for (int y = 0; y < this.getStoneguardPattern().func_177685_b(); ++y) {
                            CachedBlockInfo worldState = patternHelper.func_177670_a(x, y, 0);
                            world.func_195593_d(worldState.func_177508_d(), Blocks.field_150350_a);
                        }
                    }
                }
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public static void addDispenserSupport() {
        DispenserBlock.func_199774_a((IItemProvider)AtumBlocks.KHNUMITE_FACE.func_199767_j(), (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            @Nonnull
            protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
                ServerWorld world = source.func_197524_h();
                BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                KhnumiteFaceBlock khnumiteFace = (KhnumiteFaceBlock)AtumBlocks.KHNUMITE_FACE;
                if (world.func_175623_d(pos) && khnumiteFace.canDispenserPlace((World)world, pos)) {
                    if (!world.field_72995_K) {
                        world.func_180501_a(pos, khnumiteFace.func_176223_P(), 3);
                    }
                    stack.func_190918_g(1);
                    this.func_239796_a_(true);
                } else {
                    this.func_239796_a_(ArmorItem.func_226626_a_((IBlockSource)source, (ItemStack)stack));
                }
                return stack;
            }
        });
    }

    private boolean canDispenserPlace(World world, BlockPos pos) {
        return this.getStonewardenBasePattern().func_177681_a((IWorldReader)world, pos) != null || this.getStoneguardBasePattern().func_177681_a((IWorldReader)world, pos) != null;
    }

    private BlockPattern getStoneguardBasePattern() {
        if (this.stoneguardBasePattern == null) {
            this.stoneguardBasePattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"   ", "~#~", " # "}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stoneguardBasePattern;
    }

    private BlockPattern getStoneguardPattern() {
        if (this.stoneguardPattern == null) {
            this.stoneguardPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{" ^ ", "~#~", " # "}).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_FACE))).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stoneguardPattern;
    }

    private BlockPattern getStonewardenBasePattern() {
        if (this.stonewardenBasePattern == null) {
            this.stonewardenBasePattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~ ~", "###", "~#~"}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stonewardenBasePattern;
    }

    private BlockPattern getStonewardenPattern() {
        if (this.stonewardenPattern == null) {
            this.stonewardenPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_FACE))).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)AtumBlocks.KHNUMITE_BLOCK))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.stonewardenPattern;
    }
}

