/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines;

import com.teammetallurgy.atum.blocks.machines.KilnFakeBlock;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnBaseTileEntity;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class KilnBlock
extends AbstractFurnaceBlock {
    static final BooleanProperty MULTIBLOCK_PRIMARY = BooleanProperty.func_177716_a((String)"multiblock_primary");
    private static final BooleanProperty MULTIBLOCK_SECONDARY = BooleanProperty.func_177716_a((String)"multiblock_secondary");

    public KilnBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151658_d).func_200943_b(3.5f).func_235838_a_(s -> (Boolean)s.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 13 : 0).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_220090_a, (Comparable)Direction.NORTH)).func_206870_a((Property)field_220091_b, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)MULTIBLOCK_SECONDARY, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader interactWithreader) {
        return new KilnTileEntity();
    }

    protected void func_220089_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player) {
        TileEntity tileEntity;
        BlockPos tepos = this.getPrimaryKilnBlock(world, pos);
        if (tepos != null && (tileEntity = world.func_175625_s(tepos)) instanceof KilnTileEntity && player instanceof ServerPlayerEntity) {
            KilnTileEntity kiln = (KilnTileEntity)tileEntity;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)kiln, (BlockPos)tepos);
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c()) {
            if (((Boolean)state.func_177229_b((Property)MULTIBLOCK_PRIMARY)).booleanValue()) {
                this.destroyMultiblock(world, pos, (Direction)state.func_177229_b((Property)field_220090_a));
            } else {
                BlockPos primaryPos = pos.func_177972_a(((Direction)state.func_177229_b((Property)field_220090_a)).func_176735_f());
                BlockState primaryState = world.func_180495_p(primaryPos);
                if (primaryState.func_177230_c() == AtumBlocks.KILN && ((Boolean)primaryState.func_177229_b((Property)MULTIBLOCK_PRIMARY)).booleanValue()) {
                    this.destroyMultiblock(world, primaryPos, (Direction)primaryState.func_177229_b((Property)field_220090_a));
                }
            }
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull LivingEntity placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        this.tryMakeMultiblock(world, pos, world.func_180495_p(pos));
    }

    public void tryMakeMultiblock(World world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)field_220090_a);
        if (this.checkMultiblock(world, pos, facing)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(true)));
            world.func_175656_a(pos.func_177972_a(facing.func_176746_e()), (BlockState)state.func_206870_a((Property)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false)));
            this.createMultiblock(world, pos);
        } else if (this.checkMultiblock(world, pos.func_177972_a(facing.func_176735_f()), facing)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false)));
            world.func_175656_a(pos.func_177972_a(facing.func_176735_f()), (BlockState)state.func_206870_a((Property)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(true)));
            this.createMultiblock(world, pos.func_177972_a(facing.func_176735_f()));
        }
    }

    public static BlockPos getSecondaryKilnFromPrimary(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof KilnTileEntity && state.func_177230_c() == AtumBlocks.KILN && ((KilnTileEntity)tileEntity).isPrimary()) {
            return pos.func_177972_a(((Direction)state.func_177229_b((Property)field_220090_a)).func_176746_e());
        }
        return null;
    }

    private BlockPos getPrimaryKilnBlock(World world, BlockPos pos) {
        if (world != null && !world.func_175623_d(pos)) {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == AtumBlocks.KILN && ((Boolean)state.func_177229_b((Property)MULTIBLOCK_PRIMARY)).booleanValue()) {
                return pos;
            }
            if ((state = world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)field_220090_a)).func_176735_f()))).func_177230_c() == AtumBlocks.KILN && ((Boolean)state.func_177229_b((Property)MULTIBLOCK_PRIMARY)).booleanValue()) {
                return pos.func_177972_a(((Direction)state.func_177229_b((Property)field_220090_a)).func_176735_f());
            }
        }
        return null;
    }

    private void createMultiblock(World world, BlockPos primaryPos) {
        BlockPos secondaryPos;
        List<BlockPos> brickPositions = this.getKilnBrickPositions(primaryPos, (Direction)world.func_180495_p(primaryPos).func_177229_b((Property)field_220090_a));
        for (BlockPos brickPos : brickPositions) {
            world.func_175656_a(brickPos, (BlockState)AtumBlocks.KILN_FAKE.func_176223_P().func_206870_a((Property)KilnFakeBlock.UP, (Comparable)Boolean.valueOf(primaryPos.func_177956_o() - 1 == brickPos.func_177956_o())));
            TileEntity tileEntity = world.func_175625_s(brickPos);
            if (tileEntity == null) continue;
            ((KilnBaseTileEntity)tileEntity).setPrimaryPos(primaryPos);
        }
        TileEntity tileEntity = world.func_175625_s(primaryPos);
        if (tileEntity instanceof KilnBaseTileEntity) {
            ((KilnBaseTileEntity)tileEntity).setPrimaryPos(primaryPos);
        }
        if ((secondaryPos = KilnBlock.getSecondaryKilnFromPrimary(world, primaryPos)) != null && (tileEntity = world.func_175625_s(secondaryPos)) instanceof KilnBaseTileEntity) {
            ((KilnBaseTileEntity)tileEntity).setPrimaryPos(primaryPos);
        }
    }

    void destroyMultiblock(World world, BlockPos primaryPos, Direction facing) {
        KilnBaseTileEntity kilnBase;
        List<BlockPos> brickPositions = this.getKilnBrickPositions(primaryPos, facing);
        BlockState primaryState = world.func_180495_p(primaryPos);
        BlockPos secondaryPos = primaryPos.func_177972_a(facing.func_176746_e());
        BlockState secondaryState = world.func_180495_p(secondaryPos);
        BlockPos dropPos = primaryPos;
        if (primaryState.func_177230_c() == AtumBlocks.KILN) {
            world.func_175656_a(primaryPos, (BlockState)((BlockState)primaryState.func_206870_a((Property)MULTIBLOCK_PRIMARY, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_220091_b, (Comparable)Boolean.valueOf(false)));
        }
        if (secondaryState.func_177230_c() == AtumBlocks.KILN) {
            world.func_175656_a(secondaryPos, (BlockState)secondaryState.func_206870_a((Property)field_220091_b, (Comparable)Boolean.valueOf(false)));
        } else {
            dropPos = secondaryPos;
        }
        for (BlockPos brickPos : brickPositions) {
            if (world.func_180495_p(brickPos).func_177230_c() == AtumBlocks.KILN_FAKE) {
                world.func_175713_t(brickPos);
                world.func_175656_a(brickPos, AtumBlocks.LIMESTONE_BRICK_SMALL.func_176223_P());
                continue;
            }
            dropPos = brickPos;
        }
        TileEntity tileEntity = world.func_175625_s(primaryPos);
        if (tileEntity instanceof KilnBaseTileEntity) {
            kilnBase = (KilnBaseTileEntity)tileEntity;
            kilnBase.setPrimaryPos(null);
            InventoryHelper.func_180175_a((World)world, (BlockPos)dropPos, (IInventory)kilnBase);
            kilnBase.func_145843_s();
        }
        if ((tileEntity = world.func_175625_s(secondaryPos)) instanceof KilnBaseTileEntity) {
            kilnBase = (KilnBaseTileEntity)tileEntity;
            kilnBase.setPrimaryPos(null);
        }
    }

    private boolean checkMultiblock(World world, BlockPos primaryPos, Direction facing) {
        List<BlockPos> brickPositions = this.getKilnBrickPositions(primaryPos, facing);
        if (world.func_180495_p(primaryPos).func_177230_c() != AtumBlocks.KILN) {
            return false;
        }
        if (world.func_180495_p(primaryPos.func_177972_a(facing.func_176746_e())).func_177230_c() != AtumBlocks.KILN) {
            return false;
        }
        for (BlockPos brickPos : brickPositions) {
            BlockState brickState = world.func_180495_p(brickPos);
            if (brickState.func_177230_c() == AtumBlocks.LIMESTONE_BRICK_SMALL) continue;
            return false;
        }
        return true;
    }

    private List<BlockPos> getKilnBrickPositions(BlockPos pos, Direction facing) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        positions.add(pos.func_177972_a(Direction.DOWN));
        positions.add(pos.func_177972_a(facing.func_176734_d()));
        positions.add(pos.func_177972_a(facing.func_176734_d()).func_177972_a(Direction.DOWN));
        BlockPos offset = pos.func_177972_a(facing.func_176746_e());
        positions.add(offset.func_177972_a(Direction.DOWN));
        positions.add(offset.func_177972_a(facing.func_176734_d()));
        positions.add(offset.func_177972_a(facing.func_176734_d()).func_177972_a(Direction.DOWN));
        return positions;
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        KilnTileEntity kiln;
        TileEntity tileEntity = world.func_175625_s(currentPos);
        if (tileEntity instanceof KilnTileEntity && this.getPrimaryKilnBlock((kiln = (KilnTileEntity)tileEntity).func_145831_w(), currentPos) != null) {
            return (BlockState)state.func_206870_a((Property)MULTIBLOCK_SECONDARY, (Comparable)Boolean.valueOf(!kiln.isPrimary()));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{field_220090_a, field_220091_b, MULTIBLOCK_PRIMARY, MULTIBLOCK_SECONDARY});
    }
}

