/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class StorageUtil {
    public static void clearOpenCraftingMatrix(ServerPlayerEntity player, boolean sendStackUpdate) {
        if (player.field_71070_bA instanceof IStorageControllerContainer) {
            IStorageControllerContainer container = (IStorageControllerContainer)player.field_71070_bA;
            CraftingInventory craftMatrix = container.getCraftMatrix();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                int remainingAfterInsert;
                int amountBeforeInsert;
                ItemStack stackInSlot = craftMatrix.func_70301_a(i);
                if (stackInSlot.func_190926_b() || (amountBeforeInsert = stackInSlot.func_190916_E()) == (remainingAfterInsert = storageController.insertStack(stackInSlot.func_77946_l(), false))) continue;
                if (remainingAfterInsert == 0) {
                    craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                craftMatrix.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfterInsert));
            }
            if (sendStackUpdate) {
                OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
                ((Container)container).func_75142_b();
            }
        }
    }

    public static void clearOpenOrderSlot(ServerPlayerEntity player, boolean sendStackUpdate) {
        if (player.field_71070_bA instanceof IStorageControllerContainer) {
            int remainingAfterInsert;
            int amountBeforeInsert;
            IStorageControllerContainer container = (IStorageControllerContainer)player.field_71070_bA;
            Inventory orderSlot = container.getOrderSlot();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            ItemStack stackInSlot = orderSlot.func_70301_a(0);
            if (!stackInSlot.func_190926_b() && (amountBeforeInsert = stackInSlot.func_190916_E()) != (remainingAfterInsert = storageController.insertStack(stackInSlot.func_77946_l(), false))) {
                if (remainingAfterInsert == 0) {
                    orderSlot.func_70299_a(0, ItemStack.field_190927_a);
                } else {
                    orderSlot.func_70299_a(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfterInsert));
                }
            }
            if (sendStackUpdate) {
                OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
                ((Container)container).func_75142_b();
            }
        }
    }

    public static ItemStack extractItem(IItemHandler itemHandler, Predicate<ItemStack> comparator, int amount, boolean simulate) {
        if (itemHandler == null || comparator == null) {
            return ItemStack.field_190927_a;
        }
        int amountExtracted = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack extractedStack;
            ItemStack slot = itemHandler.getStackInSlot(i);
            if (!comparator.test(slot) || (extractedStack = itemHandler.extractItem(i, 1, simulate)).func_190926_b()) continue;
            if (++amountExtracted == amount) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)amount);
            }
            --i;
        }
        return ItemStack.field_190927_a;
    }

    public static int getFirstFilledSlot(IItemHandler handler) {
        return StorageUtil.getFirstFilledSlotAfter(handler, -1);
    }

    public static int getFirstFilledSlotAfter(IItemHandler handler, int slot) {
        for (int i = slot + 1; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstMatchingSlot(IItemHandler handler, IItemHandler filter, String tagFilter, boolean isBlacklist) {
        return StorageUtil.getFirstMatchingSlotAfter(handler, -1, filter, tagFilter, isBlacklist);
    }

    public static int getFirstMatchingSlotAfter(IItemHandler handler, int slot, IItemHandler filter, String tagFilter, boolean isBlacklist) {
        for (int i = slot + 1; i < handler.getSlots(); ++i) {
            boolean matches;
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            boolean bl = matches = StorageUtil.matchesFilter(handler.getStackInSlot(i), filter) || StorageUtil.matchesFilter(handler.getStackInSlot(i), tagFilter);
            if ((isBlacklist || !matches) && (!isBlacklist || matches)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchesFilter(ItemStack stack, IItemHandler filter) {
        for (int i = 0; i < filter.getSlots(); ++i) {
            ItemStack filtered = filter.getStackInSlot(i);
            boolean equals = filtered.func_77969_a(stack);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesFilter(ItemStack stack, String tagFilter) {
        String[] filters;
        if (tagFilter.isEmpty()) {
            return false;
        }
        for (String filter : filters = tagFilter.split(";")) {
            boolean equals = stack.func_77973_b().getTags().stream().anyMatch(rl -> FilenameUtils.wildcardMatch((String)rl.toString(), (String)filter, (IOCase)IOCase.INSENSITIVE));
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public static void dropInventoryItems(TileEntity tileEntity) {
        tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> StorageUtil.dropInventoryItems(tileEntity.func_145831_w(), tileEntity.func_174877_v(), handler));
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemHandler.getStackInSlot(i));
        }
    }
}

