/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.network.MessageUpdateMouseHeldItem;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class MessageTakeItem
extends MessageBase {
    private ItemStack stack = ItemStack.field_190927_a;
    private int mouseButton;
    private boolean isShiftDown;
    private boolean isCtrlDown;

    public MessageTakeItem(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageTakeItem(ItemStack stack, int mouseButton, boolean isShiftDown, boolean isCtrlDown) {
        this.mouseButton = mouseButton;
        this.stack = stack;
        this.isShiftDown = isShiftDown;
        this.isCtrlDown = isCtrlDown;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        if (player.field_71070_bA instanceof IStorageControllerContainer) {
            IStorageController storageController = ((IStorageControllerContainer)player.field_71070_bA).getStorageController();
            if (storageController == null) {
                return;
            }
            int available = storageController.getAvailableAmount(new ItemStackComparator(this.stack, true));
            int amountRequested = 0;
            if (this.isCtrlDown) {
                amountRequested = 1;
            } else if (this.mouseButton == 0) {
                amountRequested = this.stack.func_77976_d();
            } else if (this.mouseButton == 1) {
                amountRequested = Math.min(this.stack.func_77976_d() / 2, available / 2);
            }
            amountRequested = Math.max(amountRequested, 1);
            ItemStack stack = storageController.getItemStack(new ItemStackComparator(this.stack, true), amountRequested, false);
            if (stack.func_190926_b()) {
                stack = storageController.getItemStack(new ItemStackComparator(this.stack, false), amountRequested, false);
            }
            if (!stack.func_190926_b()) {
                if (this.isShiftDown) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
                } else {
                    player.field_71071_by.func_70437_b(stack);
                    OccultismPackets.sendTo(player, new MessageUpdateMouseHeldItem(stack));
                }
            }
            OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
            player.field_71070_bA.func_75142_b();
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        ItemStack toWrite = this.stack.func_77946_l();
        toWrite.func_190920_e(1);
        buf.func_150788_a(toWrite);
        buf.writeInt(this.stack.func_190916_E());
        buf.writeByte(this.mouseButton);
        buf.writeBoolean(this.isShiftDown);
        buf.writeBoolean(this.isCtrlDown);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.stack = buf.func_150791_c();
        this.stack.func_190920_e(buf.readInt());
        this.mouseButton = buf.readByte();
        this.isShiftDown = buf.readBoolean();
        this.isCtrlDown = buf.readBoolean();
    }
}

