/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.common.entity.BeholderFamiliarEntity;
import com.github.klikli_dev.occultism.network.MessageBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageBeholderAttack
extends MessageBase {
    private int beholderId;
    private List<Integer> targetIds;

    public MessageBeholderAttack(int beholderId, List<Integer> targetIds) {
        this.beholderId = beholderId;
        this.targetIds = targetIds;
    }

    public MessageBeholderAttack(PacketBuffer buf) {
        this.decode(buf);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.beholderId);
        buf.writeInt(this.targetIds.size());
        for (int id : this.targetIds) {
            buf.writeInt(id);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.beholderId = buf.readInt();
        this.targetIds = new ArrayList<Integer>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.targetIds.add(buf.readInt());
        }
    }

    @Override
    public void onClientReceived(Minecraft minecraft, PlayerEntity player, NetworkEvent.Context context) {
        Entity beholder = minecraft.field_71441_e.func_73045_a(this.beholderId);
        if (beholder instanceof BeholderFamiliarEntity) {
            ((BeholderFamiliarEntity)beholder).shootRay(this.targetIds);
        }
    }
}

