/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.patchouli;

import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class RitualRecipeProcessor
implements IComponentProcessor {
    protected RitualRecipe recipe;
    protected ItemStack sacrificialBowl;

    public void setup(IVariableProvider iVariableProvider) {
        String recipeId = iVariableProvider.get("recipe").asString();
        this.recipe = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(new ResourceLocation(recipeId)).orElse(null);
        this.sacrificialBowl = new ItemStack((IItemProvider)OccultismBlocks.SACRIFICIAL_BOWL.get());
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return IVariable.empty();
        }
        if (key.startsWith("ritual_dummy")) {
            return IVariable.from((Object)this.recipe.getRitualDummy());
        }
        if (key.startsWith("activation_item")) {
            return IVariable.from((Object)this.recipe.getActivationItem().func_193365_a());
        }
        if (key.startsWith("pentacle") && this.recipe.getPentacle() != null) {
            String pentacleName = I18n.func_135052_a((String)this.recipe.getPentacle().getTranslationKey(), (Object[])new Object[0]);
            String pentacleLink = "pentacles/" + this.recipe.getPentacleId().func_110623_a();
            return IVariable.wrap((String)String.format("$(l:%s)%s$(/l)", pentacleLink, pentacleName));
        }
        if (key.startsWith("ingredient")) {
            int index = Integer.parseInt(key.substring("ingredient".length())) - 1;
            if (index >= this.recipe.func_192400_c().size()) {
                return IVariable.empty();
            }
            Ingredient ingredient = (Ingredient)this.recipe.func_192400_c().get(index);
            return IVariable.from((Object)ingredient.func_193365_a());
        }
        if (key.startsWith("bowl")) {
            int index = Integer.parseInt(key.substring("bowl".length())) - 1;
            if (index >= this.recipe.func_192400_c().size()) {
                return IVariable.empty();
            }
            return IVariable.from((Object)this.sacrificialBowl);
        }
        if (key.equals("output")) {
            if (this.recipe.func_77571_b().func_77973_b() != OccultismItems.JEI_DUMMY_NONE.get()) {
                return IVariable.from((Object)this.recipe.func_77571_b());
            }
            return IVariable.from((Object)this.recipe.getRitualDummy());
        }
        if (key.equals("entity_to_summon") && this.recipe.getEntityToSummon() != null) {
            return IVariable.wrap((String)I18n.func_135052_a((String)"jei.occultism.summon", (Object[])new Object[]{I18n.func_135052_a((String)this.recipe.getEntityToSummon().func_210760_d(), (Object[])new Object[0])}));
        }
        if (key.equals("job") && this.recipe.getSpiritJobType() != null) {
            return IVariable.wrap((String)I18n.func_135052_a((String)"jei.occultism.job", (Object[])new Object[]{I18n.func_135052_a((String)("job." + this.recipe.getSpiritJobType().toString().replace(":", ".")), (Object[])new Object[0])}));
        }
        if (key.equals("entity_to_sacrifice") && this.recipe.requiresSacrifice()) {
            return IVariable.wrap((String)I18n.func_135052_a((String)"jei.occultism.sacrifice", (Object[])new Object[]{I18n.func_135052_a((String)this.recipe.getEntityToSacrificeDisplayName(), (Object[])new Object[0])}));
        }
        if (key.equals("item_to_use") && this.recipe.requiresItemUse()) {
            return IVariable.from((Object)this.recipe.getItemToUse().func_193365_a());
        }
        if (key.equals("item_to_use_text") && this.recipe.requiresItemUse()) {
            return IVariable.wrap((String)I18n.func_135052_a((String)"jei.occultism.item_to_use", (Object[])new Object[0]));
        }
        return IVariable.empty();
    }
}

