/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei.recipes;

import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.common.ritual.pentacle.PentacleManager;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipe> {
    private final IDrawable background;
    private final IDrawable arrow;
    private final String localizedName;
    private final String pentacle;
    private final ItemStack goldenSacrificialBowl = new ItemStack((IItemProvider)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get());
    private final ItemStack sacrificialBowl = new ItemStack((IItemProvider)OccultismBlocks.SACRIFICIAL_BOWL.get());
    private final ItemStack requireSacrifice = new ItemStack((IItemProvider)OccultismItems.JEI_DUMMY_REQUIRE_SACRIFICE.get());
    private final int iconWidth = 16;
    private final int ritualCenterX;
    private final int ritualCenterY;
    private int recipeOutputOffsetX = 50;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 120);
        this.ritualCenterX = this.background.getWidth() / 2 - this.iconWidth / 2 - 30;
        this.ritualCenterY = this.background.getHeight() / 2 - this.iconWidth / 2 + 20;
        this.localizedName = I18n.func_135052_a((String)"occultism.jei.ritual", (Object[])new Object[0]);
        this.pentacle = I18n.func_135052_a((String)"occultism.jei.pentacle", (Object[])new Object[0]);
        this.goldenSacrificialBowl.func_196082_o().func_74757_a("RenderFull", true);
        this.sacrificialBowl.func_196082_o().func_74757_a("RenderFull", true);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    public ResourceLocation getUid() {
        return OccultismRecipes.RITUAL.getId();
    }

    public Class<? extends RitualRecipe> getRecipeClass() {
        return RitualRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(RitualRecipe recipe, IIngredients ingredients) {
        Stream<Ingredient> ingredientStream = Stream.concat(Stream.of(recipe.getActivationItem()), recipe.func_192400_c().stream());
        if (recipe.requiresItemUse()) {
            ingredientStream = Stream.concat(Stream.of(recipe.getItemToUse()), ingredientStream);
        }
        ingredients.setInputIngredients(ingredientStream.collect(Collectors.toList()));
        ingredients.setOutputs(VanillaTypes.ITEM, Stream.of(recipe.func_77571_b(), recipe.getRitualDummy()).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, RitualRecipe recipe, IIngredients ingredients) {
        int index = 0;
        this.recipeOutputOffsetX = 75;
        int currentIngredient = 0;
        List itemToUse = new ArrayList();
        if (recipe.requiresItemUse()) {
            itemToUse = (List)ingredients.getInputs(VanillaTypes.ITEM).get(currentIngredient++);
        }
        List activationItem = (List)ingredients.getInputs(VanillaTypes.ITEM).get(currentIngredient++);
        List inputItems = ingredients.getInputs(VanillaTypes.ITEM).stream().skip(currentIngredient).collect(Collectors.toList());
        recipeLayout.getItemStacks().init(index, true, this.ritualCenterX, this.ritualCenterY - 5);
        recipeLayout.getItemStacks().set(index, activationItem);
        recipeLayout.getItemStacks().init(++index, false, this.ritualCenterX, this.ritualCenterY);
        recipeLayout.getItemStacks().set(index, this.goldenSacrificialBowl);
        ++index;
        int sacrificialCircleRadius = 30;
        int sacricialBowlPaddingVertical = 20;
        int sacricialBowlPaddingHorizontal = 15;
        List sacrificialBowlPosition = Stream.of(new Vector3i(this.ritualCenterX, this.ritualCenterY - sacrificialCircleRadius, 0), new Vector3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY, 0), new Vector3i(this.ritualCenterX, this.ritualCenterY + sacrificialCircleRadius, 0), new Vector3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY, 0), new Vector3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vector3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0), new Vector3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vector3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vector3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vector3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vector3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vector3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0)).collect(Collectors.toList());
        for (int i = 0; i < inputItems.size(); ++i) {
            Vector3i pos = (Vector3i)sacrificialBowlPosition.get(i);
            recipeLayout.getItemStacks().init(index, true, pos.func_177958_n(), pos.func_177956_o() - 5);
            recipeLayout.getItemStacks().set(index, (List)inputItems.get(i));
            recipeLayout.getItemStacks().init(++index, false, pos.func_177958_n(), pos.func_177956_o());
            recipeLayout.getItemStacks().set(index, this.sacrificialBowl);
            ++index;
        }
        if (recipe.func_77571_b().func_77973_b() != OccultismItems.JEI_DUMMY_NONE.get()) {
            recipeLayout.getItemStacks().init(index, false, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            ++index;
        } else {
            recipeLayout.getItemStacks().init(index, false, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
            ++index;
        }
        recipeLayout.getItemStacks().init(index, false, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY);
        recipeLayout.getItemStacks().set(index, this.goldenSacrificialBowl);
        recipeLayout.getItemStacks().init(++index, false, 0, 0);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(1));
        ++index;
        if (recipe.requiresItemUse()) {
            int infotextY = 0;
            if (recipe.requiresSacrifice()) {
                infotextY += 10;
            }
            String text = I18n.func_135052_a((String)"jei.occultism.item_to_use", (Object[])new Object[0]);
            int itemToUseY = (infotextY += 10) - 5;
            int itemToUseX = this.getStringCenteredMaxX(Minecraft.func_71410_x().field_71466_p, text, 84, infotextY);
            recipeLayout.getItemStacks().init(index, false, itemToUseX, itemToUseY);
            recipeLayout.getItemStacks().set(index, itemToUse);
            ++index;
        }
    }

    public void draw(RitualRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(matrixStack, this.ritualCenterX + this.recipeOutputOffsetX - 20, this.ritualCenterY);
        RenderSystem.disableBlend();
        Pentacle pentacle = PentacleManager.get(recipe.getPentacleId());
        if (pentacle != null) {
            this.drawStringCentered(matrixStack, Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)pentacle.getTranslationKey(), (Object[])new Object[0]), 84, 0);
        } else {
            this.drawStringCentered(matrixStack, Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)"jei.occultism.error.pentacle_not_loaded", (Object[])new Object[0]), 84, 0);
        }
        int infotextY = 0;
        if (recipe.requiresSacrifice()) {
            this.drawStringCentered(matrixStack, Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)"jei.occultism.sacrifice", (Object[])new Object[]{I18n.func_135052_a((String)recipe.getEntityToSacrificeDisplayName(), (Object[])new Object[0])}), 84, infotextY += 10);
        }
        if (recipe.requiresItemUse()) {
            String text = I18n.func_135052_a((String)"jei.occultism.item_to_use", (Object[])new Object[0]);
            this.drawStringCentered(matrixStack, Minecraft.func_71410_x().field_71466_p, text, 84, infotextY += 10);
        }
        if (recipe.getEntityToSummon() != null) {
            this.drawStringCentered(matrixStack, Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)"jei.occultism.summon", (Object[])new Object[]{I18n.func_135052_a((String)recipe.getEntityToSummon().func_210760_d(), (Object[])new Object[0])}), 84, infotextY += 10);
        }
        if (recipe.getSpiritJobType() != null) {
            this.drawStringCentered(matrixStack, Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)"jei.occultism.job", (Object[])new Object[]{I18n.func_135052_a((String)("job." + recipe.getSpiritJobType().toString().replace(":", ".")), (Object[])new Object[0])}), 84, infotextY += 10);
        }
    }

    protected int getStringCenteredMaxX(FontRenderer fontRenderer, String text, int x, int y) {
        int width = fontRenderer.func_78256_a(text);
        int actualX = (int)((float)x - (float)width / 2.0f);
        return actualX + width;
    }

    protected void drawStringCentered(MatrixStack matrixStack, FontRenderer fontRenderer, String text, int x, int y) {
        fontRenderer.func_238421_b_(matrixStack, text, (float)x - (float)fontRenderer.func_78256_a(text) / 2.0f, (float)y, 0);
    }
}

