/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.common.item.tool.ButcherKnifeItem;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootEventHandler {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity trueSource;
        ItemStack knifeItem;
        if (event.isRecentlyHit() && event.getSource().func_76346_g() instanceof LivingEntity && (knifeItem = (trueSource = (LivingEntity)event.getSource().func_76346_g()).func_184586_b(Hand.MAIN_HAND)).func_77973_b() == OccultismItems.BUTCHER_KNIFE.get()) {
            List<ItemStack> loot = ButcherKnifeItem.getLoot(event.getEntityLiving(), knifeItem, trueSource);
            Random rand = event.getEntityLiving().func_70681_au();
            if (!loot.isEmpty()) {
                for (ItemStack stack : loot) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(rand.nextInt(stack.func_190916_E() + 1) + rand.nextInt(event.getLootingLevel() + 1));
                    Vector3d center = Math3DUtil.center(event.getEntityLiving().func_233580_cy_());
                    event.getDrops().add(new ItemEntity(event.getEntityLiving().field_70170_p, center.field_72450_a, center.field_72448_b, center.field_72449_c, copy));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onExpDrop(LivingExperienceDropEvent event) {
        if (event.getDroppedExperience() == 0) {
            return;
        }
        PlayerEntity attackingPlayer = event.getAttackingPlayer();
        if (attackingPlayer != null) {
            EffectInstance greed = attackingPlayer.func_70660_b((Effect)OccultismEffects.DRAGON_GREED.get());
            if (greed == null) {
                return;
            }
            event.setDroppedExperience(event.getDroppedExperience() + greed.func_76458_c() + 1);
        }
    }

    @SubscribeEvent
    public static void giveStoneToBlacksmith(EntityItemPickupEvent event) {
        ItemEntity entity = event.getItem();
        ItemStack stack = entity.func_92059_d();
        Item item = stack.func_77973_b();
        if (!item.func_206844_a((ITag)Tags.Items.COBBLESTONE) && !item.func_206844_a((ITag)Tags.Items.STONE)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!FamiliarUtil.isFamiliarEnabled((LivingEntity)player, (EntityType<? extends IFamiliar>)((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR.get())) || !FamiliarUtil.hasFamiliar((LivingEntity)player, (EntityType)OccultismEntities.BLACKSMITH_FAMILIAR.get())) {
            return;
        }
        if (player.func_70681_au().nextDouble() < (double)(Occultism.SERVER_CONFIG.spiritJobs.blacksmithFamiliarRepairChance.get() * (float)stack.func_190916_E())) {
            LootEventHandler.repairEquipment(player);
        }
        event.setCanceled(true);
        entity.func_70106_y();
    }

    private static void repairEquipment(PlayerEntity player) {
        for (ItemStack stack : player.func_184209_aF()) {
            if (!stack.func_77951_h()) continue;
            stack.func_196085_b(stack.func_77952_i() - 2);
            return;
        }
    }
}

