/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.client.gui.DimensionalMineshaftScreen;
import com.github.klikli_dev.occultism.client.gui.spirit.SpiritGui;
import com.github.klikli_dev.occultism.client.gui.spirit.SpiritTransporterGui;
import com.github.klikli_dev.occultism.client.gui.storage.SatchelScreen;
import com.github.klikli_dev.occultism.client.gui.storage.StableWormholeGui;
import com.github.klikli_dev.occultism.client.gui.storage.StorageControllerGui;
import com.github.klikli_dev.occultism.client.gui.storage.StorageRemoteGui;
import com.github.klikli_dev.occultism.client.itemproperties.DivinationRodItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.GuideBookItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.OtherworldBlockItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.SoulGemItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.StableWormholeBlockItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.StorageRemoteItemPropertyGetter;
import com.github.klikli_dev.occultism.client.keybindings.BackpackKeyConflictContext;
import com.github.klikli_dev.occultism.client.keybindings.StorageRemoteKeyConflictContext;
import com.github.klikli_dev.occultism.client.render.entity.AfritRenderer;
import com.github.klikli_dev.occultism.client.render.entity.BatFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.BeholderFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.BlacksmithFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.ChimeraFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.CthulhuFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DeerFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DevilFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DjinniRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DragonFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DragonRendering;
import com.github.klikli_dev.occultism.client.render.entity.FairyFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.FoliotRenderer;
import com.github.klikli_dev.occultism.client.render.entity.GoatFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.GreedyFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.GuardianFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.HeadlessFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.MaridRenderer;
import com.github.klikli_dev.occultism.client.render.entity.MummyFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.OtherworldBirdRenderer;
import com.github.klikli_dev.occultism.client.render.entity.ShubNiggurathFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.ShubNiggurathSpawnRenderer;
import com.github.klikli_dev.occultism.client.render.tile.SacrificialBowlRenderer;
import com.github.klikli_dev.occultism.client.render.tile.StorageControllerGeoRenderer;
import com.github.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EndermiteRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="occultism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEventHandler {
    public static final KeyBinding KEY_BACKPACK = new KeyBinding("key.occultism.backpack", (IKeyConflictContext)BackpackKeyConflictContext.INSTANCE, InputMappings.Type.KEYSYM.func_197944_a(66), "key.occultism.category");
    public static final KeyBinding KEY_STORAGE_REMOTE = new KeyBinding("key.occultism.storage_remote", (IKeyConflictContext)StorageRemoteKeyConflictContext.INSTANCE, InputMappings.Type.KEYSYM.func_197944_a(78), "key.occultism.category");
    public static Map<EntityType<?>, KeyBinding> keysFamiliars;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Occultism.SELECTED_BLOCK_RENDERER);
        MinecraftForge.EVENT_BUS.register((Object)Occultism.THIRD_EYE_EFFECT_RENDERER);
        event.enqueueWork(() -> {
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_BACKPACK);
            ClientRegistry.registerKeyBinding((KeyBinding)KEY_STORAGE_REMOTE);
            keysFamiliars = new HashMap();
            for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
                KeyBinding kb = new KeyBinding("key.occultism.familiar." + familiar.getRegistryName().func_110623_a(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM.func_197944_a(-1), "key.occultism.category");
                keysFamiliars.put(familiar, kb);
                ClientRegistry.registerKeyBinding((KeyBinding)kb);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.FOLIOT.get()), FoliotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.DJINNI.get()), DjinniRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.AFRIT.get()), AfritRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.AFRIT_WILD.get()), AfritRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.MARID.get()), MaridRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.GREEDY_FAMILIAR.get()), GreedyFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.BAT_FAMILIAR.get()), BatFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.DEER_FAMILIAR.get()), DeerFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.CTHULHU_FAMILIAR.get()), CthulhuFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.DEVIL_FAMILIAR.get()), DevilFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.DRAGON_FAMILIAR.get()), DragonFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR.get()), BlacksmithFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.GUARDIAN_FAMILIAR.get()), GuardianFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.HEADLESS_FAMILIAR.get()), HeadlessFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.CHIMERA_FAMILIAR.get()), ChimeraFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.GOAT_FAMILIAR.get()), GoatFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get()), ShubNiggurathFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.BEHOLDER_FAMILIAR.get()), BeholderFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.FAIRY_FAMILIAR.get()), FairyFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.MUMMY_FAMILIAR.get()), MummyFamiliarRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.THROWN_SWORD.get()), m -> new DragonRendering.ThrownSwordRenderer(m, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.SHUB_NIGGURATH_SPAWN.get()), ShubNiggurathSpawnRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.POSSESSED_ENDERMITE.get()), EndermiteRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.POSSESSED_SKELETON.get()), SkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.POSSESSED_ENDERMAN.get()), EndermanRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.POSSESSED_GHAST.get()), GhastRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.WILD_HUNT_SKELETON.get()), SkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.WILD_HUNT_WITHER_SKELETON.get()), WitherSkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.OTHERWORLD_BIRD.get()), OtherworldBirdRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OccultismTiles.STORAGE_CONTROLLER.get()), StorageControllerGeoRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OccultismTiles.SACRIFICIAL_BOWL.get()), SacrificialBowlRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OccultismTiles.GOLDEN_SACRIFICIAL_BOWL.get()), SacrificialBowlRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_WHITE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_GOLD.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_PURPLE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_RED.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.STABLE_WORMHOLE.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.DATURA.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_FIRE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_LEAVES.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get()), (RenderType)RenderType.func_228641_d_());
        ClientSetupEventHandler.registerItemModelProperties(event);
        event.enqueueWork(() -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.STORAGE_CONTROLLER.get()), StorageControllerGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.STABLE_WORMHOLE.get()), StableWormholeGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.STORAGE_REMOTE.get()), StorageRemoteGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.SPIRIT.get()), SpiritGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.SPIRIT_TRANSPORTER.get()), SpiritTransporterGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.OTHERWORLD_MINER.get()), DimensionalMineshaftScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.SATCHEL.get()), SatchelScreen::new);
            Occultism.LOGGER.debug("Registered Screen Containers");
        });
        Occultism.LOGGER.info("Client setup complete.");
    }

    public static void registerItemModelProperties(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemModelsProperties.func_239418_a_((Item)((Item)OccultismItems.GUIDE_BOOK.get()), (ResourceLocation)new ResourceLocation("completion"), (IItemPropertyGetter)new GuideBookItemPropertyGetter());
            ItemModelsProperties.func_239418_a_((Item)((Item)OccultismItems.SOUL_GEM_ITEM.get()), (ResourceLocation)new ResourceLocation("occultism", "has_entity"), (IItemPropertyGetter)new SoulGemItemPropertyGetter());
            ItemModelsProperties.func_239418_a_((Item)((Item)OccultismItems.DIVINATION_ROD.get()), (ResourceLocation)new ResourceLocation("occultism", "distance"), (IItemPropertyGetter)new DivinationRodItemPropertyGetter());
            ItemModelsProperties.func_239418_a_((Item)((Item)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get()), (ResourceLocation)new ResourceLocation("occultism", "simulated"), (IItemPropertyGetter)new OtherworldBlockItemPropertyGetter());
            ItemModelsProperties.func_239418_a_((Item)((Item)OccultismItems.STORAGE_REMOTE.get()), (ResourceLocation)new ResourceLocation("occultism", "linked"), (IItemPropertyGetter)new StorageRemoteItemPropertyGetter());
            ItemModelsProperties.func_239418_a_((Item)((Item)OccultismItems.STABLE_WORMHOLE.get()), (ResourceLocation)new ResourceLocation("occultism", "linked"), (IItemPropertyGetter)new StableWormholeBlockItemPropertyGetter());
            Occultism.LOGGER.debug("Registered Item Properties");
        });
    }
}

