/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.client.gui.storage.SatchelScreen;
import com.github.klikli_dev.occultism.client.gui.storage.StorageRemoteGui;
import com.github.klikli_dev.occultism.handlers.ClientSetupEventHandler;
import com.github.klikli_dev.occultism.network.MessageDoubleJump;
import com.github.klikli_dev.occultism.network.MessageOpenSatchel;
import com.github.klikli_dev.occultism.network.MessageOpenStorageRemote;
import com.github.klikli_dev.occultism.network.MessageToggleFamiliarSettings;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.CuriosUtil;
import com.github.klikli_dev.occultism.util.MovementUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientPlayerEventHandler {
    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEventHandler.checkBackpackKey((InputEvent)event);
        ClientPlayerEventHandler.checkStorageRemoteKey((InputEvent)event);
        ClientPlayerEventHandler.checkFamiliarSettingsKeys((InputEvent)event);
        if (event.getAction() == 1 && minecraft.field_71474_y.field_74314_A.func_151470_d() && minecraft.field_71439_g != null && MovementUtil.doubleJump((PlayerEntity)minecraft.field_71439_g)) {
            OccultismPackets.sendToServer(new MessageDoubleJump());
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        ClientPlayerEventHandler.checkBackpackKey((InputEvent)event);
        ClientPlayerEventHandler.checkStorageRemoteKey((InputEvent)event);
        ClientPlayerEventHandler.checkFamiliarSettingsKeys((InputEvent)event);
    }

    public static void checkBackpackKey(InputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof SatchelScreen && ClientSetupEventHandler.KEY_BACKPACK.func_151468_f()) {
            minecraft.field_71439_g.func_71053_j();
        } else if (minecraft.field_71439_g != null & minecraft.field_71462_r == null && ClientSetupEventHandler.KEY_BACKPACK.func_151468_f() && (!CuriosUtil.getBackpack((PlayerEntity)minecraft.field_71439_g).func_190926_b() || CuriosUtil.getFirstBackpackSlot((PlayerEntity)minecraft.field_71439_g) > 0)) {
            OccultismPackets.sendToServer(new MessageOpenSatchel());
            minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187728_s, (float)0.75f, (float)1.0f));
        }
    }

    public static void checkStorageRemoteKey(InputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof StorageRemoteGui && ClientSetupEventHandler.KEY_STORAGE_REMOTE.func_151468_f()) {
            minecraft.field_71439_g.func_71053_j();
        } else if (minecraft.field_71439_g != null & minecraft.field_71462_r == null && ClientSetupEventHandler.KEY_STORAGE_REMOTE.func_151468_f() && (!CuriosUtil.getStorageRemoteCurio((PlayerEntity)minecraft.field_71439_g).func_190926_b() || CuriosUtil.getFirstStorageRemoteSlot((PlayerEntity)minecraft.field_71439_g) > 0)) {
            OccultismPackets.sendToServer(new MessageOpenStorageRemote());
            minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187716_o, (float)0.75f, (float)1.0f));
        }
    }

    public static void checkFamiliarSettingsKeys(InputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71439_g != null & minecraft.field_71462_r == null) {
            boolean familiarKeyPressed = false;
            HashMap familiarsPressed = new HashMap();
            for (Map.Entry<EntityType<?>, KeyBinding> entry : ClientSetupEventHandler.keysFamiliars.entrySet()) {
                boolean isPressed = entry.getValue().func_151468_f();
                if (isPressed) {
                    familiarKeyPressed = true;
                }
                familiarsPressed.put(entry.getKey(), isPressed);
            }
            if (familiarKeyPressed) {
                OccultismPackets.sendToServer(new MessageToggleFamiliarSettings(familiarsPressed));
            }
        }
    }
}

