/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.common.capability.DoubleJumpCapability;
import com.github.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.github.klikli_dev.occultism.network.MessageSetJumps;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.player.func_233570_aj_()) {
            evt.player.getCapability(OccultismCapabilities.DOUBLE_JUMP).ifPresent(cap -> cap.setJumps(0));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        ServerPlayerEntity player;
        int jumps;
        if (evt.getEntity() instanceof ServerPlayerEntity && (jumps = (player = (ServerPlayerEntity)evt.getEntity()).getCapability(OccultismCapabilities.DOUBLE_JUMP).map(DoubleJumpCapability::getJumps).orElse(0).intValue()) > 0) {
            OccultismPackets.sendTo(player, new MessageSetJumps(jumps));
        }
    }

    @SubscribeEvent
    public static void onEntityConstructing(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof PlayerEntity) {
            if (!((Entity)evt.getObject()).getCapability(OccultismCapabilities.DOUBLE_JUMP).isPresent()) {
                evt.addCapability(OccultismCapabilities.DOUBLE_JUMP_ID, (ICapabilityProvider)new DoubleJumpCapability.Dispatcher());
            }
            if (!((Entity)evt.getObject()).getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).isPresent()) {
                evt.addCapability(OccultismCapabilities.FAMILIAR_SETTINGS_ID, (ICapabilityProvider)new FamiliarSettingsCapability.Dispatcher());
            }
        }
    }
}

