/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.common.misc.WeightedIngredient;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MinerRecipe
implements IRecipe<RecipeWrapper> {
    public static Serializer SERIALIZER = new Serializer();
    protected final ResourceLocation id;
    protected final Ingredient input;
    protected final WeightedIngredient output;

    public MinerRecipe(ResourceLocation id, Ingredient input, WeightedIngredient output) {
        this.input = input;
        this.output = output;
        this.id = id;
    }

    public WeightedIngredient getWeightedOutput() {
        return this.output;
    }

    public boolean matches(RecipeWrapper inv, World world) {
        return this.input.test(inv.func_70301_a(0));
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output.getStack();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)OccultismRecipes.MINER_TYPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MinerRecipe> {
        public MinerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray ingredientElement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientElement);
            JsonObject resultElement = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            Ingredient result = Ingredient.func_199802_a((JsonElement)resultElement);
            int weight = JSONUtils.func_151203_m((JsonObject)json, (String)"weight");
            return new MinerRecipe(recipeId, ingredient, new WeightedIngredient(result, weight));
        }

        public MinerRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient result = Ingredient.func_199566_b((PacketBuffer)buffer);
            int weight = buffer.readInt();
            return new MinerRecipe(recipeId, ingredient, new WeightedIngredient(result, weight));
        }

        public void toNetwork(PacketBuffer buffer, MinerRecipe recipe) {
            recipe.input.func_199564_a(buffer);
            recipe.output.getIngredient().func_199564_a(buffer);
            buffer.writeInt(recipe.output.field_76292_a);
        }
    }
}

