/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.tile;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.api.common.container.IItemStackComparator;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.api.common.tile.IStorageAccessor;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.api.common.tile.IStorageControllerProxy;
import com.github.klikli_dev.occultism.common.block.storage.StorageStabilizerBlock;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.common.misc.DepositOrder;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.common.misc.StorageControllerItemStackHandler;
import com.github.klikli_dev.occultism.common.tile.NetworkedTileEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.network.MessageUpdateStacks;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.EntityUtil;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class StorageControllerTileEntity
extends NetworkedTileEntity
implements IAnimatable,
ITickableTileEntity,
INamedContainerProvider,
IStorageController,
IStorageAccessor,
IStorageControllerProxy {
    public static final int MAX_STABILIZER_DISTANCE = 5;
    protected static final List<RegistryObject<? extends Block>> BLOCK_BLACKLIST = Stream.of(OccultismBlocks.STORAGE_CONTROLLER).collect(Collectors.toList());
    public Map<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
    public ItemStack orderStack = ItemStack.field_190927_a;
    public Map<GlobalBlockPos, MachineReference> linkedMachines = new HashMap<GlobalBlockPos, MachineReference>();
    public Map<GlobalBlockPos, UUID> depositOrderSpirits = new HashMap<GlobalBlockPos, UUID>();
    protected SortDirection sortDirection = SortDirection.DOWN;
    protected SortType sortType = SortType.AMOUNT;
    protected ItemStackHandler itemStackHandlerInternal;
    protected LazyOptional<ItemStackHandler> itemStackHandler;
    protected int maxSlots;
    protected int usedSlots;
    protected boolean stabilizersInitialized;
    protected GlobalBlockPos globalPos;
    protected MessageUpdateStacks cachedMessageUpdateStacks;
    private AnimationFactory factory;

    public StorageControllerTileEntity() {
        super((TileEntityType)OccultismTiles.STORAGE_CONTROLLER.get());
        this.itemStackHandlerInternal = new StorageControllerItemStackHandler(this, Occultism.SERVER_CONFIG.storage.controllerBaseSlots.get(), Occultism.SERVER_CONFIG.storage.controllerStackSize.get(), Occultism.SERVER_CONFIG.storage.overrideItemStackSizes.get());
        this.itemStackHandler = LazyOptional.of(() -> this.itemStackHandlerInternal);
        this.maxSlots = Occultism.SERVER_CONFIG.storage.controllerBaseSlots.get();
        this.usedSlots = 0;
        this.stabilizersInitialized = false;
        this.factory = new AnimationFactory((IAnimatable)this);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Override
    public IStorageController getLinkedStorageController() {
        return this;
    }

    @Override
    public GlobalBlockPos getLinkedStorageControllerPosition() {
        if (this.globalPos == null) {
            this.globalPos = new GlobalBlockPos(this.func_174877_v(), this.field_145850_b);
        }
        return this.globalPos;
    }

    @Override
    public void setLinkedStorageControllerPosition(GlobalBlockPos blockPos) {
    }

    @Override
    public Map<Integer, ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public ItemStack getOrderStack() {
        return this.orderStack;
    }

    @Override
    public void setOrderStack(@Nonnull ItemStack stack) {
        this.orderStack = stack;
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Override
    public SortType getSortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public List<ItemStack> getStacks() {
        ItemStackHandler handler = (ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        int size = handler.getSlots();
        int usedSlots = 0;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(size);
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            ++usedSlots;
            this.mergeIntoList(result, stack.func_77946_l());
        }
        this.usedSlots = usedSlots;
        return result;
    }

    @Override
    public MessageUpdateStacks getMessageUpdateStacks() {
        if (this.cachedMessageUpdateStacks == null) {
            List<ItemStack> stacks = this.getStacks();
            this.cachedMessageUpdateStacks = new MessageUpdateStacks(stacks, this.getUsedSlots(), this.getMaxSlots());
        }
        return this.cachedMessageUpdateStacks;
    }

    @Override
    public int getMaxSlots() {
        return this.maxSlots;
    }

    @Override
    public void setMaxSlots(int slots) {
        this.maxSlots = slots;
        ((ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new)).setSize(this.maxSlots);
        this.cachedMessageUpdateStacks = null;
        this.markNetworkDirty();
    }

    @Override
    public int getUsedSlots() {
        return this.usedSlots;
    }

    @Override
    public Map<GlobalBlockPos, MachineReference> getLinkedMachines() {
        return this.linkedMachines;
    }

    @Override
    public void setLinkedMachines(Map<GlobalBlockPos, MachineReference> machines) {
        this.linkedMachines = machines;
    }

    @Override
    public void linkMachine(MachineReference machine) {
        this.linkedMachines.put(machine.globalPos, machine);
    }

    @Override
    public void addDepositOrder(GlobalBlockPos linkedMachinePosition, IItemStackComparator comparator, int amount) {
        ItemStack stack = this.getItemStack(comparator, amount, true);
        if (!stack.func_190926_b()) {
            UUID spiritUUID = this.depositOrderSpirits.get(linkedMachinePosition);
            if (spiritUUID != null) {
                EntityUtil.getEntityByUuiDGlobal(this.field_145850_b.func_73046_m(), spiritUUID).filter(SpiritEntity.class::isInstance).map(SpiritEntity.class::cast).ifPresent(spirit -> {
                    Optional<ManageMachineJob> job = spirit.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast);
                    if (job.isPresent()) {
                        job.get().addDepsitOrder(new DepositOrder((ItemStackComparator)comparator, amount));
                    } else {
                        this.removeDepositOrderSpirit(linkedMachinePosition);
                    }
                });
            } else {
                this.removeDepositOrderSpirit(linkedMachinePosition);
            }
        }
    }

    @Override
    public void addDepositOrderSpirit(GlobalBlockPos linkedMachinePosition, UUID spiritId) {
        this.depositOrderSpirits.put(linkedMachinePosition, spiritId);
    }

    @Override
    public void removeDepositOrderSpirit(GlobalBlockPos linkedMachinePosition) {
        this.linkedMachines.remove(linkedMachinePosition);
        this.depositOrderSpirits.remove(linkedMachinePosition);
    }

    @Override
    public boolean isBlacklisted(ItemStack stack) {
        if (stack.func_77973_b() instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)stack.func_77973_b();
            return BLOCK_BLACKLIST.stream().map(RegistryObject::get).anyMatch(block -> itemBlock.func_179223_d() == block);
        }
        return stack.func_77973_b() == OccultismItems.STORAGE_REMOTE.get();
    }

    @Override
    public int insertStack(ItemStack stack, boolean simulate) {
        if (this.isBlacklisted(stack)) {
            return stack.func_190916_E();
        }
        ItemStackHandler handler = (ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true).func_190916_E() < stack.func_190916_E()) {
            stack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack.func_190916_E();
    }

    @Override
    public ItemStack getItemStack(Predicate<ItemStack> comparator, int requestedSize, boolean simulate) {
        if (requestedSize <= 0 || comparator == null) {
            return ItemStack.field_190927_a;
        }
        ItemStackHandler handler = (ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        ItemStack firstMatchedStack = ItemStack.field_190927_a;
        int remaining = requestedSize;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.extractItem(slot, remaining, true);
            if (stack.func_190926_b()) continue;
            if (firstMatchedStack.func_190926_b()) {
                if (!comparator.test(stack)) continue;
                firstMatchedStack = stack.func_77946_l();
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)firstMatchedStack, (ItemStack)stack)) continue;
            int toExtract = Math.min(stack.func_190916_E(), remaining);
            ItemStack extractedStack = handler.extractItem(slot, toExtract, simulate);
            if ((remaining -= extractedStack.func_190916_E()) <= 0) break;
        }
        int extractCount = requestedSize - remaining;
        if (!firstMatchedStack.func_190926_b() && extractCount > 0) {
            firstMatchedStack.func_190920_e(extractCount);
        }
        return firstMatchedStack;
    }

    @Override
    public int getAvailableAmount(IItemStackComparator comparator) {
        if (comparator == null) {
            return 0;
        }
        int totalCount = 0;
        ItemStackHandler handler = (ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        int size = handler.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (!comparator.matches(stack)) continue;
            totalCount += stack.func_190916_E();
        }
        return totalCount;
    }

    @Override
    public void onContentsChanged() {
        this.cachedMessageUpdateStacks = null;
        this.func_70296_d();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemStackHandler.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemStackHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.stabilizersInitialized) {
            this.stabilizersInitialized = true;
            this.updateStabilizers();
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        compound.func_82580_o("linkedMachines");
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l("items")));
            this.cachedMessageUpdateStacks = null;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_82580_o("linkedMachines");
        this.itemStackHandler.ifPresent(handler -> compound.func_218657_a("items", (INBT)handler.serializeNBT()));
        return compound;
    }

    @Override
    public void readNetwork(CompoundNBT compound) {
        int i;
        this.setSortDirection(SortDirection.get(compound.func_74762_e("sortDirection")));
        this.setSortType(SortType.get(compound.func_74762_e("sortType")));
        if (compound.func_74764_b("maxSlots")) {
            this.setMaxSlots(compound.func_74762_e("maxSlots"));
        }
        this.matrix = new HashMap<Integer, ItemStack>();
        if (compound.func_74764_b("matrix")) {
            ListNBT matrixNbt = compound.func_150295_c("matrix", 10);
            for (i = 0; i < matrixNbt.size(); ++i) {
                CompoundNBT stackTag = matrixNbt.func_150305_b(i);
                byte slot = stackTag.func_74771_c("slot");
                ItemStack s = ItemStack.func_199557_a((CompoundNBT)stackTag);
                this.matrix.put(Integer.valueOf(slot), s);
            }
        }
        if (compound.func_74764_b("orderStack")) {
            this.orderStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("orderStack"));
        }
        this.linkedMachines = new HashMap<GlobalBlockPos, MachineReference>();
        if (compound.func_74764_b("linkedMachines")) {
            ListNBT machinesNbt = compound.func_150295_c("linkedMachines", 10);
            for (i = 0; i < machinesNbt.size(); ++i) {
                MachineReference reference = MachineReference.from(machinesNbt.func_150305_b(i));
                this.linkedMachines.put(reference.globalPos, reference);
            }
        }
    }

    @Override
    public CompoundNBT writeNetwork(CompoundNBT compound) {
        compound.func_74768_a("sortDirection", this.getSortDirection().getValue());
        compound.func_74768_a("sortType", this.getSortType().getValue());
        compound.func_74768_a("maxSlots", this.maxSlots);
        ListNBT matrixNbt = new ListNBT();
        for (int i = 0; i < 9; ++i) {
            if (this.matrix.get(i) == null || this.matrix.get(i).func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            stackTag.func_74774_a("slot", (byte)i);
            this.matrix.get(i).func_77955_b(stackTag);
            matrixNbt.add((Object)stackTag);
        }
        compound.func_218657_a("matrix", (INBT)matrixNbt);
        if (!this.orderStack.func_190926_b()) {
            compound.func_218657_a("orderStack", (INBT)this.orderStack.func_77955_b(new CompoundNBT()));
        }
        ListNBT machinesNbt = new ListNBT();
        for (Map.Entry<GlobalBlockPos, MachineReference> entry : this.linkedMachines.entrySet()) {
            machinesNbt.add((Object)entry.getValue().serializeNBT());
        }
        compound.func_218657_a("linkedMachines", (INBT)machinesNbt);
        return compound;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new StorageControllerContainer(id, playerInventory, this);
    }

    public void updateStabilizers() {
        int additionalSlots = 0;
        List<BlockPos> stabilizerLocations = this.findValidStabilizers();
        for (BlockPos pos : stabilizerLocations) {
            additionalSlots += this.getSlotsForStabilizer(this.field_145850_b.func_180495_p(pos));
        }
        this.setMaxSlots(Occultism.SERVER_CONFIG.storage.controllerBaseSlots.get() + additionalSlots);
    }

    public List<BlockPos> findValidStabilizers() {
        ArrayList<BlockPos> validStabilizers = new ArrayList<BlockPos>();
        BlockPos up = this.field_174879_c.func_177984_a();
        for (Direction face : Direction.values()) {
            BlockState state;
            BlockPos hit = Math3DUtil.simpleTrace(up, face, 5, pos -> {
                BlockState state = this.field_145850_b.func_180495_p(pos);
                return state.func_177230_c() instanceof StorageStabilizerBlock;
            });
            if (hit == null || (state = this.field_145850_b.func_180495_p(hit)).func_177229_b((Property)DirectionalBlock.field_176387_N) != face.func_176734_d()) continue;
            validStabilizers.add(hit);
        }
        return validStabilizers;
    }

    protected int getSlotsForStabilizer(BlockState state) {
        Block block = state.func_177230_c();
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER1.get()) {
            return Occultism.SERVER_CONFIG.storage.stabilizerTier1Slots.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER2.get()) {
            return Occultism.SERVER_CONFIG.storage.stabilizerTier2Slots.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER3.get()) {
            return Occultism.SERVER_CONFIG.storage.stabilizerTier3Slots.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER4.get()) {
            return Occultism.SERVER_CONFIG.storage.stabilizerTier4Slots.get();
        }
        return 0;
    }

    protected void mergeIntoList(List<ItemStack> list, ItemStack stackToAdd) {
        boolean merged = false;
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackToAdd, (ItemStack)stack)) continue;
            stack.func_190920_e(stack.func_190916_E() + stackToAdd.func_190916_E());
            merged = true;
            break;
        }
        if (!merged) {
            list.add(stackToAdd);
        }
    }

    protected void validateLinkedMachines() {
        this.linkedMachines.entrySet().removeIf(entry -> ((MachineReference)entry.getValue()).getTileEntity(this.field_145850_b) == null);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dimensional_matrix.new", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

