/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual.pentacle;

import com.github.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class Pentacle {
    private final ResourceLocation rl;
    private final List<String> pattern;
    private final Map<Character, JsonElement> mappings;
    private final IMultiblock matcher;

    public Pentacle(ResourceLocation rl, List<String> pattern, Map<Character, JsonElement> mappings) {
        this.rl = rl;
        this.pattern = pattern;
        this.mappings = mappings;
        for (String r1 : pattern) {
            for (String r2 : pattern) {
                if (r1.length() == r2.length()) continue;
                throw new IllegalArgumentException("Pentacle pattern can not have rows with different lengths");
            }
        }
        for (String row : pattern) {
            for (Object c : (Object)row.toCharArray()) {
                if (c == 32 || mappings.containsKey(Character.valueOf((char)c))) continue;
                throw new IllegalArgumentException("Pentacle mappings is missing " + (char)c);
            }
        }
        PatchouliAPI.IPatchouliAPI api = PatchouliAPI.get();
        String[][] multiPattern = new String[1][pattern.size()];
        for (int i = 0; i < pattern.size(); ++i) {
            multiPattern[0][i] = pattern.get(pattern.size() - 1 - i);
        }
        ArrayList<Character> multiMappings = new ArrayList<Character>();
        for (Map.Entry<Character, JsonElement> entry : mappings.entrySet()) {
            multiMappings.add(entry.getKey());
            multiMappings.add((Character)Pentacle.parseStateMatcher(entry.getValue()));
        }
        multiMappings.add(Character.valueOf(' '));
        multiMappings.add((Character)api.anyMatcher());
        ResourceLocation multiRL = new ResourceLocation(rl.func_110624_b(), "pentacle." + rl.func_110623_a());
        this.matcher = api.makeMultiblock(multiPattern, multiMappings.toArray());
        this.matcher.setId(multiRL);
        try {
            PatchouliAPI.get().registerMultiblock(multiRL, this.matcher);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static Pentacle fromJson(ResourceLocation rl, JsonObject json) {
        JsonArray jsonPattern = JSONUtils.func_151214_t((JsonObject)json, (String)"pattern");
        JsonObject jsonMapping = JSONUtils.func_152754_s((JsonObject)json, (String)"mapping");
        ArrayList<String> pattern = new ArrayList<String>();
        HashMap<Character, JsonElement> mappings = new HashMap<Character, JsonElement>();
        for (int i = 0; i < jsonPattern.size(); ++i) {
            pattern.add(JSONUtils.func_151206_a((JsonElement)jsonPattern.get(i), (String)"row"));
        }
        for (Map.Entry entry : jsonMapping.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Mapping key needs to be only 1 character");
            }
            char key = ((String)entry.getKey()).charAt(0);
            mappings.put(Character.valueOf(key), (JsonElement)entry.getValue());
        }
        return new Pentacle(rl, pattern, mappings);
    }

    public static IStateMatcher parseStateMatcher(JsonElement matcher) {
        ResourceLocation blockRL;
        Block block;
        if (matcher.isJsonObject()) {
            ResourceLocation displayRL;
            JsonObject jsonObject = matcher.getAsJsonObject();
            Block display = null;
            if (jsonObject.has("display") && (display = (Block)ForgeRegistries.BLOCKS.getValue(displayRL = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"display")))) == null) {
                throw new JsonSyntaxException("Invalid display" + displayRL);
            }
            if (jsonObject.has("block")) {
                ResourceLocation blockRL2 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"block"));
                Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(blockRL2);
                if (block2 == null) {
                    throw new JsonSyntaxException("Invalid block " + blockRL2);
                }
                if (display != null) {
                    return Pentacle.OM(PatchouliAPI.get().predicateMatcher(display, s -> s.func_177230_c() == block2), block2);
                }
                return Pentacle.OM(PatchouliAPI.get().looseBlockMatcher(block2), block2);
            }
            if (jsonObject.has("tag")) {
                ResourceLocation tagRL = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
                ITag tag = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(tagRL);
                if (tag == null) {
                    throw new JsonSyntaxException("Invalid tag " + tagRL);
                }
                if (display == null) {
                    throw new JsonSyntaxException("No display set for tag " + tagRL);
                }
                return Pentacle.OM(PatchouliAPI.get().predicateMatcher(display, s -> tag.func_230235_a_((Object)s.func_177230_c())));
            }
            if (display != null) {
                return Pentacle.OM(PatchouliAPI.get().displayOnlyMatcher(display));
            }
        }
        if ((block = (Block)ForgeRegistries.BLOCKS.getValue(blockRL = new ResourceLocation(matcher.getAsString()))) == null) {
            throw new JsonSyntaxException("Invalid block " + blockRL);
        }
        return Pentacle.OM(PatchouliAPI.get().looseBlockMatcher(block), block);
    }

    public static Pentacle decode(ResourceLocation key, PacketBuffer buffer) {
        ArrayList<String> pattern = new ArrayList<String>();
        HashMap<Character, JsonElement> mappings = new HashMap<Character, JsonElement>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            pattern.add(buffer.func_218666_n());
        }
        size = buffer.readInt();
        JsonParser parser = new JsonParser();
        for (int i = 0; i < size; ++i) {
            mappings.put(Character.valueOf(buffer.readChar()), parser.parse(buffer.func_218666_n()));
        }
        return new Pentacle(key, pattern, mappings);
    }

    public String getTranslationKey() {
        return Util.func_200697_a((String)"pentacle", (ResourceLocation)this.rl);
    }

    public boolean validate(World world, BlockPos pos) {
        return this.matcher.validate(world, pos) != null;
    }

    public Map<BlockPos, Block> getDifference(World world, BlockPos pos) {
        HashMap<BlockPos, Block> minDifference = new HashMap<BlockPos, Block>();
        int minDiffSize = Integer.MAX_VALUE;
        for (Rotation rot : Rotation.values()) {
            HashMap<BlockPos, Block> difference = new HashMap<BlockPos, Block>();
            Pair sim = this.matcher.simulate(world, pos, rot, false);
            for (IMultiblock.SimulateResult result : (Collection)sim.getSecond()) {
                if (result.test(world, rot)) continue;
                difference.put(result.getWorldPosition(), result.getStateMatcher().getDisplayedState(0).func_177230_c());
            }
            if (difference.size() >= minDiffSize) continue;
            minDifference = difference;
            minDiffSize = difference.size();
        }
        return minDifference;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray jsonPattern = new JsonArray();
        for (String row : this.pattern) {
            jsonPattern.add(row);
        }
        json.add("pattern", (JsonElement)jsonPattern);
        JsonObject jsonMapping = new JsonObject();
        for (Map.Entry<Character, JsonElement> entry : this.mappings.entrySet()) {
            jsonMapping.add(String.valueOf(entry.getKey()), entry.getValue());
        }
        json.add("mapping", (JsonElement)jsonMapping);
        return json;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.pattern.size());
        for (String string : this.pattern) {
            buffer.func_180714_a(string);
        }
        buffer.writeInt(this.mappings.size());
        for (Map.Entry entry : this.mappings.entrySet()) {
            buffer.writeChar((int)((Character)entry.getKey()).charValue());
            buffer.func_180714_a(((JsonElement)entry.getValue()).toString());
        }
    }

    private static OccultismMatcher OM(IStateMatcher matcher) {
        return new OccultismMatcher(matcher);
    }

    private static OccultismMatcher OM(IStateMatcher matcher, Block block) {
        return new OccultismMatcher(matcher, block);
    }

    private static class OccultismMatcher
    implements IStateMatcher {
        private IStateMatcher matcher;
        private Block block;

        private OccultismMatcher(IStateMatcher matcher, Block block) {
            this.matcher = matcher;
            this.block = block;
        }

        private OccultismMatcher(IStateMatcher matcher) {
            this(matcher, (Block)null);
        }

        public BlockState getDisplayedState(int ticks) {
            if (this.block instanceof ChalkGlyphBlock) {
                return (BlockState)this.block.func_176223_P().func_206870_a((Property)ChalkGlyphBlock.SIGN, (Comparable)Integer.valueOf(ticks / 20 % 12));
            }
            return this.matcher.getDisplayedState(ticks);
        }

        public TriPredicate<IBlockReader, BlockPos, BlockState> getStatePredicate() {
            return this.matcher.getStatePredicate();
        }
    }
}

