/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual;

import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.ritual.Ritual;
import com.github.klikli_dev.occultism.common.tile.GoldenSacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;

public class SummonRitual
extends Ritual {
    private final boolean tame;

    public SummonRitual(RitualRecipe recipe, boolean tame) {
        super(recipe);
        this.tame = tame;
    }

    public ItemStack getBookOfCallingBound(ItemStack activationItem) {
        ItemStack result = this.recipe.func_77571_b().func_77946_l();
        if (result.func_77973_b() == OccultismItems.JEI_DUMMY_NONE.get()) {
            return ItemStack.field_190927_a;
        }
        if (activationItem.func_77942_o()) {
            result.func_77982_d(activationItem.func_77978_p().func_74737_b());
        }
        return result;
    }

    public void finishBookOfCallingSetup(ItemStack bookOfCalling, SpiritEntity spirit, PlayerEntity player) {
        ItemNBTUtil.setSpiritEntityUUID(bookOfCalling, spirit.func_110124_au());
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)bookOfCalling);
    }

    public void spawnEntity(Entity entity, World world) {
        for (ServerPlayerEntity player : world.func_217357_a(ServerPlayerEntity.class, entity.func_174813_aQ().func_186662_g(50.0))) {
            CriteriaTriggers.field_192133_m.func_192229_a(player, entity);
        }
        world.func_217376_c(entity);
    }

    @Override
    public void finish(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        Entity entity;
        super.finish(world, goldenBowlPosition, tileEntity, castingPlayer, activationItem);
        ItemStack copy = activationItem.func_77946_l();
        ItemStack result = this.getBookOfCallingBound(activationItem);
        activationItem.func_190918_g(1);
        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)goldenBowlPosition.func_177958_n() + 0.5, (double)goldenBowlPosition.func_177956_o() + 0.5, (double)goldenBowlPosition.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        EntityType<?> entityType = this.recipe.getEntityToSummon();
        if (entityType != null && (entity = this.createSummonedEntity(entityType, world, goldenBowlPosition, tileEntity, castingPlayer)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.prepareLivingEntityForSpawn(living, world, goldenBowlPosition, tileEntity, castingPlayer, ItemNBTUtil.getBoundSpiritName(copy), this.tame);
            this.initSummoned(living, world, goldenBowlPosition, tileEntity, castingPlayer);
            this.spawnEntity((Entity)living, world);
            if (result != ItemStack.field_190927_a && living instanceof SpiritEntity) {
                this.finishBookOfCallingSetup(result, (SpiritEntity)living, castingPlayer);
            }
        }
    }

    public Entity createSummonedEntity(EntityType<?> entityType, World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer) {
        return entityType.func_200721_a(world);
    }

    public void initSummoned(LivingEntity living, World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer) {
        if (living instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)living;
            spirit.setSpiritMaxAge(this.recipe.getSpiritMaxAge());
        }
    }
}

