/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.misc;

import com.github.klikli_dev.occultism.api.common.container.IItemStackComparator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ItemStackComparator
implements IItemStackComparator {
    protected ItemStack filterStack;
    protected boolean matchNbt;

    public ItemStackComparator(ItemStack stack) {
        this(stack, false);
    }

    public ItemStackComparator(ItemStack filterStack, boolean matchNbt) {
        this.filterStack = filterStack;
        this.matchNbt = matchNbt;
    }

    private ItemStackComparator() {
    }

    public static ItemStackComparator from(CompoundNBT nbt) {
        ItemStackComparator comparator = new ItemStackComparator();
        comparator.deserializeNBT(nbt);
        return !comparator.filterStack.func_190926_b() ? comparator : null;
    }

    public boolean getMatchNbt() {
        return this.matchNbt;
    }

    public void setMatchNbt(boolean matchNbt) {
        this.matchNbt = matchNbt;
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public void setFilterStack(@Nonnull ItemStack filterStack) {
        this.filterStack = filterStack;
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.matchNbt && !ItemStack.func_77970_a((ItemStack)this.filterStack, (ItemStack)stack)) {
            return false;
        }
        return stack.func_77973_b() == this.filterStack.func_77973_b();
    }

    public CompoundNBT serializeNBT() {
        return this.write(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.read(nbt);
    }

    public void read(CompoundNBT compound) {
        CompoundNBT nbt = compound.func_74775_l("stack");
        this.filterStack = ItemStack.func_199557_a((CompoundNBT)nbt);
        this.matchNbt = compound.func_74767_n("matchNbt");
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_218657_a("stack", (INBT)this.filterStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a("matchNbt", this.matchNbt);
        return compound;
    }
}

