/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.entity.ai.DepositItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.FallbackDepositToControllerGoal;
import com.github.klikli_dev.occultism.common.entity.ai.ManageMachineGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.common.misc.DepositOrder;
import com.github.klikli_dev.occultism.util.TileEntityUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.tileentity.TileEntity;

public class ManageMachineJob
extends SpiritJob {
    protected DepositItemsGoal depositItemsGoal;
    protected ManageMachineGoal manageMachineGoal;
    protected FallbackDepositToControllerGoal fallbackDepositToControllerGoal;
    protected OpenDoorGoal openDoorGoal;
    protected GlobalBlockPos storageControllerPosition;
    protected MachineReference managedMachine;
    protected DepositOrder currentDepositOrder;
    protected Queue<DepositOrder> depositOrderQueue = new ArrayDeque<DepositOrder>();
    protected IStorageController storageController;
    protected TileEntity managedMachineTileEntity;

    public ManageMachineJob(SpiritEntity entity) {
        super(entity);
    }

    public DepositOrder getCurrentDepositOrder() {
        return this.currentDepositOrder;
    }

    public void setCurrentDepositOrder(DepositOrder order) {
        this.currentDepositOrder = order;
    }

    public MachineReference getManagedMachine() {
        return this.managedMachine;
    }

    public void setManagedMachine(MachineReference managedMachine) {
        if (this.managedMachine != null) {
            this.unregisterFromStorageController();
        }
        this.managedMachine = managedMachine;
        this.managedMachineTileEntity = null;
        this.clearAllOrders();
        this.registerWithStorageController();
    }

    public GlobalBlockPos getStorageControllerPosition() {
        return this.storageControllerPosition;
    }

    public void setStorageControllerPosition(GlobalBlockPos storageControllerPosition) {
        if (this.storageControllerPosition != null) {
            this.unregisterFromStorageController();
        }
        this.storageControllerPosition = storageControllerPosition;
        this.storageController = null;
        this.clearAllOrders();
        this.registerWithStorageController();
    }

    public IStorageController getStorageController() {
        if (this.storageControllerPosition == null) {
            return null;
        }
        if (this.storageController == null) {
            this.storageController = (IStorageController)TileEntityUtil.get(this.entity.field_70170_p, this.storageControllerPosition);
        }
        if (this.storageController == null) {
            this.storageControllerPosition = null;
        }
        return this.storageController;
    }

    public TileEntity getManagedMachineTileEntity() {
        if (this.managedMachine == null) {
            return null;
        }
        if (this.managedMachineTileEntity == null) {
            this.managedMachineTileEntity = TileEntityUtil.get(this.entity.field_70170_p, this.managedMachine.globalPos);
        }
        return this.managedMachineTileEntity;
    }

    @Override
    public void init() {
        this.entity.func_70661_as().func_189566_q().func_186317_a(true);
        ((GroundPathNavigator)this.entity.func_70661_as()).func_179688_b(true);
        this.manageMachineGoal = new ManageMachineGoal(this.entity, this);
        this.entity.field_70714_bg.func_75776_a(3, (Goal)this.manageMachineGoal);
        this.fallbackDepositToControllerGoal = new FallbackDepositToControllerGoal(this.entity, this);
        this.entity.field_70714_bg.func_75776_a(4, (Goal)this.fallbackDepositToControllerGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.field_70714_bg.func_75776_a(4, (Goal)this.depositItemsGoal);
        this.openDoorGoal = new OpenDoorGoal((MobEntity)this.entity, true);
        this.entity.field_70714_bg.func_75776_a(5, (Goal)this.openDoorGoal);
        this.registerWithStorageController();
    }

    @Override
    public void cleanup() {
        this.entity.func_70661_as().func_189566_q().func_186317_a(false);
        ((GroundPathNavigator)this.entity.func_70661_as()).func_179688_b(false);
        this.entity.field_70714_bg.func_85156_a((Goal)this.depositItemsGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.manageMachineGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.openDoorGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.fallbackDepositToControllerGoal);
        this.unregisterFromStorageController();
    }

    @Override
    public void update() {
        if (this.storageControllerPosition != null && this.managedMachine != null && this.getCurrentDepositOrder() == null && !this.depositOrderQueue.isEmpty()) {
            this.setCurrentDepositOrder(this.depositOrderQueue.poll());
        }
        if (this.currentDepositOrder != null && this.currentDepositOrder.comparator == null) {
            this.setCurrentDepositOrder(null);
        }
    }

    @Override
    public CompoundNBT writeJobToNBT(CompoundNBT compound) {
        if (this.storageControllerPosition != null) {
            compound.func_218657_a("storageControllerPosition", (INBT)this.storageControllerPosition.serializeNBT());
        }
        if (this.managedMachine != null) {
            compound.func_218657_a("managedMachine", (INBT)this.managedMachine.serializeNBT());
        }
        if (this.getCurrentDepositOrder() != null) {
            compound.func_218657_a("currentDepositOrder", (INBT)this.getCurrentDepositOrder().writeToNBT(new CompoundNBT()));
        }
        ListNBT nbtOrderList = new ListNBT();
        for (DepositOrder depositOrder : this.depositOrderQueue) {
            nbtOrderList.add((Object)depositOrder.writeToNBT(new CompoundNBT()));
        }
        compound.func_218657_a("depositOrders", (INBT)nbtOrderList);
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundNBT compound) {
        if (compound.func_74764_b("storageControllerPosition")) {
            this.storageControllerPosition = GlobalBlockPos.from(compound.func_74775_l("storageControllerPosition"));
        }
        if (compound.func_74764_b("managedMachine")) {
            this.managedMachine = MachineReference.from(compound.func_74775_l("managedMachine"));
        }
        if (compound.func_74764_b("currentDepositOrder")) {
            this.setCurrentDepositOrder(DepositOrder.from(compound.func_74775_l("currentDepositOrder")));
        }
        this.depositOrderQueue = new ArrayDeque<DepositOrder>();
        if (compound.func_74764_b("depositOrders")) {
            ListNBT nbtOrderList = compound.func_150295_c("depositOrders", 10);
            for (int i = 0; i < nbtOrderList.size(); ++i) {
                DepositOrder depositOrder = DepositOrder.from(nbtOrderList.func_150305_b(i));
                this.depositOrderQueue.add(depositOrder);
            }
        }
        super.readJobFromNBT(compound);
    }

    public void addDepsitOrder(DepositOrder order) {
        this.depositOrderQueue.add(order);
    }

    public void clearAllOrders() {
        this.currentDepositOrder = null;
        this.depositOrderQueue.clear();
    }

    protected void registerWithStorageController() {
        IStorageController storageController = this.getStorageController();
        if (storageController != null && this.managedMachine != null) {
            storageController.addDepositOrderSpirit(this.managedMachine.globalPos, this.entity.func_110124_au());
            storageController.linkMachine(this.managedMachine);
            TileEntityUtil.updateTile(this.entity.field_70170_p, this.getStorageControllerPosition().getPos());
        }
    }

    protected void unregisterFromStorageController() {
        IStorageController storageController;
        if (this.storageControllerPosition != null && this.managedMachine != null && (storageController = this.getStorageController()) != null) {
            storageController.removeDepositOrderSpirit(this.managedMachine.globalPos);
        }
    }
}

