/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.spirit;

import com.github.klikli_dev.occultism.common.entity.spirit.WildHuntSkeletonEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class WildHuntWitherSkeletonEntity
extends WitherSkeletonEntity {
    List<WildHuntSkeletonEntity> minions = new ArrayList<WildHuntSkeletonEntity>();

    public WildHuntWitherSkeletonEntity(EntityType<? extends WildHuntWitherSkeletonEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return SkeletonEntity.func_234275_m_().func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 60.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int maxSkeletons = 3 + world.func_201674_k().nextInt(6);
        for (int i = 0; i < maxSkeletons; ++i) {
            WildHuntSkeletonEntity entity = (WildHuntSkeletonEntity)((EntityType)OccultismEntities.WILD_HUNT_SKELETON.get()).func_200721_a(this.field_70170_p);
            entity.func_213386_a(world, difficultyIn, reason, spawnDataIn, dataTag);
            double offsetX = world.func_201674_k().nextGaussian() * (double)(1 + world.func_201674_k().nextInt(4));
            double offsetZ = world.func_201674_k().nextGaussian() * (double)(1 + world.func_201674_k().nextInt(4));
            entity.func_70080_a(this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.5, this.func_226281_cx_() + offsetZ, world.func_201674_k().nextInt(360), 0.0f);
            entity.func_200203_b((ITextComponent)new StringTextComponent(TextUtil.generateName()));
            world.func_217376_c((Entity)entity);
            entity.setMaster(this);
            this.minions.add(entity);
        }
        return super.func_213386_a(world, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean func_225511_J_() {
        return false;
    }

    protected boolean func_204609_dp() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        ITag<EntityType<?>> wildHuntTag = OccultismTags.WILD_HUNT;
        Entity trueSource = source.func_76346_g();
        if (trueSource != null && wildHuntTag.func_230235_a_((Object)trueSource.func_200600_R())) {
            return true;
        }
        Entity immediateSource = source.func_76364_f();
        if (immediateSource != null && wildHuntTag.func_230235_a_((Object)immediateSource.func_200600_R())) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean func_190530_aW() {
        return !this.minions.isEmpty() || super.func_190530_aW();
    }

    public void notifyMinionDeath(WildHuntSkeletonEntity minion) {
        this.minions.remove((Object)minion);
    }
}

