/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.api.common.tile.IStorageControllerProxy;
import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.ai.PausableGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FallbackDepositToControllerGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected ManageMachineJob job;
    protected int retries = 0;

    public FallbackDepositToControllerGoal(SpiritEntity entity, ManageMachineJob job) {
        this.entity = entity;
        this.job = job;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity.func_70638_az() != null) {
            return false;
        }
        if (this.job.getStorageController() == null) {
            return false;
        }
        return !this.isPaused() && !this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.entity.getDepositPosition().isPresent();
    }

    @Override
    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75246_d() {
        TileEntity storageProxy = this.findClosestStorageProxy();
        if (storageProxy != null) {
            this.entity.setDepositPosition(storageProxy.func_174877_v());
            this.entity.setDepositFacing(Direction.UP);
        } else {
            if (this.retries <= 60) {
                ++this.retries;
            }
            this.pause((long)this.retries * 10000L);
        }
    }

    protected TileEntity findClosestStorageProxy() {
        World world = this.entity.field_70170_p;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos machinePosition = this.job.getManagedMachine().globalPos.getPos();
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        List searchBlocks = BlockPos.func_218281_b((BlockPos)machinePosition.func_177982_a(-workAreaSize, -workAreaSize / 2, -workAreaSize), (BlockPos)machinePosition.func_177982_a(workAreaSize, workAreaSize / 2, workAreaSize)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos pos : searchBlocks) {
            IStorageControllerProxy proxy;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof IStorageControllerProxy) || (proxy = (IStorageControllerProxy)tileEntity).getLinkedStorageControllerPosition() == null || !proxy.getLinkedStorageControllerPosition().equals(this.job.getStorageControllerPosition())) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            return world.func_175625_s((BlockPos)allBlocks.get(0));
        }
        return null;
    }
}

