/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.ai.PausableGoal;
import com.github.klikli_dev.occultism.common.entity.ai.target.BlockPosMoveTarget;
import com.github.klikli_dev.occultism.common.entity.ai.target.EntityMoveTarget;
import com.github.klikli_dev.occultism.common.entity.ai.target.IMoveTarget;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DepositItemsGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected IMoveTarget moveTarget = null;

    public DepositItemsGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.func_213303_ch(), Math3DUtil.center(this.moveTarget.getBlockPos()));
        return this.moveTarget.getBlockPos().func_177972_a(Direction.func_176733_a((double)angle).func_176734_d());
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity.func_70638_az() != null) {
            return false;
        }
        if (this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return !this.isPaused() && this.moveTarget != null;
    }

    @Override
    public boolean func_75253_b() {
        return !this.isPaused() && this.moveTarget != null && !this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.moveTarget != null) {
            if (this.moveTarget.isValid()) {
                float accessDistance = 1.86f;
                double distance = this.entity.func_213303_ch().func_72438_d(Math3DUtil.center(this.moveTarget.getBlockPos()));
                if (distance < 2.5 && distance >= (double)accessDistance && this.canSeeTarget() && this.moveTarget.isChest()) {
                    this.toggleChest(this.moveTarget, true);
                }
                if (distance < (double)accessDistance) {
                    this.entity.func_70661_as().func_75499_g();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_179680_a(moveTarget, 0), 1.0);
                }
                if (distance < 1.86 && this.canSeeTarget()) {
                    ItemStack duplicate;
                    LazyOptional handlerCapability = this.moveTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getDepositFacing());
                    if (!handlerCapability.isPresent()) {
                        this.resetTarget();
                        return;
                    }
                    IItemHandler handler = (IItemHandler)handlerCapability.orElseThrow(ItemHandlerMissingException::new);
                    ItemStack toInsert = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)(duplicate = this.entity.func_184586_b(Hand.MAIN_HAND).func_77946_l()), (boolean)true);
                    if (toInsert.func_190916_E() != duplicate.func_190916_E()) {
                        ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                        this.entity.func_184611_a(Hand.MAIN_HAND, leftover);
                        if (toInsert.func_190926_b()) {
                            this.moveTarget = null;
                            this.func_75251_c();
                        } else {
                            this.pause(2000L);
                        }
                    }
                    if (this.moveTarget != null && this.moveTarget.isChest()) {
                        this.toggleChest(this.moveTarget, false);
                    }
                }
            } else {
                this.resetTarget();
            }
        }
    }

    public boolean canSeeTarget() {
        RayTraceContext context = new RayTraceContext(this.entity.func_213303_ch(), Math3DUtil.center(this.moveTarget.getBlockPos()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity);
        BlockRayTraceResult result = this.entity.field_70170_p.func_217299_a(context);
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            BlockPos sidePos = result.func_216350_a();
            BlockPos pos = new BlockPos(result.func_216347_e());
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.moveTarget.getBlockPos());
        }
        return true;
    }

    public void toggleChest(IMoveTarget target, boolean open) {
        TileEntity tile;
        if (target instanceof BlockPosMoveTarget && (tile = this.entity.field_70170_p.func_175625_s(target.getBlockPos())) instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)tile;
            if (open) {
                this.entity.field_70170_p.func_175641_c(this.moveTarget.getBlockPos(), chest.func_195044_w().func_177230_c(), 1, 1);
            } else {
                this.entity.field_70170_p.func_175641_c(this.moveTarget.getBlockPos(), chest.func_195044_w().func_177230_c(), 1, 0);
            }
        }
    }

    private void resetTarget() {
        Optional<BlockPos> targetPos = this.entity.getDepositPosition();
        targetPos.ifPresent(pos -> {
            this.moveTarget = new BlockPosMoveTarget(this.entity.field_70170_p, (BlockPos)pos);
            if (!this.moveTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.entity.getDepositFacing()).isPresent()) {
                this.entity.setDepositPosition(null);
            }
        });
        Optional<UUID> targetUUID = this.entity.getDepositEntityUUID();
        targetUUID.ifPresent(uuid -> {
            Entity targetEntity = ((ServerWorld)this.entity.field_70170_p).func_217461_a(uuid);
            if (targetEntity != null) {
                this.moveTarget = new EntityMoveTarget(targetEntity);
            } else {
                this.entity.setDepositEntityUUID(null);
            }
        });
    }
}

