/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.entity.CthulhuFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.GoatFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.GreedyFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.ShubNiggurathSpawnEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class ShubNiggurathFamiliarEntity
extends FamiliarEntity {
    private static final int MAX_SPAWN_TIMER = 200;
    private int spawnTimer = 200;

    public ShubNiggurathFamiliarEntity(EntityType<? extends ShubNiggurathFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ShubNiggurathFamiliarEntity(World worldIn, GoatFamiliarEntity goat) {
        this((EntityType<? extends ShubNiggurathFamiliarEntity>)((EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get()), worldIn);
        this.setRing(goat.hasRing());
        this.setBeard(goat.hasBeard());
        this.setFamiliarOwner(goat.getFamiliarOwner());
        this.func_70107_b(goat.func_226277_ct_(), goat.func_226278_cu_(), goat.func_226281_cx_());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, new GreedyFamiliarEntity.RideFamiliarGoal(this, (EntityType)OccultismEntities.CTHULHU_FAMILIAR.get()));
        this.field_70714_bg.func_75776_a(6, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    protected float func_110146_f(float p_110146_1_, float distance) {
        if ((double)distance > 0.1) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = MathHelper.func_219800_b((float)this.field_70759_as, (float)this.field_70761_aq, (float)this.func_184649_cE());
        }
        return distance;
    }

    public CthulhuFamiliarEntity getCthulhuFriend() {
        if (this.func_184187_bx() instanceof CthulhuFamiliarEntity) {
            return (CthulhuFamiliarEntity)this.func_184187_bx();
        }
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.rotateTowardsFriend();
            if (this.isEffectEnabled(this.getFamiliarOwner())) {
                this.createSpawn((LivingEntity)this, new Vector3d(this.func_226282_d_(2.0), this.func_226279_cv_(), this.func_226287_g_(2.0)));
            }
        }
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (this.isEffectEnabled(wearer)) {
            this.createSpawn(wearer, new Vector3d(wearer.func_226282_d_(2.0), wearer.func_226279_cv_(), wearer.func_226287_g_(2.0)));
        }
    }

    private void createSpawn(LivingEntity creator, Vector3d pos) {
        if (this.spawnTimer-- < 0) {
            this.spawnTimer = 200;
            ShubNiggurathSpawnEntity spawn = new ShubNiggurathSpawnEntity(creator.field_70170_p, creator);
            spawn.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            creator.field_70170_p.func_217376_c((Entity)spawn);
        }
    }

    private void rotateTowardsFriend() {
        CthulhuFamiliarEntity friend = this.getCthulhuFriend();
        if (friend != null) {
            Vector3d direction = this.func_213303_ch().func_72444_a(friend.func_213303_ch());
            float rot = (float)Math.toDegrees(MathHelper.func_181159_b((double)direction.field_72449_c, (double)direction.field_72450_a)) - 50.0f;
            this.field_70126_B = this.field_70177_z;
            this.field_70761_aq = this.field_70177_z = rot;
            this.field_70760_ar = this.field_70126_B;
        }
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        if (this.func_184187_bx() != null && this.immuneWhileHoldingHand(pSource)) {
            return false;
        }
        if (super.func_70097_a(pSource, pAmount)) {
            if (pSource.func_76346_g() != null) {
                GoatFamiliarEntity.ringBell(this);
            }
            return true;
        }
        return false;
    }

    private boolean immuneWhileHoldingHand(DamageSource s) {
        return s == DamageSource.field_191291_g || s == DamageSource.field_76369_e || s == DamageSource.field_76379_h || s == DamageSource.field_82729_p || s == DamageSource.field_188406_j || s == DamageSource.field_76368_d;
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasRing() {
        return this.hasVariant(0);
    }

    private void setRing(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasBeard() {
        return this.hasVariant(1);
    }

    private void setBeard(boolean b) {
        this.setVariant(1, b);
    }
}

