/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.network.MessageHeadlessDie;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class HeadlessFamiliarEntity
extends FamiliarEntity {
    private static final int HEAD_TIME = 1200;
    private static final byte NO_HEAD = 0;
    private static final DataParameter<Byte> HEAD = EntityDataManager.func_187226_a(HeadlessFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> WEAPON = EntityDataManager.func_187226_a(HeadlessFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> REBUILT = EntityDataManager.func_187226_a(HeadlessFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static ImmutableBiMap<Byte, EntityType<? extends LivingEntity>> typesLookup;
    private int headTimer;
    private int headlessDieTimer;

    public HeadlessFamiliarEntity(EntityType<? extends HeadlessFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    private static ImmutableBiMap<Byte, EntityType<? extends LivingEntity>> getTypesLookup() {
        if (typesLookup == null) {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            builder.put((Object)1, (Object)EntityType.field_200729_aH);
            builder.put((Object)2, (Object)EntityType.field_200725_aD);
            builder.put((Object)3, (Object)EntityType.field_200741_ag);
            builder.put((Object)4, (Object)EntityType.field_200722_aA);
            builder.put((Object)5, (Object)EntityType.field_200797_k);
            builder.put((Object)6, (Object)EntityType.field_200748_an);
            builder.put((Object)7, (Object)OccultismEntities.CTHULHU_FAMILIAR.get());
            typesLookup = builder.build();
        }
        return typesLookup;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_(Attributes.field_233818_a_, 40.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && !HeadlessFamiliarEntity.this.isHeadlessDead();
            }
        });
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public void func_70071_h_() {
        block7: {
            block6: {
                super.func_70071_h_();
                if (this.field_70170_p.field_72995_K) break block6;
                if (this.headTimer-- == 0) {
                    this.setHead((byte)0);
                }
                if (!this.hasBlacksmithUpgrade() || this.isHeadlessDead() || this.field_70173_aa % 10 != 0 || this.getHeadType() == null) break block7;
                for (LivingEntity e2 : this.field_70170_p.func_217394_a(this.getHeadType(), this.func_174813_aQ().func_186662_g(5.0), e -> e != this.getFamiliarOwner())) {
                    e2.func_195064_c(new EffectInstance(Effects.field_76437_t, 60));
                }
                break block7;
            }
            if (this.hasBlacksmithUpgrade() && !this.isHeadlessDead() && this.field_70173_aa % 10 == 0) {
                Vector3d forward = Vector3d.func_189986_a((float)0.0f, (float)this.field_70177_z);
                Vector3d pos = this.func_213303_ch().func_178787_e(forward.func_216371_e().func_186678_a(0.15)).func_72441_c(this.randPos(0.08), this.randPos(0.08), this.randPos(0.08));
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, pos.field_72450_a, pos.field_72448_b + 1.1, pos.field_72449_c, 0.0, 0.0, 0.0);
            }
            if (this.headlessDieTimer == 1) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            if (this.headlessDieTimer-- > 7) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(0.5f, 0.0f, 0.0f, 1.0f), this.func_226277_ct_() + this.randPos(0.3), this.func_226278_cu_() + 1.0 + this.randPos(0.3), this.func_226281_cx_() + this.randPos(0.3), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, ILivingEntityData pSpawnData, CompoundNBT pDataTag) {
        this.setWeapon((byte)this.func_70681_au().nextInt(3));
        this.setHairy(this.func_70681_au().nextBoolean());
        this.setGlasses(this.func_70681_au().nextDouble() < 0.1);
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAD, (Object)0);
        this.field_70180_af.func_187214_a(WEAPON, (Object)0);
        this.field_70180_af.func_187214_a(REBUILT, (Object)0);
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        if (this.isHeadlessDead()) {
            ItemStack stack = playerIn.func_184586_b(hand);
            Item item = stack.func_77973_b();
            boolean success = false;
            if (item.func_206844_a((ITag)Tags.Items.CROPS_WHEAT) && !this.isRebuilt(Rebuilt.LeftLeg)) {
                this.setRebuilt(Rebuilt.LeftLeg);
                success = true;
            } else if (item.func_206844_a((ITag)Tags.Items.CROPS_WHEAT) && !this.isRebuilt(Rebuilt.RightLeg)) {
                this.setRebuilt(Rebuilt.RightLeg);
                success = true;
            } else if (item == Items.field_221807_eN && !this.isRebuilt(Rebuilt.Body)) {
                this.setRebuilt(Rebuilt.Body);
                success = true;
            } else if (item.func_206844_a((ITag)Tags.Items.RODS_WOODEN) && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.LeftArm)) {
                this.setRebuilt(Rebuilt.LeftArm);
                success = true;
            } else if (item.func_206844_a((ITag)Tags.Items.RODS_WOODEN) && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.RightArm)) {
                this.setRebuilt(Rebuilt.RightArm);
                success = true;
            } else if (item == Items.field_221689_cG && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.Head)) {
                this.setRebuilt(Rebuilt.Head);
                success = true;
            }
            if (success) {
                stack.func_190918_g(1);
                if (this.isFullyRebuilt()) {
                    OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.HEADLESS_REBUILT);
                }
                return ActionResultType.func_233537_a_((!this.field_70170_p.field_72995_K ? 1 : 0) != 0);
            }
        }
        return super.func_230254_b_(playerIn, hand);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasGlasses()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHead(compound.func_74771_c("head"));
        this.headTimer = compound.func_74762_e("headTimer");
        if (!compound.func_74764_b("variants")) {
            this.setHairy(compound.func_74767_n("isHairy"));
            this.setGlasses(compound.func_74767_n("hasGlasses"));
            this.setHeadlessDead(compound.func_74767_n("isHeadlessDead"));
        }
        this.setWeapon(compound.func_74771_c("getWeapon"));
        this.setRebuilt(compound.func_74771_c("getRebuilt"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("head", this.getHead());
        compound.func_74768_a("headTimer", this.headTimer);
        compound.func_74774_a("getWeapon", this.getWeapon());
        compound.func_74774_a("getRebuilt", this.getRebuilt());
    }

    protected void func_70665_d(DamageSource pDamageSrc, float pDamageAmount) {
        super.func_70665_d(pDamageSrc, pDamageAmount);
        if ((double)(this.func_110143_aJ() / this.func_110138_aP()) < 0.5 && !this.isHeadlessDead()) {
            this.setHeadlessDead(true);
            OccultismPackets.sendToTracking((Entity)this, new MessageHeadlessDie(this.func_145782_y()));
        }
    }

    private double randPos(double scale) {
        return ((double)this.func_70681_au().nextFloat() - 0.5) * scale;
    }

    public boolean isHairy() {
        return this.hasVariant(0);
    }

    private void setHairy(boolean b) {
        this.setVariant(0, b);
    }

    private void setGlasses(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasGlasses() {
        return this.hasVariant(1);
    }

    private byte getWeapon() {
        return (Byte)this.field_70180_af.func_187225_a(WEAPON);
    }

    private void setWeapon(byte b) {
        this.field_70180_af.func_187227_b(WEAPON, (Object)b);
    }

    public ItemStack getWeaponItem() {
        Item weapon = Items.field_151040_l;
        switch (this.getWeapon()) {
            case 1: {
                weapon = Items.field_151036_c;
                break;
            }
            case 2: {
                weapon = Items.field_151019_K;
            }
        }
        return new ItemStack((IItemProvider)weapon);
    }

    private byte getHead() {
        return (Byte)this.field_70180_af.func_187225_a(HEAD);
    }

    private void setHead(byte head) {
        this.field_70180_af.func_187227_b(HEAD, (Object)head);
        if (head != 0) {
            this.headTimer = 1200;
        }
    }

    public boolean hasHead() {
        return this.getHead() != 0;
    }

    public EntityType<? extends LivingEntity> getHeadType() {
        return (EntityType)HeadlessFamiliarEntity.getTypesLookup().getOrDefault((Object)this.getHead(), null);
    }

    public void setHeadType(EntityType<?> type) {
        if (type == null || !HeadlessFamiliarEntity.getTypesLookup().inverse().containsKey(type)) {
            return;
        }
        this.setHead((Byte)HeadlessFamiliarEntity.getTypesLookup().inverse().get(type));
    }

    public boolean isHeadlessDead() {
        return this.hasVariant(2);
    }

    private void setHeadlessDead(boolean b) {
        this.setVariant(2, b);
    }

    private byte getRebuilt() {
        return (Byte)this.field_70180_af.func_187225_a(REBUILT);
    }

    private void setRebuilt(byte b) {
        this.field_70180_af.func_187227_b(REBUILT, (Object)b);
    }

    private void setRebuilt(Rebuilt r) {
        this.setRebuilt((byte)(this.getRebuilt() | 1 << r.getValue()));
    }

    public boolean isRebuilt(Rebuilt r) {
        return (this.getRebuilt() >> r.getValue() & 1) == 1;
    }

    private boolean isFullyRebuilt() {
        return this.getRebuilt() == 63;
    }

    public void killHeadless() {
        this.headlessDieTimer = 20;
    }

    public static enum Rebuilt {
        LeftLeg(0),
        RightLeg(1),
        Body(2),
        LeftArm(3),
        RightArm(4),
        Head(5);

        private final int value;

        private Rebuilt(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

