/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DragonFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class GreedyFamiliarEntity
extends FamiliarEntity {
    private static final DataParameter<Optional<BlockPos>> TARGET_BLOCK = EntityDataManager.func_187226_a(GreedyFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private float earRotZ;
    private float earRotZ0;
    private float earRotX;
    private float earRotX0;
    private float peekRot;
    private float peekRot0;
    private float monsterRot;
    private float monsterRot0;
    private int monsterAnimTimer = this.func_70681_au().nextInt(100);

    public GreedyFamiliarEntity(EntityType<? extends GreedyFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindBlockGoal(this));
        this.field_70714_bg.func_75776_a(3, new RideFamiliarGoal(this, (EntityType)OccultismEntities.DRAGON_FAMILIAR.get()));
        this.field_70714_bg.func_75776_a(4, (Goal)new FindItemGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_BLOCK, Optional.empty());
    }

    public Optional<BlockPos> getTargetBlock() {
        return (Optional)this.field_70180_af.func_187225_a(TARGET_BLOCK);
    }

    private void setTargetBlock(Optional<BlockPos> pos) {
        this.field_70180_af.func_187227_b(TARGET_BLOCK, pos);
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (!(wearer instanceof PlayerEntity)) {
            return;
        }
        if (this.isEffectEnabled(wearer)) {
            for (ItemEntity e2 : wearer.field_70170_p.func_175647_a(ItemEntity.class, wearer.func_174813_aQ().func_186662_g(5.0), e -> e.func_70089_S())) {
                ItemStack stack = e2.func_92059_d();
                boolean isStackDemagnetized = stack.func_77942_o() && stack.func_77978_p().func_74767_n("PreventRemoteMovement");
                boolean isEntityDemagnetized = e2.getPersistentData().func_74767_n("PreventRemoteMovement");
                if (isStackDemagnetized || isEntityDemagnetized) continue;
                e2.func_70100_b_((PlayerEntity)wearer);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.earRotX0 = this.earRotX;
        this.earRotZ0 = this.earRotZ;
        if (this.field_70170_p.field_72995_K) {
            Optional<BlockPos> targetBlock = this.getTargetBlock();
            if (targetBlock.isPresent()) {
                Vector3d p = Vector3d.func_237489_a_((Vector3i)((Vector3i)targetBlock.get()));
                float endZRot = -0.5f;
                if (Math.abs(p.field_72448_b - this.func_226280_cw_()) > 1.0) {
                    endZRot = p.field_72448_b > this.func_226280_cw_() ? 0.0f : -2.0f;
                }
                this.earRotZ = MathHelper.func_219799_g((float)0.1f, (float)this.earRotZ, (float)endZRot);
                Vector3d look = this.func_70676_i(1.0f);
                Vector3d toTarget = p.func_72444_a(this.func_213303_ch()).func_72432_b();
                toTarget = new Vector3d(toTarget.field_72450_a, 0.0, toTarget.field_72449_c);
                float endXRot = toTarget.func_72430_b(look) < 0.0 ? 1.0f : -1.0f;
                this.earRotX = MathHelper.func_219799_g((float)0.1f, (float)this.earRotX, (float)endXRot);
            } else {
                this.earRotX = MathHelper.func_219799_g((float)0.1f, (float)this.earRotX, (float)0.0f);
                this.earRotZ = MathHelper.func_219799_g((float)0.1f, (float)this.earRotZ, (float)-0.5f);
            }
            ++this.monsterAnimTimer;
            this.peekRot0 = this.peekRot;
            this.monsterRot0 = this.monsterRot;
            if (this.monsterAnimTimer % 300 < 200) {
                float peekTimer = this.monsterAnimTimer % 300 % 200;
                if (peekTimer > 30.0f && peekTimer < 50.0f) {
                    this.monsterRot = MathHelper.func_219799_g((float)0.3f, (float)this.monsterRot, (float)this.toRad(37.0f));
                } else if (peekTimer > 50.0f && peekTimer < 70.0f) {
                    this.monsterRot = MathHelper.func_219799_g((float)0.3f, (float)this.monsterRot, (float)this.toRad(-37.0f));
                } else if (peekTimer > 70.0f) {
                    this.monsterRot = MathHelper.func_219799_g((float)0.3f, (float)this.monsterRot, (float)0.0f);
                }
                this.peekRot = peekTimer < 100.0f ? MathHelper.func_219799_g((float)0.1f, (float)this.peekRot, (float)this.toRad(46.0f)) : MathHelper.func_219799_g((float)0.1f, (float)this.peekRot, (float)0.0f);
            } else {
                this.peekRot = 0.0f;
                this.monsterRot = 0.0f;
            }
        }
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public float getLidRot(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.peekRot0, (float)this.peekRot);
    }

    public float getMonsterRot(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.monsterRot0, (float)this.monsterRot);
    }

    public float getEarRotZ(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.earRotZ0, (float)this.earRotZ);
    }

    public float getEarRotX(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.earRotX0, (float)this.earRotX);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (this.hasBlacksmithUpgrade() && !this.func_184592_cb().func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)this.func_184592_cb());
            this.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.hasBlacksmithUpgrade() && stack.func_77973_b() instanceof BlockItem) {
            this.func_184611_a(Hand.OFF_HAND, new ItemStack((IItemProvider)stack.func_77973_b()));
            stack.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(playerIn, hand);
    }

    private static class FindBlockGoal
    extends MoveToBlockGoal {
        GreedyFamiliarEntity greedy;

        public FindBlockGoal(GreedyFamiliarEntity greedy) {
            super((CreatureEntity)greedy, 1.0, 10, 5);
            this.greedy = greedy;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_179495_c.func_184592_cb().func_190926_b();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !this.field_179495_c.func_184592_cb().func_190926_b();
        }

        protected boolean func_179488_a(IWorldReader pLevel, BlockPos pPos) {
            ItemStack offhand = this.field_179495_c.func_184592_cb();
            return pLevel.func_180495_p(pPos).func_177230_c() == Block.func_149634_a((Item)offhand.func_77973_b());
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.greedy.setTargetBlock(Optional.of(this.field_179494_b));
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.greedy.setTargetBlock(Optional.empty());
        }

        protected BlockPos func_241846_j() {
            return this.field_179494_b;
        }
    }

    public static class RideFamiliarGoal<T extends FamiliarEntity>
    extends Goal {
        private final FamiliarEntity rider;
        private EntityType<T> type;
        private FamiliarEntity mount;

        public RideFamiliarGoal(FamiliarEntity rider, EntityType<T> type) {
            this.rider = rider;
            this.type = type;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (this.rider.func_184187_bx() != null && this.rider.func_184187_bx().func_200600_R() == this.type) {
                return true;
            }
            FamiliarEntity mount = this.findMount();
            if (mount != null) {
                this.mount = mount;
                this.rider.func_70661_as().func_75497_a((Entity)mount, 1.0);
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.rider.func_184187_bx() != null && this.rider.func_184187_bx().func_200600_R() == this.type || this.rider.func_70781_l() && this.mount != null;
        }

        public void func_75251_c() {
            this.rider.func_184210_p();
            this.mount = null;
        }

        public void func_75246_d() {
            if (this.mount != null && this.rider.func_70068_e((Entity)this.mount) < 5.0 && !this.mount.func_184196_w((Entity)this.rider)) {
                this.rider.func_184220_m((Entity)this.mount);
                this.mount.func_70661_as().func_75499_g();
                if (this.rider.func_200600_R() == OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get() && this.type == OccultismEntities.CTHULHU_FAMILIAR.get()) {
                    OccultismAdvancements.FAMILIAR.trigger(this.rider.getFamiliarOwner(), FamiliarTrigger.Type.SHUB_CTHULHU_FRIENDS);
                }
            }
        }

        private FamiliarEntity findMount() {
            LivingEntity owner = this.rider.getOwner();
            if (owner == null) {
                return null;
            }
            List mounts = this.rider.field_70170_p.func_217394_a(this.type, this.rider.func_174813_aQ().func_186662_g(5.0), e -> e.getFamiliarOwner() == owner && !e.func_184207_aI() && !e.isSitting());
            if (mounts.isEmpty()) {
                return null;
            }
            return (FamiliarEntity)mounts.get(0);
        }
    }

    public static class FindItemGoal
    extends Goal {
        private static final double RANGE = 12.0;
        private final FamiliarEntity entity;

        public FindItemGoal(FamiliarEntity entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.getNearbyItem() != null && this.entity.getFamiliarOwner() instanceof PlayerEntity;
        }

        public void func_75249_e() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.func_70661_as().func_75497_a((Entity)item, 1.2);
            }
        }

        public void func_75246_d() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.func_70661_as().func_75497_a((Entity)item, 1.2);
                LivingEntity owner = this.entity.getFamiliarOwner();
                if (item.func_70068_e((Entity)this.entity) < 4.0 && owner instanceof PlayerEntity) {
                    item.func_70100_b_((PlayerEntity)owner);
                    if (this.entity instanceof GreedyFamiliarEntity) {
                        OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.GREEDY_ITEM);
                    } else if (this.entity instanceof DragonFamiliarEntity) {
                        OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.DRAGON_RIDE);
                    }
                }
            }
        }

        private ItemEntity getNearbyItem() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (!(owner instanceof PlayerEntity)) {
                return null;
            }
            PlayerEntity player = (PlayerEntity)owner;
            PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.field_71071_by);
            for (ItemEntity item : this.entity.field_70170_p.func_175647_a(ItemEntity.class, this.entity.func_174813_aQ().func_186662_g(12.0), e -> e.func_70089_S())) {
                ItemStack stack = item.func_92059_d();
                boolean isStackDemagnetized = stack.func_77942_o() && stack.func_77978_p().func_74767_n("PreventRemoteMovement");
                boolean isEntityDemagnetized = item.getPersistentData().func_74767_n("PreventRemoteMovement");
                if (isStackDemagnetized || isEntityDemagnetized || ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true).func_190916_E() == stack.func_190916_E()) continue;
                return item;
            }
            return null;
        }
    }
}

