/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.GreedyFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.ThrownSwordEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.ItemHandlerHelper;

public class DragonFamiliarEntity
extends FamiliarEntity {
    public static final int MAX_PET_TIMER = 40;
    private static final int GREEDY_INCREMENT = 6000;
    private final float colorOffset = this.func_70681_au().nextFloat() * 2.0f;
    private int greedyTimer;
    private int flyingTimer;
    private int flyingTimer0;
    private int wingspan;
    private int wingspan0;
    private int petTimer = 40;

    public DragonFamiliarEntity(EntityType<? extends DragonFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasFez()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setFez(this.func_70681_au().nextDouble() < 0.1);
        this.setEars(this.func_70681_au().nextDouble() < 0.5);
        this.setArms(this.func_70681_au().nextDouble() < 0.5);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasSword() {
        return this.hasBlacksmithUpgrade() && !this.field_82175_bq;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new GreedyFamiliarEntity.FindItemGoal(this){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && DragonFamiliarEntity.this.func_184188_bt().stream().anyMatch(e -> e instanceof GreedyFamiliarEntity);
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new FetchGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && !DragonFamiliarEntity.this.hasBlacksmithUpgrade();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new ThrowSwordGoal(this, 100.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public void func_226292_a_(Hand handIn, boolean updateSelf) {
        super.func_226292_a_(handIn, updateSelf);
        this.field_110158_av = -14;
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    public float getAttackProgress(float partialTicks) {
        return MathHelper.func_219799_g((float)(((float)(this.field_110158_av + 14) + partialTicks) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public int getPetTimer() {
        return this.petTimer;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.greedyTimer > 0) {
            --this.greedyTimer;
        }
        if (!this.func_233570_aj_()) {
            Vector3d motion = this.func_213322_ci();
            if (motion.field_72448_b < 0.0) {
                motion = motion.func_216372_d(1.0, 0.5, 1.0);
                this.func_213317_d(motion);
            }
        }
        if (!this.func_70613_aW()) {
            this.flyingTimer0 = this.flyingTimer++;
            this.wingspan0 = this.wingspan;
            if (this.func_233570_aj_()) {
                this.wingspan -= 5;
                if (this.wingspan < 0) {
                    this.wingspan = 0;
                }
            } else {
                this.wingspan += 5;
                if (this.wingspan > 30) {
                    this.wingspan = 30;
                }
            }
            if (this.petTimer < 40) {
                ++this.petTimer;
            }
        }
    }

    public float getFlyingTimer(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.flyingTimer0, (float)this.flyingTimer);
    }

    public float getWingspan(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.wingspan0, (float)this.wingspan);
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (this.hasStick()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)new ItemStack((IItemProvider)Items.field_151055_y));
            this.setStick(false);
            return ActionResultType.func_233537_a_((!this.func_70613_aW() ? 1 : 0) != 0);
        }
        if (stack.func_77973_b().func_206844_a((ITag)Tags.Items.NUGGETS_GOLD)) {
            OccultismAdvancements.FAMILIAR.trigger(this.getFamiliarOwner(), FamiliarTrigger.Type.DRAGON_NUGGET);
            this.greedyTimer += 6000;
            if (this.func_70613_aW()) {
                stack.func_190918_g(1);
            } else {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            return ActionResultType.func_233537_a_((!this.func_70613_aW() ? 1 : 0) != 0);
        }
        if (stack.func_190926_b() && playerIn.func_225608_bj_()) {
            this.petTimer = 0;
            OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.DRAGON_PET);
            return ActionResultType.func_233537_a_((!this.func_70613_aW() ? 1 : 0) != 0);
        }
        return super.func_230254_b_(playerIn, hand);
    }

    public boolean hasFez() {
        return this.hasVariant(0);
    }

    private void setFez(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasEars() {
        return this.hasVariant(1);
    }

    private void setEars(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasArms() {
        return this.hasVariant(2);
    }

    private void setArms(boolean b) {
        this.setVariant(2, b);
    }

    public boolean hasStick() {
        return this.hasVariant(3);
    }

    private void setStick(boolean b) {
        this.setVariant(3, b);
    }

    public double func_70042_X() {
        return super.func_70042_X() * (double)0.4f;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("greedyTimer", this.greedyTimer);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setFez(compound.func_74767_n("hasFez"));
            this.setEars(compound.func_74767_n("hasEars"));
            this.setArms(compound.func_74767_n("hasArms"));
            this.setStick(compound.func_74767_n("hasStick"));
        }
        this.greedyTimer = compound.func_74762_e("greedyTimer");
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new EffectInstance((Effect)OccultismEffects.DRAGON_GREED.get(), 300, this.greedyTimer > 0 ? 1 : 0, false, false));
    }

    public float getEyeColorR(float partialTicks) {
        return Math.abs(MathHelper.func_76126_a((float)(((float)this.field_70173_aa + partialTicks + 5.0f) / 20.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    public float getEyeColorG(float partialTicks) {
        return Math.abs(MathHelper.func_76126_a((float)(((float)this.field_70173_aa + partialTicks + 10.0f) / 30.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    public float getEyeColorB(float partialTicks) {
        return Math.abs(MathHelper.func_76126_a((float)(((float)this.field_70173_aa + partialTicks) / 40.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    private static class FetchGoal
    extends Goal {
        private final DragonFamiliarEntity dragon;
        private ItemEntity stick;

        public FetchGoal(DragonFamiliarEntity dragon) {
            this.dragon = dragon;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.stick = this.findStick();
            return this.stick != null && !this.dragon.hasStick();
        }

        public boolean func_75253_b() {
            return this.stick != null && !this.dragon.hasStick();
        }

        public void func_75249_e() {
            this.dragon.func_70661_as().func_75497_a((Entity)this.stick, 1.2);
        }

        public void func_75251_c() {
            this.dragon.func_70661_as().func_75499_g();
            this.stick = null;
        }

        public void func_75246_d() {
            if (this.stick == null || !this.stick.func_70089_S()) {
                this.stick = this.findStick();
                if (this.stick == null) {
                    return;
                }
            }
            this.dragon.func_70661_as().func_75497_a((Entity)this.stick, 1.2);
            if (this.stick.func_70068_e((Entity)this.dragon) < 3.0) {
                this.dragon.setStick(true);
                OccultismAdvancements.FAMILIAR.trigger(this.dragon.getFamiliarOwner(), FamiliarTrigger.Type.DRAGON_FETCH);
                this.stick.func_92059_d().func_190918_g(1);
                this.stick = null;
            }
        }

        private ItemEntity findStick() {
            List sticks = this.dragon.field_70170_p.func_175647_a(ItemEntity.class, this.dragon.func_174813_aQ().func_186662_g(8.0), e -> e.func_92059_d().func_77973_b() == Items.field_151055_y && e.func_70089_S());
            return sticks.isEmpty() ? null : (ItemEntity)sticks.get(0);
        }
    }

    private static class ThrowSwordGoal
    extends DevilFamiliarEntity.AttackGoal {
        public ThrowSwordGoal(FamiliarEntity entity, float range) {
            super(entity, range);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && this.entity.hasBlacksmithUpgrade();
        }

        @Override
        protected void attack(List<LivingEntity> enemies) {
            if (enemies.isEmpty()) {
                return;
            }
            Entity enemy = (Entity)enemies.get(this.entity.func_70681_au().nextInt(enemies.size()));
            ThrownSwordEntity sword = new ThrownSwordEntity((EntityType<? extends ThrownSwordEntity>)((EntityType)OccultismEntities.THROWN_SWORD_TYPE.get()), this.entity.field_70170_p);
            sword.func_212361_a((Entity)this.entity.getFamiliarOwner());
            double x = this.entity.func_226277_ct_();
            double y = this.entity.func_226280_cw_();
            double z = this.entity.func_226281_cx_();
            double xDir = enemy.func_226277_ct_() - x;
            double yDir = enemy.func_226278_cu_() + (double)enemy.func_213302_cg() - y;
            double zDir = enemy.func_226281_cx_() - z;
            sword.func_70107_b(x, y, z);
            sword.func_70186_c(xDir, yDir, zDir, 0.5f, 3.0f);
            this.entity.field_70170_p.func_217376_c((Entity)sword);
        }
    }
}

