/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;

public class CthulhuFamiliarEntity
extends FamiliarEntity {
    private final SwimmerPathNavigator waterNavigator;
    private final GroundPathNavigator groundNavigator;
    private BlockPos lightPos;
    private BlockPos lightPos0;
    private int lightTimer;
    public float riderRot;
    public float riderRot0;
    public float riderLimbSwingAmount;
    public float riderLimbSwing;

    public CthulhuFamiliarEntity(EntityType<? extends CthulhuFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, worldIn);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, worldIn);
        this.field_70765_h = new MoveController(this);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return FamiliarEntity.registerAttributes().func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setHat(this.func_70681_au().nextDouble() < 0.1);
        this.setTrunk(this.func_70681_au().nextDouble() < 0.5);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerWaterGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new GiveFlowerGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasHat()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    protected void func_180429_a(BlockPos pPos, BlockState pBlock) {
    }

    private Vector3d riderLocation() {
        return Vector3d.func_189986_a((float)0.0f, (float)this.riderRot).func_178785_b(230.0f).func_186678_a(0.68).func_178787_e(this.func_213303_ch());
    }

    public void func_184232_k(Entity pPassenger) {
        if (this.func_184196_w(pPassenger)) {
            Vector3d direction = this.riderLocation();
            pPassenger.func_70107_b(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
        }
    }

    public Vector3d func_230268_c_(LivingEntity pLivingEntity) {
        return this.riderLocation();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    public float getAnimationHeight(float partialTicks) {
        return MathHelper.func_76134_b((float)(((float)this.field_70173_aa + partialTicks) / 5.0f));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (source.func_76346_g() == this.getFamiliarOwner()) {
                this.setAngry(true);
                this.setSitting(true);
                OccultismAdvancements.FAMILIAR.trigger(this.getFamiliarOwner(), FamiliarTrigger.Type.CTHULHU_SAD);
            } else if (source.func_76346_g() != null) {
                Vector3d tp = RandomPositionGenerator.func_75463_a((CreatureEntity)this, (int)8, (int)4);
                if (tp != null) {
                    this.func_70012_b(tp.func_82615_a() + 0.5, tp.func_82617_b(), tp.func_82616_c() + 0.5, this.field_70177_z, this.field_70125_A);
                }
                this.field_70699_by.func_75499_g();
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isAngry() && this.func_70681_au().nextDouble() < 7.0E-4) {
            this.setAngry(false);
        }
        this.riderRot0 = this.riderRot;
        this.riderRot = MathHelper.func_203303_c((float)this.riderRot, (float)this.field_70177_z, (float)10.0f);
        if (!this.field_70170_p.field_72995_K) {
            --this.lightTimer;
            if (this.lightTimer < 0) {
                this.lightTimer = 10;
                if (this.lightPos == null) {
                    this.lightPos = this.func_233580_cy_();
                }
                this.updateLight();
            }
        }
    }

    public float riderRot(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.riderRot0, (float)this.riderRot);
    }

    private void updateLight() {
        this.removeLight(this.lightPos0);
        this.lightPos0 = null;
        if (this.lightPos != this.func_233580_cy_()) {
            this.lightPos0 = this.lightPos;
            this.lightPos = this.func_233580_cy_();
        }
        if (this.field_70170_p.func_175623_d(this.lightPos) && this.func_70089_S() && this.hasBlacksmithUpgrade()) {
            this.field_70170_p.func_175656_a(this.lightPos, ((Block)OccultismBlocks.LIGHTED_AIR.get()).func_176223_P());
        }
    }

    private void removeLight(BlockPos pos) {
        if (!this.field_70170_p.field_72995_K && pos != null && this.field_70170_p.func_180495_p(pos).func_177230_c() == OccultismBlocks.LIGHTED_AIR.get()) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    protected void func_241204_bJ_() {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.func_241204_bJ_();
    }

    public void func_70645_a(DamageSource pCause) {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.func_70645_a(pCause);
    }

    public void func_70106_y() {
        this.removeLight(this.lightPos);
        this.removeLight(this.lightPos0);
        this.lightPos = null;
        this.lightPos0 = null;
        super.func_70106_y();
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new EffectInstance(Effects.field_76427_o, 300, 0, false, false));
    }

    public boolean hasHat() {
        return this.hasVariant(0);
    }

    private void setHat(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasTrunk() {
        return this.hasVariant(1);
    }

    private void setTrunk(boolean b) {
        this.setVariant(1, b);
    }

    public boolean isAngry() {
        return this.hasVariant(2);
    }

    private void setAngry(boolean b) {
        this.setVariant(2, b);
    }

    public boolean isGiving() {
        return this.hasVariant(3);
    }

    private void setGiving(boolean b) {
        this.setVariant(3, b);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setHat(compound.func_74767_n("hasHat"));
            this.setTrunk(compound.func_74767_n("hasTrunk"));
            this.setAngry(compound.func_74767_n("isAngry"));
        }
        if (compound.func_74764_b("lightPos")) {
            this.lightPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("lightPos"));
        }
        if (compound.func_74764_b("lightPos0")) {
            this.lightPos0 = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("lightPos0"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.lightPos != null) {
            compound.func_218657_a("lightPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.lightPos));
        }
        if (this.lightPos0 != null) {
            compound.func_218657_a("lightPos0", (INBT)NBTUtil.func_186859_a((BlockPos)this.lightPos0));
        }
    }

    private static class GiveFlowerGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 6000;
        private final CthulhuFamiliarEntity cthulhu;
        private DevilFamiliarEntity devil;
        private int cooldown = 6000;

        public GiveFlowerGoal(CthulhuFamiliarEntity cthulhu) {
            this.cthulhu = cthulhu;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.devil = this.findDevil();
            return this.devil != null && this.cooldown-- < 0 && this.cthulhu.func_70068_e((Entity)this.devil) > 3.0 && !this.cthulhu.func_184207_aI();
        }

        public boolean func_75253_b() {
            return this.devil != null && this.cthulhu.func_70781_l() && !this.cthulhu.func_184207_aI();
        }

        public void func_75249_e() {
            this.cthulhu.func_70661_as().func_75497_a((Entity)this.devil, 0.3);
            this.cthulhu.setGiving(true);
        }

        public void func_75251_c() {
            this.cthulhu.setGiving(false);
            this.cthulhu.func_70661_as().func_75499_g();
            this.cooldown = 6000;
            this.devil = null;
        }

        public void func_75246_d() {
            if (this.cthulhu.func_70068_e((Entity)this.devil) < 2.0) {
                ((ServerWorld)this.cthulhu.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.devil.func_226277_ct_(), this.devil.func_226278_cu_() + 1.0, this.devil.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 1.0);
                this.devil = null;
            }
        }

        private DevilFamiliarEntity findDevil() {
            List devils = this.cthulhu.field_70170_p.func_217357_a(DevilFamiliarEntity.class, this.cthulhu.func_174813_aQ().func_186662_g(4.0));
            return devils.isEmpty() ? null : (DevilFamiliarEntity)devils.get(0);
        }
    }

    private static class FollowOwnerWaterGoal
    extends FamiliarEntity.FollowOwnerGoal {
        public FollowOwnerWaterGoal(FamiliarEntity entity, double speed, float minDist, float maxDist) {
            super(entity, speed, minDist, maxDist);
        }

        @Override
        protected boolean shouldTeleport(LivingEntity owner) {
            return !this.entity.field_70170_p.func_201671_F(owner.func_233580_cy_()) && this.entity.func_70090_H();
        }
    }

    private static class MoveController
    extends MovementController {
        private final CthulhuFamiliarEntity cthulhu;

        MoveController(CthulhuFamiliarEntity cthulhu) {
            super((MobEntity)cthulhu);
            this.cthulhu = cthulhu;
        }

        public void func_75641_c() {
            if (this.cthulhu.func_70090_H()) {
                this.cthulhu.func_213317_d(this.cthulhu.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                    float maxSpeed = (float)(this.field_75645_e * this.cthulhu.func_233637_b_(Attributes.field_233821_d_)) * 3.0f;
                    this.cthulhu.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.cthulhu.func_70689_ay(), (float)maxSpeed));
                    double dx = this.field_75646_b - this.cthulhu.func_226277_ct_();
                    double dy = this.field_75647_c - this.cthulhu.func_226278_cu_();
                    double dz = this.field_75644_d - this.cthulhu.func_226281_cx_();
                    double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                    if (distance < 0.1) {
                        this.cthulhu.func_191989_p(0.0f);
                        return;
                    }
                    if (Math.abs(dy) > 1.0E-4) {
                        this.cthulhu.func_213317_d(this.cthulhu.func_213322_ci().func_72441_c(0.0, (double)this.cthulhu.func_70689_ay() * (dy / distance) * 0.1, 0.0));
                    }
                    if (Math.abs(dx) > 1.0E-4 || Math.abs(dz) > 1.0E-4) {
                        float rotate = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                        this.cthulhu.field_70761_aq = this.cthulhu.field_70177_z = this.func_75639_a(this.cthulhu.field_70177_z, rotate, 8.0f);
                    }
                } else {
                    this.cthulhu.func_70659_e(0.0f);
                }
            } else {
                super.func_75641_c();
            }
        }
    }
}

