/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.config.value.CachedInt;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class BlacksmithFamiliarEntity
extends FamiliarEntity {
    private static final CachedInt UPGRADE_COST = Occultism.SERVER_CONFIG.spiritJobs.blacksmithFamiliarUpgradeCost;
    private static final DataParameter<Byte> BARS = EntityDataManager.func_187226_a(BlacksmithFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int ironCount;

    private static int getMaxIron() {
        return UPGRADE_COST.get() * 10;
    }

    public BlacksmithFamiliarEntity(EntityType<? extends BlacksmithFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setEarring(this.func_70681_au().nextDouble() < 0.1);
        this.setMarioMoustache(this.func_70681_au().nextDouble() < 0.5);
        this.setSquareHair(this.func_70681_au().nextDouble() < 0.5);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new UpgradeGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (playerIn == this.getFamiliarOwner() && this.ironCount < BlacksmithFamiliarEntity.getMaxIron() && (item.func_206844_a((ITag)Tags.Items.INGOTS_IRON) || item.func_206844_a((ITag)Tags.Items.STORAGE_BLOCKS_IRON))) {
            if (!this.field_70170_p.field_72995_K) {
                stack.func_190918_g(1);
                this.changeIronCount(item.func_206844_a((ITag)Tags.Items.INGOTS_IRON) ? 1 : 9);
            }
            return ActionResultType.func_233537_a_((!this.field_70170_p.field_72995_K ? 1 : 0) != 0);
        }
        return super.func_230254_b_(playerIn, hand);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasEarring()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BARS, (Object)0);
    }

    public boolean hasEarring() {
        return this.hasVariant(0);
    }

    public boolean hasMarioMoustache() {
        return this.hasVariant(1);
    }

    public boolean hasSquareHair() {
        return this.hasVariant(2);
    }

    private void setEarring(boolean b) {
        this.setVariant(0, b);
    }

    private void setMarioMoustache(boolean b) {
        this.setVariant(1, b);
    }

    private void setSquareHair(boolean b) {
        this.setVariant(2, b);
    }

    private void setIronCount(int count) {
        this.ironCount = count;
        this.field_70180_af.func_187227_b(BARS, (Object)((byte)Math.min(10, this.ironCount / UPGRADE_COST.get())));
    }

    private void changeIronCount(int delta) {
        this.setIronCount(this.ironCount + delta);
    }

    public byte getBars() {
        return (Byte)this.field_70180_af.func_187225_a(BARS);
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    protected void func_213337_cE() {
        int blockCount = this.ironCount / 9;
        int barCount = this.ironCount % 9;
        this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151042_j, barCount));
        this.func_199701_a_(new ItemStack((IItemProvider)Items.field_221698_bk, blockCount));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ironCount", this.ironCount);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!compound.func_74764_b("variants")) {
            this.setEarring(compound.func_74767_n("hasEarring"));
            this.setMarioMoustache(compound.func_74767_n("hasMarioMoustache"));
            this.setSquareHair(compound.func_74767_n("hasSquareHair"));
        }
        this.setIronCount(compound.func_74762_e("ironCount"));
    }

    private static class UpgradeGoal
    extends Goal {
        private static final CachedInt MAX_COOLDOWN = Occultism.SERVER_CONFIG.spiritJobs.blacksmithFamiliarUpgradeCooldown;
        private final BlacksmithFamiliarEntity blacksmith;
        private IFamiliar target;
        private int cooldown = MAX_COOLDOWN.get();

        public UpgradeGoal(BlacksmithFamiliarEntity blacksmith) {
            this.blacksmith = blacksmith;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.target = this.findTarget();
            return this.blacksmith.ironCount >= UPGRADE_COST.get() && this.target != null && this.cooldown-- < 0;
        }

        public boolean func_75253_b() {
            return this.target != null;
        }

        public void func_75249_e() {
            this.blacksmith.func_70661_as().func_75497_a(this.target.getFamiliarEntity(), 0.7);
        }

        public void func_75251_c() {
            this.blacksmith.func_70661_as().func_75499_g();
            this.cooldown = MAX_COOLDOWN.get();
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null) {
                return;
            }
            if (!this.blacksmith.func_70781_l()) {
                this.blacksmith.func_70661_as().func_75497_a(this.target.getFamiliarEntity(), 0.7);
            }
            if (this.blacksmith.func_70068_e(this.target.getFamiliarEntity()) < 3.0) {
                if (this.target.canBlacksmithUpgrade()) {
                    this.target.blacksmithUpgrade();
                    this.blacksmith.changeIronCount(-UPGRADE_COST.get());
                    OccultismAdvancements.FAMILIAR.trigger(this.blacksmith.getFamiliarOwner(), FamiliarTrigger.Type.BLACKSMITH_UPGRADE);
                }
                this.target = null;
            }
        }

        private IFamiliar findTarget() {
            Iterator iterator = this.blacksmith.field_70170_p.func_175647_a(LivingEntity.class, this.blacksmith.func_174813_aQ().func_186662_g(4.0), e -> this.familiarPred((Entity)e)).iterator();
            if (iterator.hasNext()) {
                LivingEntity e2 = (LivingEntity)iterator.next();
                return (IFamiliar)e2;
            }
            return null;
        }

        private boolean familiarPred(Entity e) {
            if (!(e instanceof IFamiliar)) {
                return false;
            }
            IFamiliar familiar = (IFamiliar)e;
            LivingEntity owner = familiar.getFamiliarOwner();
            return familiar.canBlacksmithUpgrade() && owner != null && owner == this.blacksmith.getFamiliarOwner();
        }
    }
}

