/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container.storage;

import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.github.klikli_dev.occultism.common.misc.StorageControllerSlot;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public abstract class StorageControllerContainerBase
extends Container
implements IStorageControllerContainer {
    public PlayerInventory playerInventory;
    public PlayerEntity player;
    protected CraftResultInventory result;
    protected StorageControllerCraftingInventory matrix;
    protected Inventory orderInventory;
    protected ICraftingRecipe currentRecipe;
    protected boolean recipeLocked = false;

    protected StorageControllerContainerBase(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory) {
        super(type, id);
        this.playerInventory = playerInventory;
        this.player = playerInventory.field_70458_d;
        this.result = new CraftResultInventory();
        this.orderInventory = new Inventory(1);
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        return GlobalBlockPos.from((TileEntity)this.getStorageController());
    }

    @Override
    public CraftingInventory getCraftMatrix() {
        return this.matrix;
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.recipeLocked) {
            return;
        }
        this.findRecipeForMatrix();
    }

    @Override
    public Inventory getOrderSlot() {
        return this.orderInventory;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        if (player.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            IStorageController storageController = this.getStorageController();
            if (index == 0) {
                this.craftShift(player, storageController);
                return ItemStack.field_190927_a;
            }
            if (storageController != null) {
                int remainingItems = storageController.insertStack(slotStack, false);
                ItemStack remainingItemStack = remainingItems == 0 ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)slotStack, (int)remainingItems);
                slot.func_75215_d(remainingItemStack);
                this.func_75142_b();
                OccultismPackets.sendTo((ServerPlayerEntity)player, storageController.getMessageUpdateStacks());
                if (!remainingItemStack.func_190926_b()) {
                    slot.func_190901_a(player, slotStack);
                }
                return ItemStack.field_190927_a;
            }
        }
        return result;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.updateCraftingSlots(false);
        this.updateOrderSlot(true);
        super.func_75134_a(playerIn);
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 174;
        int playerInventoryLeft = 56;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupCraftingGrid() {
        int craftingGridTop = 113;
        int craftingGridLeft = 85;
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.matrix, index++, craftingGridLeft + j * 18, craftingGridTop + i * 18));
            }
        }
    }

    protected void setupCraftingOutput() {
        int craftingOutputTop = 131;
        int craftingOutputLeft = 178;
        StorageControllerSlot slotCraftOutput = new StorageControllerSlot(this.playerInventory.field_70458_d, this.matrix, (IInventory)this.result, this, 0, craftingOutputLeft, craftingOutputTop);
        this.func_75146_a((Slot)slotCraftOutput);
    }

    protected void setupOrderInventorySlot() {
        int orderSlotTop = 36;
        int orderSlotLeft = 13;
        this.func_75146_a(new Slot((IInventory)this.orderInventory, 0, orderSlotLeft, orderSlotTop));
    }

    protected abstract void setupPlayerHotbar();

    protected void findRecipeForMatrixClient() {
        Optional optional = this.player.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.matrix, this.player.field_70170_p);
        optional.ifPresent(iCraftingRecipe -> {
            this.currentRecipe = iCraftingRecipe;
        });
    }

    protected void findRecipeForMatrix() {
        if (!this.player.field_70170_p.field_72995_K) {
            ICraftingRecipe icraftingrecipe;
            this.currentRecipe = null;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)this.player;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = this.player.field_70170_p.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.matrix, this.player.field_70170_p);
            if (optional.isPresent() && this.result.func_201561_a(this.player.field_70170_p, serverplayerentity, (IRecipe)(icraftingrecipe = (ICraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.func_77572_b((IInventory)this.matrix);
                this.currentRecipe = icraftingrecipe;
            }
            this.result.func_70299_a(0, itemstack);
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, itemstack));
        }
    }

    protected void craftShift(PlayerEntity player, IStorageController storageController) {
        ItemStack newResult;
        if (this.matrix == null) {
            return;
        }
        this.findRecipeForMatrixClient();
        if (this.currentRecipe == null) {
            return;
        }
        this.recipeLocked = true;
        ArrayList<ItemStack> recipeCopy = new ArrayList<ItemStack>(this.matrix.func_70302_i_());
        for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
            recipeCopy.add(this.matrix.func_70301_a(i).func_77946_l());
        }
        ItemStack result = this.currentRecipe.func_77572_b((IInventory)this.matrix);
        if (result.func_190926_b()) {
            return;
        }
        int resultStackSize = result.func_190916_E();
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        int crafted = 0;
        while (crafted + resultStackSize <= result.func_77976_d() && this.currentRecipe != null && (newResult = this.currentRecipe.func_77572_b((IInventory)this.matrix).func_77946_l()).func_77973_b() == result.func_77973_b() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInventory), (ItemStack)newResult, (boolean)true).func_190926_b() && this.currentRecipe.func_77569_a((IInventory)this.matrix, player.field_70170_p)) {
            int i;
            resultList.add(newResult);
            NonNullList remainingCraftingItems = this.currentRecipe.func_179532_b((IInventory)this.matrix);
            for (i = 0; i < remainingCraftingItems.size(); ++i) {
                ItemStack currentCraftingItem = ((ItemStack)remainingCraftingItems.get(i)).func_77946_l();
                ItemStack stackInSlot = this.matrix.func_70301_a(i);
                if (currentCraftingItem.func_190926_b()) {
                    this.matrix.func_70301_a(i).func_190918_g(1);
                    continue;
                }
                if (!stackInSlot.func_77973_b().getContainerItem(stackInSlot).func_190926_b()) {
                    ItemStack container = stackInSlot.func_77973_b().getContainerItem(stackInSlot);
                    if (!stackInSlot.func_77985_e()) {
                        stackInSlot = container;
                        this.matrix.func_70299_a(i, stackInSlot);
                        continue;
                    }
                    stackInSlot.func_190918_g(1);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)container);
                    continue;
                }
                if (!currentCraftingItem.func_190926_b()) {
                    if (stackInSlot.func_190926_b()) {
                        this.matrix.func_70299_a(i, currentCraftingItem);
                        continue;
                    }
                    if (!stackInSlot.func_77973_b().func_77645_m() && ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)currentCraftingItem) && ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                        if (!stackInSlot.func_77973_b().getRegistryName().toString().equals("aquaculture:neptunium_fillet_knife")) {
                            currentCraftingItem.func_190917_f(stackInSlot.func_190916_E());
                        }
                        this.matrix.func_70299_a(i, currentCraftingItem);
                        continue;
                    }
                    if (ItemStack.func_185132_d((ItemStack)stackInSlot, (ItemStack)currentCraftingItem)) {
                        this.matrix.func_70299_a(i, currentCraftingItem);
                        continue;
                    }
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)newResult);
                    continue;
                }
                if (stackInSlot.func_190926_b()) continue;
                this.matrix.func_70298_a(i, 1);
                stackInSlot = this.matrix.func_70301_a(i);
            }
            crafted += resultStackSize;
            for (i = 0; i < this.matrix.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.matrix.func_70301_a(i);
                if (!stackInSlot.func_190926_b()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackComparator comparator = !recipeStack.func_190926_b() ? new ItemStackComparator(recipeStack) : null;
                ItemStack requestedItem = this.getStorageController().getItemStack(comparator, 1, false);
                this.matrix.func_70299_a(i, requestedItem);
            }
            this.func_75130_a((IInventory)this.matrix);
        }
        ItemStack finalResult = new ItemStack((IItemProvider)result.func_77973_b(), 0);
        for (ItemStack intermediateResult : resultList) {
            finalResult.func_190920_e(finalResult.func_190916_E() + intermediateResult.func_190916_E());
        }
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)finalResult);
        this.func_75142_b();
        this.recipeLocked = false;
        this.func_75130_a((IInventory)this.matrix);
        OccultismPackets.sendTo((ServerPlayerEntity)player, this.getStorageController().getMessageUpdateStacks());
    }
}

