/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.capability;

import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class FamiliarSettingsCapability {
    private static ImmutableList<EntityType<? extends IFamiliar>> familiars = null;
    private final Map<EntityType<?>, Boolean> familiarEnabled = new HashMap();

    public FamiliarSettingsCapability() {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            this.familiarEnabled.put(familiar, true);
        }
    }

    public static List<EntityType<? extends IFamiliar>> getFamiliars() {
        if (familiars == null) {
            familiars = ImmutableList.of((Object)OccultismEntities.GREEDY_FAMILIAR_TYPE.get(), (Object)OccultismEntities.OTHERWORLD_BIRD_TYPE.get(), (Object)OccultismEntities.BAT_FAMILIAR_TYPE.get(), (Object)OccultismEntities.DEER_FAMILIAR_TYPE.get(), (Object)OccultismEntities.CTHULHU_FAMILIAR_TYPE.get(), (Object)OccultismEntities.DEVIL_FAMILIAR_TYPE.get(), (Object)OccultismEntities.DRAGON_FAMILIAR_TYPE.get(), (Object)OccultismEntities.BLACKSMITH_FAMILIAR_TYPE.get(), (Object)OccultismEntities.GUARDIAN_FAMILIAR_TYPE.get(), (Object)OccultismEntities.HEADLESS_FAMILIAR_TYPE.get(), (Object)OccultismEntities.CHIMERA_FAMILIAR_TYPE.get(), (Object)OccultismEntities.GOAT_FAMILIAR_TYPE.get(), (Object[])new EntityType[]{(EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.BEHOLDER_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.FAIRY_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.MUMMY_FAMILIAR_TYPE.get()});
        }
        return familiars;
    }

    public void clone(FamiliarSettingsCapability settings) {
        for (Map.Entry<EntityType<?>, Boolean> entry : settings.familiarEnabled.entrySet()) {
            this.familiarEnabled.put(entry.getKey(), entry.getValue());
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        for (Map.Entry<EntityType<?>, Boolean> entry : this.familiarEnabled.entrySet()) {
            compound.func_74757_a(entry.getKey().getRegistryName().func_110623_a(), entry.getValue().booleanValue());
        }
        return compound;
    }

    public CompoundNBT read(CompoundNBT compound) {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            if (!compound.func_74764_b(familiar.getRegistryName().func_110623_a())) continue;
            this.familiarEnabled.put(familiar, compound.func_74767_n(familiar.getRegistryName().func_110623_a()));
        }
        return compound;
    }

    public void setFamiliarEnabled(EntityType<?> familiar, boolean b) {
        this.familiarEnabled.put(familiar, b);
    }

    public boolean isFamiliarEnabled(EntityType<?> familiar) {
        return this.familiarEnabled.get(familiar);
    }

    public static class Dispatcher
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<FamiliarSettingsCapability> familiarSettingsCapability = LazyOptional.of(FamiliarSettingsCapability::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == OccultismCapabilities.FAMILIAR_SETTINGS) {
                return this.familiarSettingsCapability.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            this.familiarSettingsCapability.ifPresent(capability -> capability.write(nbt));
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.familiarSettingsCapability.ifPresent(capability -> capability.read(nbt));
        }
    }

    public static class Storage
    implements Capability.IStorage<FamiliarSettingsCapability> {
        public INBT writeNBT(Capability<FamiliarSettingsCapability> capability, FamiliarSettingsCapability instance, Direction facing) {
            return instance.write(new CompoundNBT());
        }

        public void readNBT(Capability<FamiliarSettingsCapability> capability, FamiliarSettingsCapability instance, Direction side, INBT nbt) {
            instance.read((CompoundNBT)nbt);
        }
    }
}

