/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ChalkGlyphBlock
extends Block {
    public static final IntegerProperty SIGN = IntegerProperty.func_177719_a((String)"sign", (int)0, (int)12);
    public static final int MAX_SIGN = 12;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)0.04, (double)15.0);
    protected Supplier<Item> chalk;
    protected int color;

    public ChalkGlyphBlock(AbstractBlock.Properties properties, int color, Supplier<Item> chalk) {
        super(properties);
        this.color = color;
        this.chalk = chalk;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public Item getChalk() {
        return this.chalk.get();
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return true;
    }

    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_217377_a(pos, false);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        BlockState downState = worldIn.func_180495_p(down);
        return downState.func_224755_d((IBlockReader)worldIn, down, Direction.UP) && state.func_185904_a().func_76222_j();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        int sign = context.func_195991_k().func_201674_k().nextInt(13);
        BlockState current = context.func_195991_k().func_180495_p(pos);
        if (current.func_177230_c() == this) {
            sign = ((Integer)current.func_177229_b((Property)SIGN) + 1) % 13;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SIGN, (Comparable)Integer.valueOf(sign))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SIGN, BlockStateProperties.field_208157_J});
        super.func_206840_a(builder);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (ForgeRegistries.ITEMS.containsKey(this.getChalk().getRegistryName())) {
            return new ItemStack((IItemProvider)this.getChalk());
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.OPEN;
    }
}

