/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.MummyFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.MummyFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class MummyFamiliarRenderer
extends MobRenderer<MummyFamiliarEntity, MummyFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/mummy_familiar.png");

    public MummyFamiliarRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new MummyFamiliarModel(), 0.3f);
        this.func_177094_a(new KapowLayer(this));
        this.func_177094_a(new EyesLayer((IEntityRenderer<MummyFamiliarEntity, MummyFamiliarModel>)this));
    }

    public void render(MummyFamiliarEntity mummy, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)mummy, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(MummyFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class KapowModel
    extends Model {
        public ModelRenderer kapow;

        public KapowModel() {
            super(RenderType::func_228644_e_);
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this.kapow = new ModelRenderer((Model)this, 0, 0);
            this.kapow.func_78793_a(0.0f, 0.0f, 0.0f);
            this.kapow.func_228302_a_(-16.0f, -16.0f, 0.0f, 32.0f, 32.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            ImmutableList.of((Object)this.kapow).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
        }
    }

    private static class KapowLayer
    extends LayerRenderer<MummyFamiliarEntity, MummyFamiliarModel> {
        private static final ResourceLocation KAPOW_TEXTURE = new ResourceLocation("occultism", "textures/entity/kapow.png");
        private static final TranslationTextComponent KAPOW_TEXT = new TranslationTextComponent("dialog.occultism.mummy.kapow");
        private static KapowModel model = new KapowModel();
        private MummyFamiliarRenderer renderer;

        public KapowLayer(MummyFamiliarRenderer renderer) {
            super((IEntityRenderer)renderer);
            this.renderer = renderer;
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MummyFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.getFightPose() == -1) {
                return;
            }
            float alpha = entitylivingbaseIn.getCapowAlpha(partialTicks);
            matrixStackIn.func_227860_a_();
            float scale = 0.5f;
            matrixStackIn.func_227862_a_(scale, scale, scale);
            Vector3d capowPos = entitylivingbaseIn.getCapowPosition(partialTicks);
            matrixStackIn.func_227861_a_(capowPos.field_72450_a, -0.4 + capowPos.field_72448_b, capowPos.field_72449_c);
            model.func_225598_a_(matrixStackIn, bufferIn.getBuffer(model.func_228282_a_(KAPOW_TEXTURE)), packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(0.07f, 0.07f, 0.07f);
            matrixStackIn.func_227861_a_(0.0, -2.5, 0.0);
            matrixStackIn.func_227863_a_(new Quaternion(0.0f, 0.0f, 20.0f, true));
            FontRenderer font = this.renderer.func_76983_a();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.0, -0.01);
            Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
            font.func_243247_a((ITextComponent)KAPOW_TEXT, (float)(-font.func_238414_a_((ITextProperties)KAPOW_TEXT) / 2), 0.0f, 0xFF0000 | (int)(alpha * 255.0f) << 24, true, matrix, bufferIn, false, 0, packedLightIn);
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.01);
            matrixStackIn.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
            matrix = matrixStackIn.func_227866_c_().func_227870_a_();
            font.func_243247_a((ITextComponent)KAPOW_TEXT, (float)(-font.func_238414_a_((ITextProperties)KAPOW_TEXT) / 2), 0.0f, 0xFF0000 | (int)(alpha * 255.0f) << 24, true, matrix, bufferIn, false, 0, packedLightIn);
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
    }

    private static class EyesLayer
    extends LayerRenderer<MummyFamiliarEntity, MummyFamiliarModel> {
        private static final ResourceLocation EYES = new ResourceLocation("occultism", "textures/entity/mummy_familiar_eyes.png");

        public EyesLayer(IEntityRenderer<MummyFamiliarEntity, MummyFamiliarModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MummyFamiliarEntity mummy, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (mummy.func_82150_aj()) {
                return;
            }
            int light = mummy.isSitting() ? 0 : 10;
            MummyFamiliarModel model = (MummyFamiliarModel)this.func_215332_c();
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)EYES));
            model.func_225598_a_(matrixStackIn, ivertexbuilder, LightTexture.func_228451_a_((int)light, (int)light), LivingRenderer.func_229117_c_((LivingEntity)mummy, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

