/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.DragonFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class DragonFamiliarModel
extends EntityModel<DragonFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelRenderer body;
    public ModelRenderer neck1;
    public ModelRenderer leftLeg1;
    public ModelRenderer tail1;
    public ModelRenderer leftWing1;
    public ModelRenderer rightWing1;
    public ModelRenderer rightLeg1;
    public ModelRenderer leftArm1;
    public ModelRenderer rightArm1;
    public ModelRenderer neck2;
    public ModelRenderer head;
    public ModelRenderer jaw;
    public ColorModelRenderer leftEye;
    public ColorModelRenderer rightEye;
    public ModelRenderer fez1;
    public ModelRenderer leftHorn1;
    public ModelRenderer leftEar;
    public ModelRenderer rightEar;
    public ModelRenderer rightHorn1;
    public ModelRenderer tooth1;
    public ModelRenderer tooth2;
    public ModelRenderer tooth4;
    public ModelRenderer leftNose;
    public ModelRenderer rightNose;
    public ModelRenderer fez2;
    public ModelRenderer leftHorn2;
    public ModelRenderer rightHorn2;
    public ModelRenderer leftLeg2;
    public ModelRenderer leftLeg3;
    public ModelRenderer tail2;
    public ModelRenderer spike1;
    public ModelRenderer tail3;
    public ModelRenderer spike2;
    public ModelRenderer spike3;
    public ModelRenderer leftWing2;
    public ModelRenderer rightWing2;
    public ModelRenderer rightLeg2;
    public ModelRenderer rightLeg3;
    public ModelRenderer leftArm2;
    public ModelRenderer leftArm3;
    public ModelRenderer rightArm2;
    public ModelRenderer rightArm3;

    public DragonFamiliarModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.leftHorn2 = new ModelRenderer((Model)this, 6, 14);
        this.leftHorn2.func_78793_a(0.01f, 0.0f, 1.4f);
        this.leftHorn2.func_228302_a_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftHorn2, 0.34906584f, 0.0f, 0.0f);
        this.rightLeg3 = new ModelRenderer((Model)this, 28, 7);
        this.rightLeg3.field_78809_i = true;
        this.rightLeg3.func_78793_a(0.0f, 2.2f, 0.8f);
        this.rightLeg3.func_228302_a_(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightLeg3, 0.39095375f, 0.0f, 0.0f);
        this.rightNose = new ModelRenderer((Model)this, 45, 1);
        this.rightNose.func_78793_a(0.8f, -1.4f, -2.6f);
        this.rightNose.func_228302_a_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.spike2 = new ModelRenderer((Model)this, 0, 25);
        this.spike2.func_78793_a(0.01f, -4.0f, 0.0f);
        this.spike2.func_228302_a_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.rightWing1 = new ModelRenderer((Model)this, 0, 9);
        this.rightWing1.field_78809_i = true;
        this.rightWing1.func_78793_a(-2.0f, 0.0f, -2.0f);
        this.rightWing1.func_228302_a_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightWing1, 0.0f, 0.0f, -0.86009824f);
        this.rightEar = new ModelRenderer((Model)this, 12, 14);
        this.rightEar.field_78809_i = true;
        this.rightEar.func_78793_a(-1.7f, -0.6f, -0.6f);
        this.rightEar.func_228302_a_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightEar, -0.13613568f, -1.1798426f, 0.5899213f);
        this.leftHorn1 = new ModelRenderer((Model)this, 0, 14);
        this.leftHorn1.func_78793_a(1.7f, -0.5f, -0.5f);
        this.leftHorn1.func_228302_a_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftHorn1, 0.2268928f, 0.0f, 0.0f);
        this.leftWing2 = new ModelRenderer((Model)this, 0, 14);
        this.leftWing2.func_78793_a(0.0f, -5.0f, 0.0f);
        this.leftWing2.func_228302_a_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftWing2, 0.0f, 0.0f, 0.86009824f);
        this.tooth4 = new ModelRenderer((Model)this, 59, 0);
        this.tooth4.func_78793_a(-1.7f, -0.4f, -1.6f);
        this.tooth4.func_228302_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.tail3 = new ModelRenderer((Model)this, 18, 6);
        this.tail3.func_78793_a(0.0f, 0.0f, 3.4f);
        this.tail3.func_228302_a_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail3, 0.19547687f, 0.0f, 0.0f);
        this.rightWing2 = new ModelRenderer((Model)this, 0, 14);
        this.rightWing2.field_78809_i = true;
        this.rightWing2.func_78793_a(0.0f, -5.0f, 0.0f);
        this.rightWing2.func_228302_a_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightWing2, 0.0f, 0.0f, -0.86009824f);
        this.leftEye = new ColorModelRenderer((Model)this, 56, 3);
        this.leftEye.func_78793_a(1.5f, -0.1f, -2.4f);
        this.leftEye.func_228302_a_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.leftLeg1 = new ModelRenderer((Model)this, 44, 5);
        this.leftLeg1.func_78793_a(1.8f, 0.5f, 2.0f);
        this.leftLeg1.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftLeg1, 0.43004912f, 0.0f, 0.0f);
        this.leftLeg2 = new ModelRenderer((Model)this, 50, 5);
        this.leftLeg2.func_78793_a(0.01f, 2.4f, 0.5f);
        this.leftLeg2.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftLeg2, -0.74281216f, 0.0f, 0.0f);
        this.rightArm1 = new ModelRenderer((Model)this, 0, 5);
        this.rightArm1.func_78793_a(-1.6f, 1.1f, -4.0f);
        this.rightArm1.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.leftEar = new ModelRenderer((Model)this, 12, 14);
        this.leftEar.func_78793_a(1.7f, -0.6f, -0.6f);
        this.leftEar.func_228302_a_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftEar, -0.13613568f, 1.1798426f, -0.5899213f);
        this.rightLeg1 = new ModelRenderer((Model)this, 44, 5);
        this.rightLeg1.field_78809_i = true;
        this.rightLeg1.func_78793_a(-1.8f, 0.5f, 2.0f);
        this.rightLeg1.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightLeg1, 0.43004912f, 0.0f, 0.0f);
        this.leftArm1 = new ModelRenderer((Model)this, 0, 5);
        this.leftArm1.func_78793_a(1.6f, 1.1f, -4.0f);
        this.leftArm1.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 18.0f, 0.0f);
        this.body.func_228302_a_(-2.0f, -2.0f, -5.0f, 4.0f, 4.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.body, -0.06981317f, 0.0f, 0.0f);
        this.fez2 = new ModelRenderer((Model)this, 24, 13);
        this.fez2.func_78793_a(0.0f, -3.0f, 0.0f);
        this.fez2.func_228302_a_(0.0f, 0.0f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.leftArm3 = new ModelRenderer((Model)this, 0, 8);
        this.leftArm3.func_78793_a(0.1f, 2.1f, 0.0f);
        this.leftArm3.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftArm3, 0.0f, 0.0f, -0.7853982f);
        this.fez1 = new ModelRenderer((Model)this, 18, 14);
        this.fez1.func_78793_a(0.0f, -1.5f, -2.0f);
        this.fez1.func_228302_a_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.tooth2 = new ModelRenderer((Model)this, 59, 0);
        this.tooth2.func_78793_a(0.0f, -0.3f, -3.2f);
        this.tooth2.func_228302_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.rightEye = new ColorModelRenderer((Model)this, 56, 3);
        this.rightEye.field_78809_i = true;
        this.rightEye.func_78793_a(-2.5f, -0.1f, -2.4f);
        this.rightEye.func_228302_a_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.tail2 = new ModelRenderer((Model)this, 50, 10);
        this.tail2.func_78793_a(0.0f, 0.0f, 3.3f);
        this.tail2.func_228302_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail2, -0.23457225f, 0.0f, 0.0f);
        this.leftLeg3 = new ModelRenderer((Model)this, 28, 7);
        this.leftLeg3.func_78793_a(0.0f, 2.2f, 0.8f);
        this.leftLeg3.func_228302_a_(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftLeg3, 0.39095375f, 0.0f, 0.0f);
        this.jaw = new ModelRenderer((Model)this, 46, 0);
        this.jaw.func_78793_a(0.0f, 0.2f, -4.0f);
        this.jaw.func_228302_a_(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.leftNose = new ModelRenderer((Model)this, 45, 1);
        this.leftNose.func_78793_a(-0.8f, -1.4f, -2.6f);
        this.leftNose.func_228302_a_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.spike1 = new ModelRenderer((Model)this, 0, 25);
        this.spike1.func_78793_a(0.0f, -4.5f, 0.0f);
        this.spike1.func_228302_a_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.spike3 = new ModelRenderer((Model)this, 8, 26);
        this.spike3.func_78793_a(0.0f, -3.5f, 0.0f);
        this.spike3.func_228302_a_(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.tooth1 = new ModelRenderer((Model)this, 59, 0);
        this.tooth1.func_78793_a(0.7f, -0.4f, -1.5f);
        this.tooth1.func_228302_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.leftWing1 = new ModelRenderer((Model)this, 0, 9);
        this.leftWing1.func_78793_a(2.0f, 0.0f, -2.0f);
        this.leftWing1.func_228302_a_(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftWing1, 0.0f, 0.0f, 1.1414454f);
        this.leftArm2 = new ModelRenderer((Model)this, 0, 8);
        this.leftArm2.func_78793_a(-0.1f, 2.1f, 0.0f);
        this.leftArm2.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftArm2, 0.0f, 0.0f, 0.7853982f);
        this.neck2 = new ModelRenderer((Model)this, 0, 0);
        this.neck2.func_78793_a(0.0f, 0.0f, -2.4f);
        this.neck2.func_228302_a_(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.neck2, -0.1563815f, 0.0f, 0.0f);
        this.rightArm2 = new ModelRenderer((Model)this, 0, 8);
        this.rightArm2.func_78793_a(-0.1f, 2.1f, 0.0f);
        this.rightArm2.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightArm2, 0.0f, 0.0f, 0.7853982f);
        this.rightArm3 = new ModelRenderer((Model)this, 0, 8);
        this.rightArm3.func_78793_a(0.1f, 2.1f, 0.0f);
        this.rightArm3.func_228302_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightArm3, 0.0f, 0.0f, -0.7853982f);
        this.tail1 = new ModelRenderer((Model)this, 36, 10);
        this.tail1.func_78793_a(0.0f, 0.0f, 4.3f);
        this.tail1.func_228302_a_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail1, -0.23457225f, 0.0f, 0.0f);
        this.neck1 = new ModelRenderer((Model)this, 18, 0);
        this.neck1.func_78793_a(0.0f, 0.2f, -4.1f);
        this.neck1.func_228302_a_(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.neck1, -0.54733527f, 0.0f, 0.0f);
        this.head = new ModelRenderer((Model)this, 30, 0);
        this.head.func_78793_a(0.0f, -0.4f, -2.4f);
        this.head.func_228302_a_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.head, 0.82135195f, 0.0f, 0.0f);
        this.rightLeg2 = new ModelRenderer((Model)this, 50, 5);
        this.rightLeg2.field_78809_i = true;
        this.rightLeg2.func_78793_a(-0.01f, 2.4f, 0.5f);
        this.rightLeg2.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightLeg2, -0.74281216f, 0.0f, 0.0f);
        this.rightHorn2 = new ModelRenderer((Model)this, 6, 14);
        this.rightHorn2.field_78809_i = true;
        this.rightHorn2.func_78793_a(-0.01f, 0.0f, 1.4f);
        this.rightHorn2.func_228302_a_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightHorn2, 0.34906584f, 0.0f, 0.0f);
        this.rightHorn1 = new ModelRenderer((Model)this, 0, 14);
        this.rightHorn1.field_78809_i = true;
        this.rightHorn1.func_78793_a(-1.7f, -0.5f, -0.5f);
        this.rightHorn1.func_228302_a_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightHorn1, 0.2268928f, 0.0f, 0.0f);
        this.leftHorn1.func_78792_a(this.leftHorn2);
        this.rightLeg2.func_78792_a(this.rightLeg3);
        this.jaw.func_78792_a(this.rightNose);
        this.tail2.func_78792_a(this.spike2);
        this.body.func_78792_a(this.rightWing1);
        this.head.func_78792_a(this.rightEar);
        this.head.func_78792_a(this.leftHorn1);
        this.leftWing1.func_78792_a(this.leftWing2);
        this.jaw.func_78792_a(this.tooth4);
        this.tail2.func_78792_a(this.tail3);
        this.rightWing1.func_78792_a(this.rightWing2);
        this.head.func_78792_a((ModelRenderer)this.leftEye);
        this.body.func_78792_a(this.leftLeg1);
        this.leftLeg1.func_78792_a(this.leftLeg2);
        this.body.func_78792_a(this.rightArm1);
        this.head.func_78792_a(this.leftEar);
        this.body.func_78792_a(this.rightLeg1);
        this.body.func_78792_a(this.leftArm1);
        this.fez1.func_78792_a(this.fez2);
        this.leftArm1.func_78792_a(this.leftArm3);
        this.head.func_78792_a(this.fez1);
        this.jaw.func_78792_a(this.tooth2);
        this.head.func_78792_a((ModelRenderer)this.rightEye);
        this.tail1.func_78792_a(this.tail2);
        this.leftLeg2.func_78792_a(this.leftLeg3);
        this.head.func_78792_a(this.jaw);
        this.jaw.func_78792_a(this.leftNose);
        this.tail1.func_78792_a(this.spike1);
        this.tail3.func_78792_a(this.spike3);
        this.jaw.func_78792_a(this.tooth1);
        this.body.func_78792_a(this.leftWing1);
        this.leftArm1.func_78792_a(this.leftArm2);
        this.neck1.func_78792_a(this.neck2);
        this.rightArm1.func_78792_a(this.rightArm2);
        this.rightArm1.func_78792_a(this.rightArm3);
        this.body.func_78792_a(this.tail1);
        this.body.func_78792_a(this.neck1);
        this.neck2.func_78792_a(this.head);
        this.rightLeg1.func_78792_a(this.rightLeg2);
        this.rightHorn1.func_78792_a(this.rightHorn2);
        this.head.func_78792_a(this.rightHorn1);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setupAnim(DragonFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.isPartying()) {
            this.head.field_78795_f = this.toRads(50.0f) + MathHelper.func_76126_a((float)ageInTicks) * this.toRads(20.0f);
            this.head.field_78796_g = MathHelper.func_76126_a((float)ageInTicks) * this.toRads(5.0f);
            this.head.field_78808_h = MathHelper.func_76126_a((float)ageInTicks) * this.toRads(5.0f);
        } else {
            this.head.field_78795_f = this.toRads(50.0f) + 0.03f + headPitch * ((float)Math.PI / 180) * 0.7f;
            this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.head.field_78808_h = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
        }
    }

    public void prepareMobModel(DragonFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.setEyeColor(entityIn.getEyeColorR(partialTick), entityIn.getEyeColorG(partialTick), entityIn.getEyeColorB(partialTick));
        this.showModels(entityIn);
        float ageInTicks = (float)entityIn.field_70173_aa + partialTick;
        boolean hasSword = entityIn.hasSword();
        this.tail1.field_78808_h = 0.0f;
        this.tail2.field_78808_h = 0.0f;
        this.tail3.field_78808_h = 0.0f;
        this.jaw.field_78808_h = 0.0f;
        if (entityIn.isPartying()) {
            if (!hasSword) {
                this.tail1.field_78808_h = MathHelper.func_76126_a((float)ageInTicks) * this.toRads(30.0f);
                this.tail2.field_78808_h = -MathHelper.func_76126_a((float)ageInTicks) * this.toRads(60.0f);
                this.tail3.field_78808_h = MathHelper.func_76126_a((float)ageInTicks) * this.toRads(90.0f);
            }
            this.leftWing1.field_78796_g = MathHelper.func_76126_a((float)ageInTicks) * this.toRads(20.0f);
            this.rightWing1.field_78796_g = -MathHelper.func_76126_a((float)ageInTicks) * this.toRads(20.0f);
        } else {
            this.leftWing1.field_78796_g = 0.0f;
            this.rightWing1.field_78796_g = 0.0f;
        }
        float petTimer = (float)entityIn.getPetTimer() + partialTick;
        float petDuration = 20.0f;
        if (petTimer < petDuration) {
            this.tail1.field_78808_h = MathHelper.func_76126_a((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.tail2.field_78808_h = MathHelper.func_76126_a((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.tail3.field_78808_h = MathHelper.func_76126_a((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.jaw.field_78808_h = -MathHelper.func_76126_a((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(10.0f);
        }
        if (entityIn.field_82175_bq && !hasSword) {
            float attackProgress = entityIn.getAttackProgress(partialTick);
            this.tail1.field_78796_g = MathHelper.func_76126_a((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
            this.tail2.field_78796_g = MathHelper.func_76126_a((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
            this.tail3.field_78796_g = MathHelper.func_76126_a((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
        } else {
            this.tail1.field_78796_g = 0.0f;
            this.tail2.field_78796_g = 0.0f;
            this.tail3.field_78796_g = 0.0f;
        }
        if (!entityIn.isSitting()) {
            this.leftLeg1.field_78795_f = this.toRads(25.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.7f + (float)Math.PI)) * limbSwingAmount * 0.5f;
            this.rightLeg1.field_78795_f = this.toRads(25.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.7f)) * limbSwingAmount * 0.5f;
            this.leftLeg3.field_78795_f = this.toRads(23.0f);
            this.rightLeg3.field_78795_f = this.toRads(23.0f);
            float flyingTimer = entityIn.getFlyingTimer(partialTick);
            float wingspan = entityIn.getWingspan(partialTick);
            float flyingWingRot = flyingTimer * 1.15f;
            this.leftWing1.field_78808_h = this.toRads(65.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan));
            this.leftWing2.field_78808_h = this.toRads(50.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan) * 0.5f);
            this.rightWing1.field_78808_h = -this.toRads(65.0f) - MathHelper.func_76134_b((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan));
            this.rightWing2.field_78808_h = -this.toRads(50.0f) - MathHelper.func_76134_b((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan) * 0.5f);
            float extraRot = hasSword ? this.toRads(30.0f) : 0.0f;
            this.tail1.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks / 20.0f)) * this.toRads(5.0f) + extraRot;
            this.tail2.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks / 20.0f)) * this.toRads(5.0f) + extraRot;
            this.tail3.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks / 20.0f)) * this.toRads(5.0f) + extraRot;
            this.body.field_78795_f = this.toRads(-4.0f);
            this.neck1.field_78795_f = this.toRads(-30.0f);
            this.neck2.field_78795_f = this.toRads(-9.0f);
        } else {
            this.leftLeg1.field_78795_f = this.toRads(15.0f);
            this.rightLeg1.field_78795_f = this.toRads(15.0f);
            this.leftLeg3.field_78795_f = this.toRads(26.0f);
            this.rightLeg3.field_78795_f = this.toRads(26.0f);
            this.leftWing1.field_78808_h = this.toRads(150.0f);
            this.leftWing2.field_78808_h = this.toRads(20.0f);
            this.rightWing1.field_78808_h = -this.toRads(150.0f);
            this.rightWing2.field_78808_h = -this.toRads(20.0f);
            float extraRot = hasSword ? this.toRads(10.0f) : 0.0f;
            this.tail1.field_78795_f = this.toRads(30.0f) + extraRot;
            this.tail2.field_78795_f = this.toRads(30.0f) + extraRot;
            this.tail3.field_78795_f = this.toRads(30.0f) + extraRot;
            this.body.field_78795_f = this.toRads(-50.0f);
            this.neck1.field_78795_f = this.toRads(10.0f);
            this.neck2.field_78795_f = this.toRads(5.0f);
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(DragonFamiliarEntity entityIn) {
        boolean hasEars = entityIn.hasEars();
        boolean hasArms = entityIn.hasArms();
        this.fez1.field_78806_j = entityIn.hasFez();
        this.leftEar.field_78806_j = hasEars;
        this.rightEar.field_78806_j = hasEars;
        this.leftHorn1.field_78806_j = !hasEars;
        this.rightHorn1.field_78806_j = !hasEars;
        this.leftArm1.field_78806_j = hasArms;
        this.rightArm1.field_78806_j = hasArms;
    }

    private void setEyeColor(float r, float g, float b) {
        this.leftEye.setColor(r, g, b);
        this.rightEye.setColor(r, g, b);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public static class ColorModelRenderer
    extends ModelRenderer {
        float r;
        float g;
        float b;
        float a;

        public ColorModelRenderer(Model model, int texOffX, int texOffY) {
            super(model, texOffX, texOffY);
        }

        public void setColor(float r, float g, float b) {
            this.setColor(r, g, b, 1.0f);
        }

        public void setColor(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public void func_228309_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            super.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, this.r, this.g, this.b, this.a);
        }
    }
}

