/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class DevilFamiliarModel
extends EntityModel<DevilFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelRenderer egg;
    public ModelRenderer body;
    public ModelRenderer leftLeg;
    public ModelRenderer leftArm;
    public ModelRenderer rightLeg;
    public ModelRenderer rightArm;
    public ModelRenderer neck1;
    public ModelRenderer leftWing;
    public ModelRenderer rightWing;
    public ModelRenderer head;
    public ModelRenderer lowerJaw;
    public ModelRenderer upperJaw;
    public ModelRenderer leftEye;
    public ModelRenderer headScales;
    public ModelRenderer leftEar;
    public ModelRenderer leftHorn;
    public ModelRenderer rightEye;
    public ModelRenderer rightHorn;
    public ModelRenderer rightEar;
    public ModelRenderer leftHornBig1;
    public ModelRenderer rightHornBig1;
    public ModelRenderer nose;
    public ModelRenderer tooth;
    public ModelRenderer jawHorn1;
    public ModelRenderer jawHorn2;
    public ModelRenderer leftHornBig2;
    public ModelRenderer leftHornBig3;
    public ModelRenderer rightHornBig2;
    public ModelRenderer rightHornBig3;
    public ModelRenderer lollipop;

    public DevilFamiliarModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.rightEye = new ModelRenderer((Model)this, 49, 0);
        this.rightEye.func_78793_a(-2.0f, -3.3f, -2.3f);
        this.rightEye.func_228302_a_(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightEye, 0.34906584f, 0.0f, 0.0f);
        this.rightHornBig3 = new ModelRenderer((Model)this, 0, 29);
        this.rightHornBig3.func_78793_a(0.0f, -1.7f, 0.0f);
        this.rightHornBig3.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightHornBig3, 0.5864306f, 0.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 12, 40);
        this.body.func_78793_a(0.0f, -7.0f, 0.0f);
        this.body.func_228302_a_(-3.0f, -6.0f, -3.0f, 6.0f, 12.0f, 6.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.body, -0.08726646f, 0.0f, 0.0f);
        this.lowerJaw = new ModelRenderer((Model)this, 24, 18);
        this.lowerJaw.func_78793_a(0.0f, -1.1f, -2.8f);
        this.lowerJaw.func_228302_a_(-2.0f, -1.0f, -5.0f, 4.0f, 2.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.lowerJaw, 0.33056536f, 0.0f, 0.0f);
        this.leftHornBig2 = new ModelRenderer((Model)this, 0, 29);
        this.leftHornBig2.func_78793_a(0.3f, -1.5f, 0.0f);
        this.leftHornBig2.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftHornBig2, 0.0f, 0.0f, 1.134464f);
        this.leftHornBig3 = new ModelRenderer((Model)this, 0, 29);
        this.leftHornBig3.func_78793_a(0.0f, -1.7f, 0.0f);
        this.leftHornBig3.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftHornBig3, 0.5864306f, 0.0f, 0.0f);
        this.rightHornBig2 = new ModelRenderer((Model)this, 0, 29);
        this.rightHornBig2.func_78793_a(-0.3f, -1.5f, 0.0f);
        this.rightHornBig2.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightHornBig2, 0.0f, 0.0f, -1.134464f);
        this.rightHorn = new ModelRenderer((Model)this, 0, 2);
        this.rightHorn.func_78793_a(-1.0f, -4.5f, -1.8f);
        this.rightHorn.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightHorn, 0.5403539f, -0.13508847f, -0.31520647f);
        this.tooth = new ModelRenderer((Model)this, 0, 0);
        this.tooth.func_78793_a(0.0f, 1.0f, -4.7f);
        this.tooth.func_228302_a_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.leftEye = new ModelRenderer((Model)this, 49, 0);
        this.leftEye.func_78793_a(2.0f, -3.3f, -2.3f);
        this.leftEye.func_228302_a_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftEye, 0.34906584f, 0.0f, 0.0f);
        this.upperJaw = new ModelRenderer((Model)this, 39, 23);
        this.upperJaw.func_78793_a(0.0f, -3.0f, -3.0f);
        this.upperJaw.func_228302_a_(-2.0f, -1.5f, -5.0f, 4.0f, 3.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.rightArm = new ModelRenderer((Model)this, 0, 30);
        this.rightArm.func_78793_a(-2.0f, -11.5f, 0.0f);
        this.rightArm.func_228302_a_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightArm, 0.35185838f, 0.19547687f, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 0, 30);
        this.leftArm.func_78793_a(2.0f, -11.5f, 0.0f);
        this.leftArm.func_228302_a_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftArm, 0.35185838f, -0.17453292f, 0.0f);
        this.jawHorn2 = new ModelRenderer((Model)this, 0, 29);
        this.jawHorn2.func_78793_a(0.0f, -2.7f, 0.0f);
        this.jawHorn2.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.jawHorn2, -0.1563815f, 0.0f, 0.0f);
        this.rightWing = new ModelRenderer((Model)this, 0, 40);
        this.rightWing.field_78809_i = true;
        this.rightWing.func_78793_a(-1.5f, -6.0f, 3.0f);
        this.rightWing.func_228302_a_(-6.0f, -5.0f, 0.0f, 6.0f, 6.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightWing, 0.35185838f, 0.50823987f, -0.11728612f);
        this.neck1 = new ModelRenderer((Model)this, 37, 0);
        this.neck1.func_78793_a(0.0f, -5.5f, 0.0f);
        this.neck1.func_228302_a_(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.neck1, 0.07400195f, 0.0f, 0.0f);
        this.lollipop = new ModelRenderer((Model)this, 0, 13);
        this.lollipop.func_78793_a(0.0f, -1.5f, -6.0f);
        this.lollipop.func_228302_a_(0.0f, -6.0f, -2.5f, 0.0f, 6.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 0, 30);
        this.rightLeg.field_78809_i = true;
        this.rightLeg.func_78793_a(-2.0f, -1.5f, -2.0f);
        this.rightLeg.func_228302_a_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightLeg, 0.0f, 0.19547687f, 0.0f);
        this.jawHorn1 = new ModelRenderer((Model)this, 0, 24);
        this.jawHorn1.func_78793_a(0.0f, -1.2f, -3.6f);
        this.jawHorn1.func_228302_a_(-0.5f, -3.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.jawHorn1, -0.1563815f, 0.0f, 0.0f);
        this.rightEar = new ModelRenderer((Model)this, 53, 4);
        this.rightEar.func_78793_a(-1.3f, -4.7f, 0.8f);
        this.rightEar.func_228302_a_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightEar, 0.2565634f, -0.16231562f, -0.2925172f);
        this.leftWing = new ModelRenderer((Model)this, 0, 40);
        this.leftWing.func_78793_a(1.5f, -6.0f, 3.0f);
        this.leftWing.func_228302_a_(0.0f, -5.0f, 0.0f, 6.0f, 6.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftWing, 0.35185838f, -0.50823987f, 0.11728612f);
        this.head = new ModelRenderer((Model)this, 41, 13);
        this.head.func_78793_a(0.0f, -3.5f, 1.0f);
        this.head.func_228302_a_(-2.5f, -5.0f, -4.0f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.head, (float)Math.PI / 90, 0.0f, 0.0f);
        this.leftEar = new ModelRenderer((Model)this, 53, 4);
        this.leftEar.func_78793_a(1.3f, -4.7f, 0.8f);
        this.leftEar.func_228302_a_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftEar, 0.2565634f, 0.16231562f, 0.2925172f);
        this.nose = new ModelRenderer((Model)this, 0, 54);
        this.nose.func_78793_a(0.0f, -2.2f, -4.6f);
        this.nose.func_228302_a_(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.headScales = new ModelRenderer((Model)this, 0, 40);
        this.headScales.func_78793_a(0.0f, -8.0f, -2.0f);
        this.headScales.func_228302_a_(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 6.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.headScales, (float)Math.PI / 90, 0.0f, 0.0f);
        this.leftHornBig1 = new ModelRenderer((Model)this, 0, 29);
        this.leftHornBig1.func_78793_a(1.0f, -4.8f, -1.0f);
        this.leftHornBig1.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftHornBig1, 0.0f, 0.0f, 0.312763f);
        this.leftHorn = new ModelRenderer((Model)this, 0, 2);
        this.leftHorn.func_78793_a(1.0f, -4.5f, -1.8f);
        this.leftHorn.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftHorn, 0.5403539f, 0.13508847f, 0.31520647f);
        this.egg = new ModelRenderer((Model)this, 0, 0);
        this.egg.func_78793_a(0.0f, 24.0f, 2.0f);
        this.egg.func_228302_a_(-7.0f, -9.0f, -4.5f, 14.0f, 9.0f, 9.0f, 0.0f, 0.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 0, 30);
        this.leftLeg.func_78793_a(2.0f, -1.5f, -2.0f);
        this.leftLeg.func_228302_a_(-1.5f, -1.5f, -7.0f, 3.0f, 3.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftLeg, 0.0f, -0.19547687f, 0.0f);
        this.rightHornBig1 = new ModelRenderer((Model)this, 0, 29);
        this.rightHornBig1.func_78793_a(-1.0f, -4.8f, -1.0f);
        this.rightHornBig1.func_228302_a_(-0.5f, -2.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightHornBig1, 0.0f, 0.0f, -0.312763f);
        this.head.func_78792_a(this.rightEye);
        this.rightHornBig1.func_78792_a(this.rightHornBig3);
        this.egg.func_78792_a(this.body);
        this.head.func_78792_a(this.lowerJaw);
        this.leftHornBig1.func_78792_a(this.leftHornBig2);
        this.leftHornBig1.func_78792_a(this.leftHornBig3);
        this.rightHornBig1.func_78792_a(this.rightHornBig2);
        this.head.func_78792_a(this.rightHorn);
        this.upperJaw.func_78792_a(this.tooth);
        this.head.func_78792_a(this.leftEye);
        this.head.func_78792_a(this.upperJaw);
        this.egg.func_78792_a(this.rightArm);
        this.egg.func_78792_a(this.leftArm);
        this.jawHorn1.func_78792_a(this.jawHorn2);
        this.body.func_78792_a(this.rightWing);
        this.body.func_78792_a(this.neck1);
        this.rightArm.func_78792_a(this.lollipop);
        this.egg.func_78792_a(this.rightLeg);
        this.upperJaw.func_78792_a(this.jawHorn1);
        this.head.func_78792_a(this.rightEar);
        this.body.func_78792_a(this.leftWing);
        this.neck1.func_78792_a(this.head);
        this.head.func_78792_a(this.leftEar);
        this.upperJaw.func_78792_a(this.nose);
        this.head.func_78792_a(this.headScales);
        this.head.func_78792_a(this.leftHornBig1);
        this.head.func_78792_a(this.leftHorn);
        this.egg.func_78792_a(this.leftLeg);
        this.head.func_78792_a(this.rightHornBig1);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.egg).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setupAnim(DevilFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.showModels(entityIn);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180) * 0.7f;
        this.head.field_78795_f = 0.03f + headPitch * ((float)Math.PI / 180) * 0.7f;
        this.egg.field_78796_g = 0.0f;
        this.egg.field_78808_h = 0.0f;
        if (ageInTicks % 300.0f < 60.0f) {
            float progress = ageInTicks % 300.0f % 60.0f;
            float armHeight = MathHelper.func_76126_a((float)(progress * (float)Math.PI / 60.0f)) * 0.4f;
            this.leftArm.field_78795_f = 0.35f - armHeight + MathHelper.func_76126_a((float)(progress * (float)Math.PI / 10.0f)) * 0.45f;
            this.rightArm.field_78795_f = 0.35f - armHeight + MathHelper.func_76126_a((float)(progress * (float)Math.PI / 10.0f + (float)Math.PI)) * 0.45f;
        } else {
            this.leftArm.field_78795_f = 0.35f;
            this.rightArm.field_78795_f = 0.35f;
        }
        if (entityIn.isPartying()) {
            this.egg.field_78796_g = ageInTicks / 4.0f;
            this.egg.field_78808_h = MathHelper.func_76134_b((float)(ageInTicks / 4.0f)) * this.toRads(10.0f);
            this.leftLeg.field_78795_f = this.toRads(30.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.4f;
            this.rightLeg.field_78795_f = this.toRads(30.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.4f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks / 4.0f)) * this.toRads(10.0f);
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks / 4.0f + (float)Math.PI)) * this.toRads(10.0f);
        } else if (entityIn.isSitting()) {
            this.leftLeg.field_78795_f = 0.0f;
            this.rightLeg.field_78795_f = 0.0f;
        } else {
            this.leftLeg.field_78795_f = this.toRads(30.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.4f;
            this.rightLeg.field_78795_f = this.toRads(30.0f) + MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.4f;
        }
    }

    public void prepareMobModel(DevilFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float animationHeight = entityIn.getAnimationHeight(partialTick);
        this.leftWing.field_78796_g = animationHeight * this.toRads(20.0f) - 0.43f;
        this.rightWing.field_78796_g = -animationHeight * this.toRads(20.0f) + 0.43f;
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            this.leftWing.field_78796_g = -0.43f;
            this.rightWing.field_78796_g = 0.43f;
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(DevilFamiliarEntity entityIn) {
        boolean hasNose = entityIn.hasNose();
        boolean hasEars = entityIn.hasEars();
        this.lollipop.field_78806_j = entityIn.hasLollipop();
        this.nose.field_78806_j = hasNose;
        this.jawHorn1.field_78806_j = !hasNose;
        this.leftEar.field_78806_j = hasEars;
        this.rightEar.field_78806_j = hasEars;
        this.leftHorn.field_78806_j = hasEars;
        this.rightHorn.field_78806_j = hasEars;
        this.leftHornBig1.field_78806_j = !hasEars;
        this.rightHornBig1.field_78806_j = !hasEars;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

