/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.CthulhuFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class CthulhuFamiliarModel
extends EntityModel<CthulhuFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelRenderer body;
    public ModelRenderer head;
    public ModelRenderer leftLeg;
    public ModelRenderer leftArm;
    public ModelRenderer tail;
    public ModelRenderer leftWing;
    public ModelRenderer rightLeg;
    public ModelRenderer rightArm;
    public ModelRenderer rightWing;
    public ModelRenderer hair;
    public ModelRenderer leftEye;
    public ModelRenderer rightEye;
    public ModelRenderer leftEar;
    public ModelRenderer tentacle1;
    public ModelRenderer tentacle2;
    public ModelRenderer tentacle3;
    public ModelRenderer rightEar;
    public ModelRenderer hat1;
    public ModelRenderer trunk1;
    public ModelRenderer hat2;
    public ModelRenderer trunk2;
    public ModelRenderer trunk3;
    public ModelRenderer lantern1;
    public ModelRenderer lantern2;
    public ModelRenderer lantern3;
    public DragonFamiliarModel.ColorModelRenderer lantern4;

    public CthulhuFamiliarModel() {
        super(RenderType::func_228644_e_);
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.leftEye = new ModelRenderer((Model)this, 26, 12);
        this.leftEye.func_78793_a(1.3f, -3.0f, -3.7f);
        this.leftEye.func_228302_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.tentacle3 = new ModelRenderer((Model)this, 0, 17);
        this.tentacle3.func_78793_a(0.1f, -1.1f, -2.8f);
        this.tentacle3.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tentacle3, -0.19338249f, 0.0f, -0.57595867f);
        this.rightEar = new ModelRenderer((Model)this, 0, 21);
        this.rightEar.field_78809_i = true;
        this.rightEar.func_78793_a(-3.0f, -4.5f, -1.0f);
        this.rightEar.func_228302_a_(-3.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 52, 0);
        this.leftArm.func_78793_a(3.2f, -4.5f, 0.0f);
        this.leftArm.func_228302_a_(0.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftArm, -1.6891296f, 0.0f, 0.0f);
        this.tail = new ModelRenderer((Model)this, 0, 22);
        this.tail.func_78793_a(0.0f, -2.0f, 1.0f);
        this.tail.func_228302_a_(0.0f, -1.0f, 0.0f, 0.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail, 0.628493f, 0.0f, 0.0f);
        this.leftEar = new ModelRenderer((Model)this, 0, 21);
        this.leftEar.func_78793_a(3.0f, -4.5f, -1.0f);
        this.leftEar.func_228302_a_(0.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.lantern1 = new ModelRenderer((Model)this, 58, 29);
        this.lantern1.func_78793_a(1.0f, 3.5f, -0.5f);
        this.lantern1.func_228302_a_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.lantern1, 1.2901473f, 0.0f, 0.0f);
        this.leftWing = new ModelRenderer((Model)this, 20, 21);
        this.leftWing.func_78793_a(2.4f, -5.0f, 1.4f);
        this.leftWing.func_228302_a_(0.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftWing, -0.1314233f, -0.42917648f, 0.5256932f);
        this.body = new ModelRenderer((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 17.0f, 0.0f);
        this.body.func_228302_a_(-3.5f, -6.0f, -1.5f, 7.0f, 7.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.body, 0.43912482f, 0.0f, 0.0f);
        this.hat1 = new ModelRenderer((Model)this, 20, 16);
        this.hat1.func_78793_a(2.5f, -5.5f, -3.0f);
        this.hat1.func_228302_a_(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.hat1, 0.27366763f, -0.039095376f, 0.23457225f);
        this.hair = new ModelRenderer((Model)this, 0, 0);
        this.hair.func_78793_a(0.0f, -2.0f, 0.0f);
        this.hair.func_228302_a_(0.0f, -7.0f, -3.2f, 0.0f, 7.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        this.hat2 = new ModelRenderer((Model)this, 36, 16);
        this.hat2.func_78793_a(0.5f, -2.0f, 0.5f);
        this.hat2.func_228302_a_(-2.0f, 0.0f, -2.0f, 3.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.trunk3 = new ModelRenderer((Model)this, 54, 7);
        this.trunk3.func_78793_a(0.0f, 1.5f, 0.0f);
        this.trunk3.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.trunk3, 0.39095375f, 0.0f, 0.0f);
        this.lantern2 = new ModelRenderer((Model)this, 42, 23);
        this.lantern2.func_78793_a(0.0f, 2.5f, 0.0f);
        this.lantern2.func_228302_a_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.lantern2, 0.0f, 0.7853982f, 0.0f);
        this.tentacle2 = new ModelRenderer((Model)this, 0, 17);
        this.tentacle2.func_78793_a(0.0f, -1.4f, -2.8f);
        this.tentacle2.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tentacle2, -0.19338249f, 0.0f, 0.0f);
        this.rightArm = new ModelRenderer((Model)this, 52, 0);
        this.rightArm.field_78809_i = true;
        this.rightArm.func_78793_a(-3.2f, -4.5f, 0.0f);
        this.rightArm.func_228302_a_(-2.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightArm, -0.43807766f, 0.0f, 0.0f);
        this.tentacle1 = new ModelRenderer((Model)this, 0, 17);
        this.tentacle1.func_78793_a(-0.1f, -1.1f, -2.8f);
        this.tentacle1.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tentacle1, -0.19338249f, 0.0f, 0.57595867f);
        this.head = new ModelRenderer((Model)this, 20, 0);
        this.head.func_78793_a(0.0f, -5.8f, -0.3f);
        this.head.func_228302_a_(-3.0f, -5.0f, -3.2f, 6.0f, 5.0f, 6.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.head, -0.2628466f, 0.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 44, 0);
        this.leftLeg.func_78793_a(2.0f, 0.5f, 0.0f);
        this.leftLeg.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.leftLeg, -0.39426988f, 0.0f, 0.0f);
        this.lantern4 = new DragonFamiliarModel.ColorModelRenderer((Model)this, 36, 26);
        this.lantern4.func_78793_a(0.0f, -3.3f, 0.0f);
        this.lantern4.func_228302_a_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.lantern4, 0.0f, 0.0f, 0.7853982f);
        this.trunk2 = new ModelRenderer((Model)this, 44, 11);
        this.trunk2.func_78793_a(0.0f, 1.5f, 0.0f);
        this.trunk2.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.trunk2, -0.4691445f, 0.0f, 0.0f);
        this.rightWing = new ModelRenderer((Model)this, 20, 21);
        this.rightWing.field_78809_i = true;
        this.rightWing.func_78793_a(-2.4f, -5.0f, 1.4f);
        this.rightWing.func_228302_a_(-8.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightWing, -0.1314233f, 0.42917648f, -0.5256932f);
        this.rightEye = new ModelRenderer((Model)this, 26, 12);
        this.rightEye.func_78793_a(-1.3f, -3.0f, -3.7f);
        this.rightEye.func_228302_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 44, 0);
        this.rightLeg.field_78809_i = true;
        this.rightLeg.func_78793_a(-2.0f, 0.5f, 0.0f);
        this.rightLeg.func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.rightLeg, -0.39426988f, 0.0f, 0.0f);
        this.trunk1 = new ModelRenderer((Model)this, 44, 7);
        this.trunk1.func_78793_a(0.0f, -1.1f, -2.2f);
        this.trunk1.func_228302_a_(-1.5f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.trunk1, -0.86009824f, 0.0f, 0.0f);
        this.lantern3 = new ModelRenderer((Model)this, 34, 27);
        this.lantern3.func_78793_a(0.0f, 4.99f, 0.0f);
        this.lantern3.func_228302_a_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.lantern3, 0.0f, -0.7853982f, 0.0f);
        this.head.func_78792_a(this.leftEye);
        this.head.func_78792_a(this.tentacle3);
        this.head.func_78792_a(this.rightEar);
        this.body.func_78792_a(this.leftArm);
        this.body.func_78792_a(this.tail);
        this.head.func_78792_a(this.leftEar);
        this.leftArm.func_78792_a(this.lantern1);
        this.body.func_78792_a(this.leftWing);
        this.head.func_78792_a(this.hat1);
        this.head.func_78792_a(this.hair);
        this.hat1.func_78792_a(this.hat2);
        this.trunk2.func_78792_a(this.trunk3);
        this.lantern1.func_78792_a(this.lantern2);
        this.head.func_78792_a(this.tentacle2);
        this.body.func_78792_a(this.rightArm);
        this.head.func_78792_a(this.tentacle1);
        this.body.func_78792_a(this.head);
        this.body.func_78792_a(this.leftLeg);
        this.lantern3.func_78792_a((ModelRenderer)this.lantern4);
        this.trunk1.func_78792_a(this.trunk2);
        this.body.func_78792_a(this.rightWing);
        this.head.func_78792_a(this.rightEye);
        this.body.func_78792_a(this.rightLeg);
        this.head.func_78792_a(this.trunk1);
        this.lantern2.func_78792_a(this.lantern3);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setupAnim(CthulhuFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        entityIn.riderLimbSwing = limbSwing;
        entityIn.riderLimbSwingAmount = limbSwingAmount;
        this.showModels(entityIn);
        this.lantern4.setColor(1.0f, 1.0f, 1.0f, (MathHelper.func_76134_b((float)(ageInTicks * 0.2f)) + 1.0f) * 0.5f);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180) * 0.7f;
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180) * 0.7f - 0.26f;
        this.lantern1.field_78796_g = 0.0f;
        this.lantern1.field_78808_h = 0.0f;
        if (entityIn.isPartying()) {
            this.body.field_78795_f = -this.toRads(90.0f);
            this.rightLeg.field_78795_f = this.toRads(15.0f);
            this.leftLeg.field_78795_f = this.toRads(15.0f);
            this.head.field_78796_g = 0.0f;
            this.head.field_78795_f = 0.0f;
        } else if (entityIn.isSitting()) {
            this.rightArm.field_78795_f = 0.0f;
            this.leftArm.field_78795_f = 0.0f;
            this.rightLeg.field_78795_f = -1.5707964f;
            this.leftLeg.field_78795_f = -1.5707964f;
            this.body.field_78795_f = 0.0f;
        } else {
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f - 0.44f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f - 0.44f;
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount * 0.2f - 0.39f;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount * 0.2f - 0.39f;
            float f = this.body.field_78795_f = entityIn.func_70090_H() ? 1.0f : 0.44f;
        }
        if (entityIn.isAngry()) {
            this.leftEye.field_78808_h = -this.toRads(45.0f);
            this.rightEye.field_78808_h = -this.toRads(45.0f);
            this.leftEar.field_78808_h = this.toRads(20.0f);
            this.rightEar.field_78808_h = -this.toRads(20.0f);
        } else {
            this.leftEye.field_78808_h = 0.0f;
            this.rightEye.field_78808_h = 0.0f;
            this.leftEar.field_78808_h = 0.0f;
            this.rightEar.field_78808_h = 0.0f;
        }
        if (entityIn.isGiving()) {
            this.leftArm.field_78796_g = this.toRads(40.0f);
            this.rightArm.field_78796_g = -this.toRads(40.0f);
            this.leftArm.field_78795_f -= this.toRads(40.0f);
            this.rightArm.field_78795_f -= this.toRads(40.0f);
        } else {
            this.leftArm.field_78796_g = 0.0f;
            this.rightArm.field_78796_g = 0.0f;
        }
        this.trunk1.field_78795_f = -0.86f + MathHelper.func_76134_b((float)(ageInTicks / 10.0f)) * 0.15f;
        this.trunk2.field_78795_f = -0.47f + MathHelper.func_76134_b((float)(ageInTicks / 10.0f)) * 0.15f;
        this.trunk3.field_78795_f = 0.39f + MathHelper.func_76134_b((float)(ageInTicks / 10.0f)) * 0.15f;
        this.tentacle1.field_78808_h = 0.58f + MathHelper.func_76134_b((float)(ageInTicks / 10.0f)) * 0.07f;
        this.tentacle3.field_78808_h = -0.58f - MathHelper.func_76134_b((float)(ageInTicks / 10.0f)) * 0.07f;
        if (entityIn.hasBlacksmithUpgrade()) {
            if (entityIn.isSitting()) {
                this.lantern1.field_78795_f = this.toRads(0.0f);
                this.lantern1.field_78797_d = -1.6f;
                this.lantern1.field_78800_c = 3.0f;
                this.lantern1.field_78798_e = -5.0f;
            } else {
                this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.4f + (float)Math.PI)) * limbSwingAmount * 0.2f + this.toRads(-100.0f);
                this.lantern1.field_78796_g = MathHelper.func_76134_b((float)(ageInTicks * 0.2f)) * this.toRads(5.0f);
                this.lantern1.field_78808_h = -MathHelper.func_76134_b((float)(ageInTicks * 0.2f)) * this.toRads(5.0f);
                this.lantern1.field_78795_f = this.toRads(74.0f);
                this.lantern1.field_78797_d = 3.5f;
                this.lantern1.field_78800_c = 1.0f;
                this.lantern1.field_78798_e = -0.5f;
            }
        }
        if (entityIn.func_184207_aI()) {
            float animHeight = entityIn.getAnimationHeight(partialTicks);
            this.rightArm.field_78795_f = this.toRads(40.0f - animHeight * 15.0f);
        }
    }

    public void prepareMobModel(CthulhuFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            this.leftWing.field_78796_g = -0.43f;
            this.rightWing.field_78796_g = 0.43f;
        } else {
            float animationHeight = entityIn.getAnimationHeight(partialTick);
            this.leftWing.field_78796_g = animationHeight * this.toRads(20.0f) - 0.43f;
            this.rightWing.field_78796_g = -animationHeight * this.toRads(20.0f) + 0.43f;
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(CthulhuFamiliarEntity entity) {
        boolean hasTrunk = entity.hasTrunk();
        this.hat1.field_78806_j = entity.hasHat();
        this.lantern1.field_78806_j = entity.hasBlacksmithUpgrade();
        this.trunk1.field_78806_j = hasTrunk;
        this.tentacle1.field_78806_j = !hasTrunk;
        this.tentacle2.field_78806_j = !hasTrunk;
        this.tentacle3.field_78806_j = !hasTrunk;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

