/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.spirit;

import com.github.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.github.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.util.TextUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class SpiritGui<T extends SpiritContainer>
extends ContainerScreen<T> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("occultism", "textures/gui/inventory_spirit.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.spirit";
    protected SpiritEntity spirit;
    protected T container;

    public SpiritGui(T container, PlayerInventory playerInventory, ITextComponent titleIn) {
        super(container, playerInventory, titleIn);
        this.container = container;
        this.spirit = ((SpiritContainer)((Object)this.container)).spirit;
        this.field_146999_f = 175;
        this.field_147000_g = 165;
    }

    public static void drawEntityToGui(int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    public void func_231160_c_() {
        String jobID;
        super.func_231160_c_();
        this.field_230710_m_.clear();
        int labelHeight = 9;
        LabelWidget nameLabel = new LabelWidget(this.field_147003_i + 65, this.field_147009_r + 17, false, -1, 2, 0x404040);
        nameLabel.addLine(TextUtil.formatDemonName(this.spirit.func_200200_C_().getString()));
        this.func_230480_a_(nameLabel);
        if (this.spirit.getSpiritMaxAge() >= 0) {
            int agePercent = (int)Math.floor((float)this.spirit.getSpiritAge() / (float)this.spirit.getSpiritMaxAge() * 100.0f);
            LabelWidget ageLabel = new LabelWidget(this.field_147003_i + 65, this.field_147009_r + 17 + labelHeight + 5, false, -1, 2, 0x404040);
            ageLabel.addLine(I18n.func_135052_a((String)"gui.occultism.spirit.age", (Object[])new Object[]{agePercent}));
            this.func_230480_a_(ageLabel);
        }
        if (!StringUtils.isBlank((CharSequence)(jobID = this.spirit.getJobID()))) {
            String[] lines;
            jobID = jobID.replace(":", ".");
            LabelWidget jobLabel = new LabelWidget(this.field_147003_i + 65, this.field_147009_r + 17 + labelHeight + 5 + labelHeight + 5 + 5, false, -1, 2, 0x404040);
            String jobText = I18n.func_135052_a((String)"gui.occultism.spirit.job", (Object[])new Object[]{I18n.func_135052_a((String)("job." + jobID), (Object[])new Object[0])});
            for (String line : lines = WordUtils.wrap((String)jobText, (int)15, (String)"\n", (boolean)true).split("[\\r\\n]+", 2)) {
                jobLabel.addLine(TextFormatting.ITALIC + line + TextFormatting.RESET);
            }
            this.func_230480_a_(jobLabel);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderSystem.pushMatrix();
        int scale = 30;
        SpiritGui.drawEntityToGui(this.field_147003_i + 35, this.field_147009_r + 65, scale, this.field_147003_i + 51 - x, this.field_147009_r + 75 - 50 - y, (LivingEntity)this.spirit);
        RenderSystem.popMatrix();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }
}

