/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.projects.oneplayersleeping.mixin;

import be.nevoka.projects.oneplayersleeping.config.OPSConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerWorld.class})
public abstract class MixinOnePlayerSleeping {
    @Shadow
    private boolean field_73068_P;

    @Shadow
    @Nonnull
    public abstract MinecraftServer func_73046_m();

    @Shadow
    public abstract List<ServerPlayerEntity> func_217369_A();

    @Shadow
    protected abstract void func_229856_ab_();

    @Inject(method={"updateAllPlayersSleepingFlag"}, cancellable=true, at={@At(value="HEAD")})
    private void updateAllPlayersSleepingFlag(CallbackInfo ci) {
        if (((Boolean)OPSConfig.Common.onePlayerSleeping.get()).booleanValue()) {
            this.field_73068_P = false;
            this.func_217369_A().stream().filter(LivingEntity::func_70608_bn).collect(Collectors.toList()).forEach(player -> {
                this.sendMessageToAllPlayers((IFormattableTextComponent)new TranslationTextComponent("oneplayersleeping.sleeper", new Object[]{player.func_145748_c_()}));
                this.field_73068_P = true;
                ci.cancel();
            });
            ci.cancel();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;noneMatch(Ljava/util/function/Predicate;)Z"))
    private boolean noneMatchSleep(Stream<ServerPlayerEntity> stream, Predicate<ServerPlayerEntity> predicate) {
        if (((Boolean)OPSConfig.Common.onePlayerSleeping.get()).booleanValue()) {
            return stream.anyMatch(player -> !player.func_175149_v() && player.func_71026_bH());
        }
        return stream.noneMatch(predicate);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;wakeUpAllPlayers()V"))
    private void wakeUpAllPlayers(ServerWorld serverWorld) {
        this.sendMessageToAllPlayers((IFormattableTextComponent)new TranslationTextComponent("oneplayersleeping.morning"));
        this.func_229856_ab_();
    }

    private void sendMessageToAllPlayers(IFormattableTextComponent textComponent) {
        IFormattableTextComponent message = textComponent.func_240699_a_(TextFormatting.YELLOW);
        this.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)message, ChatType.SYSTEM, Util.field_240973_b_);
    }
}

