/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaInfusionProvider
extends RecipeProvider {
    public ManaInfusionProvider(DataGenerator gen) {
        super(gen);
    }

    public String func_200397_b() {
        return "Botania mana pool recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(this.id("manasteel"), new ItemStack((IItemProvider)ModItems.manaSteel), Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_IRON), 3000));
        consumer.accept(new FinishedRecipe(this.id("manasteel_block"), new ItemStack((IItemProvider)ModBlocks.manasteelBlock), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150339_S), 27000));
        consumer.accept(new FinishedRecipe(this.id("mana_pearl"), new ItemStack((IItemProvider)ModItems.manaPearl), ManaInfusionProvider.ingr((IItemProvider)Items.field_151079_bi), 6000));
        consumer.accept(new FinishedRecipe(this.id("mana_diamond"), new ItemStack((IItemProvider)ModItems.manaDiamond), Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND), 10000));
        consumer.accept(new FinishedRecipe(this.id("mana_diamond_block"), new ItemStack((IItemProvider)ModBlocks.manaDiamondBlock), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150484_ah), 90000));
        Ingredient dust = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H, Items.field_151137_ax, Items.field_151114_aO, Items.field_151102_aT});
        consumer.accept(new FinishedRecipe(this.id("mana_powder_dust"), new ItemStack((IItemProvider)ModItems.manaPowder), dust, 500));
        Ingredient dyeIngredient = Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])Arrays.stream(DyeColor.values()).map(DyeItem::func_195961_a).toArray(Item[]::new)));
        consumer.accept(new FinishedRecipe(this.id("mana_powder_dye"), new ItemStack((IItemProvider)ModItems.manaPowder), dyeIngredient, 400));
        consumer.accept(new FinishedRecipe(this.id("piston_relay"), new ItemStack((IItemProvider)ModBlocks.pistonRelay), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150331_J), 15000));
        consumer.accept(new FinishedRecipe(this.id("mana_cookie"), new ItemStack((IItemProvider)ModItems.manaCookie), ManaInfusionProvider.ingr((IItemProvider)Items.field_151106_aX), 20000));
        consumer.accept(new FinishedRecipe(this.id("grass_seeds"), new ItemStack((IItemProvider)ModItems.grassSeeds), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150349_c), 2500));
        consumer.accept(new FinishedRecipe(this.id("podzol_seeds"), new ItemStack((IItemProvider)ModItems.podzolSeeds), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196555_aI), 2500));
        consumer.accept(new FinishedRecipe(this.id("mycel_seeds"), new ItemStack((IItemProvider)ModItems.mycelSeeds), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150337_Q, Blocks.field_150338_P}), 6500));
        consumer.accept(new FinishedRecipe(this.id("mana_quartz"), new ItemStack((IItemProvider)ModItems.manaQuartz), ManaInfusionProvider.ingr((IItemProvider)Items.field_151128_bU), 250));
        consumer.accept(new FinishedRecipe(this.id("tiny_potato"), new ItemStack((IItemProvider)ModBlocks.tinyPotato), ManaInfusionProvider.ingr((IItemProvider)Items.field_151174_bG), 1337));
        consumer.accept(new FinishedRecipe(this.id("mana_glass"), new ItemStack((IItemProvider)ModBlocks.manaGlass), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150359_w), 150));
        consumer.accept(new FinishedRecipe(this.id("mana_string"), new ItemStack((IItemProvider)ModItems.manaString), ManaInfusionProvider.ingr((IItemProvider)Items.field_151007_F), 5000));
        consumer.accept(new FinishedRecipe(this.id("mana_bottle"), new ItemStack((IItemProvider)ModItems.manaBottle), ManaInfusionProvider.ingr((IItemProvider)Items.field_151069_bo), 5000));
        consumer.accept(FinishedRecipe.alchemy(this.id("rotten_flesh_to_leather"), new ItemStack((IItemProvider)Items.field_151116_aA), ManaInfusionProvider.ingr((IItemProvider)Items.field_151078_bh), 600));
        this.cycle(consumer, 40, "botania:log_cycle", new IItemProvider[]{Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_196619_M, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P});
        this.cycle(consumer, 120, "botania:sapling_cycle", new IItemProvider[]{Blocks.field_196674_t, Blocks.field_196675_u, Blocks.field_196676_v, Blocks.field_196678_w, Blocks.field_196679_x, Blocks.field_196680_y});
        consumer.accept(FinishedRecipe.alchemy(this.id("glowstone_deconstruct"), new ItemStack((IItemProvider)Items.field_151114_aO, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150426_aN), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("quartz_deconstruct"), new ItemStack((IItemProvider)Items.field_151128_bU, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150371_ca), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("dark_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.darkQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.darkQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("mana_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.manaQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.manaQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("blaze_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.blazeQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.blazeQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("lavender_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.lavenderQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.lavenderQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("red_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.redQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.redQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("elf_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.elfQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.elfQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("chiseled_stone_bricks"), new ItemStack((IItemProvider)Blocks.field_196702_dl, 1), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196696_di), 150));
        consumer.accept(FinishedRecipe.alchemy(this.id("ice"), new ItemStack((IItemProvider)Blocks.field_150432_aD), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196604_cC), 2250));
        consumer.accept(FinishedRecipe.alchemy(this.id("vine_to_lily_pad"), new ItemStack((IItemProvider)Blocks.field_196651_dG), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150395_bd), 320));
        consumer.accept(FinishedRecipe.alchemy(this.id("lily_pad_to_vine"), new ItemStack((IItemProvider)Blocks.field_150395_bd), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196651_dG), 320));
        this.cycle(consumer, 200, "botania:fish_cycle", new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY, Items.field_196089_aZ});
        this.cycle(consumer, 6000, "botania:crop_cycle", new IItemProvider[]{Items.field_196130_bo, Items.field_151014_N, Items.field_151174_bG, Items.field_151172_bF, Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb});
        consumer.accept(FinishedRecipe.alchemy(this.id("potato_unpoison"), new ItemStack((IItemProvider)Items.field_151174_bG), ManaInfusionProvider.ingr((IItemProvider)Items.field_151170_bI), 1200));
        consumer.accept(FinishedRecipe.alchemy(this.id("blaze_rod_to_nether_wart"), new ItemStack((IItemProvider)Items.field_151075_bm), ManaInfusionProvider.ingr((IItemProvider)Items.field_151072_bj), 4000));
        this.cycle(consumer, 200, "", new IItemProvider[]{Items.field_151016_H, Items.field_151145_ak});
        consumer.accept(FinishedRecipe.alchemy(this.id("book_to_name_tag"), new ItemStack((IItemProvider)Items.field_151057_cb), ManaInfusionProvider.ingr((IItemProvider)Items.field_151099_bA), 6000));
        consumer.accept(FinishedRecipe.alchemy(this.id("wool_deconstruct"), new ItemStack((IItemProvider)Items.field_151007_F, 3), Ingredient.func_199805_a((ITag)ItemTags.field_199904_a), 100));
        consumer.accept(FinishedRecipe.alchemy(this.id("cactus_to_slime"), new ItemStack((IItemProvider)Items.field_151123_aH), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150434_aF), 1200));
        consumer.accept(FinishedRecipe.alchemy(this.id("slime_to_cactus"), new ItemStack((IItemProvider)Blocks.field_150434_aF), ManaInfusionProvider.ingr((IItemProvider)Items.field_151123_aH), 1200));
        consumer.accept(FinishedRecipe.alchemy(this.id("ender_pearl_from_ghast_tear"), new ItemStack((IItemProvider)Items.field_151079_bi), ManaInfusionProvider.ingr((IItemProvider)Items.field_151073_bk), 28000));
        this.cycle(consumer, 300, "", new IItemProvider[]{Items.field_151114_aO, Items.field_151137_ax});
        consumer.accept(FinishedRecipe.alchemy(this.id("cobble_to_sand"), new ItemStack((IItemProvider)Blocks.field_150354_m), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150347_e), 50));
        consumer.accept(FinishedRecipe.alchemy(this.id("terracotta_to_red_sand"), new ItemStack((IItemProvider)Blocks.field_196611_F), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150405_ch), 50));
        consumer.accept(FinishedRecipe.alchemy(this.id("clay_deconstruct"), new ItemStack((IItemProvider)Items.field_151119_aD, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150435_aG), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("brick_deconstruct"), new ItemStack((IItemProvider)Items.field_151118_aC, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196584_bK), 25));
        consumer.accept(FinishedRecipe.alchemy(this.id("coarse_dirt"), new ItemStack((IItemProvider)Blocks.field_196660_k), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150346_d), 120));
        consumer.accept(FinishedRecipe.alchemy(this.id("stone_to_andesite"), new ItemStack((IItemProvider)Blocks.field_196656_g), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150348_b), 200));
        consumer.accept(FinishedRecipe.alchemy(this.id("andesite_to_diorite"), new ItemStack((IItemProvider)Blocks.field_196654_e), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196656_g), 200));
        consumer.accept(FinishedRecipe.alchemy(this.id("diorite_to_granite"), new ItemStack((IItemProvider)Blocks.field_196650_c), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196654_e), 200));
        consumer.accept(FinishedRecipe.alchemy(this.id("granite_to_andesite"), new ItemStack((IItemProvider)Blocks.field_196656_g), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196650_c), 200));
        this.cycle(consumer, 500, "botania:shrub_cycle", new IItemProvider[]{Blocks.field_196554_aH, Blocks.field_196555_aI, Blocks.field_150349_c});
        this.cycle(consumer, 400, "botania:flower_cycle", new IItemProvider[]{Blocks.field_196605_bc, Blocks.field_196606_bd, Blocks.field_196607_be, Blocks.field_196609_bf, Blocks.field_196610_bg, Blocks.field_196612_bh, Blocks.field_196613_bi, Blocks.field_196614_bj, Blocks.field_196615_bk, Blocks.field_196616_bl, Blocks.field_222387_by, Blocks.field_222383_bA, Blocks.field_196800_gd, Blocks.field_196801_ge, Blocks.field_196802_gf, Blocks.field_196803_gg});
        consumer.accept(FinishedRecipe.alchemy(this.id("chorus_fruit_to_flower"), new ItemStack((IItemProvider)Blocks.field_185766_cS), ManaInfusionProvider.ingr((IItemProvider)Items.field_185162_cT), 10000));
        this.cycle(consumer, 240, "botania:berry_cycle", new IItemProvider[]{Items.field_151034_e, Items.field_222112_pR});
        consumer.accept(this.mini((IItemProvider)ModSubtiles.agricarnationChibi, (IItemProvider)ModSubtiles.agricarnation));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.clayconiaChibi, (IItemProvider)ModSubtiles.clayconia));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.bellethornChibi, (IItemProvider)ModSubtiles.bellethorn));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.bubbellChibi, (IItemProvider)ModSubtiles.bubbell));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.hopperhockChibi, (IItemProvider)ModSubtiles.hopperhock));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.jiyuuliaChibi, (IItemProvider)ModSubtiles.jiyuulia));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.tangleberrieChibi, (IItemProvider)ModSubtiles.tangleberrie));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.marimorphosisChibi, (IItemProvider)ModSubtiles.marimorphosis));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.rannuncarpusChibi, (IItemProvider)ModSubtiles.rannuncarpus));
        consumer.accept(this.mini((IItemProvider)ModSubtiles.solegnoliaChibi, (IItemProvider)ModSubtiles.solegnolia));
        consumer.accept(FinishedRecipe.alchemy(this.id("hydroangeas_motif"), new ItemStack((IItemProvider)ModBlocks.motifHydroangeas), ManaInfusionProvider.ingr((IItemProvider)ModSubtiles.hydroangeas), 2500));
        consumer.accept(FinishedRecipe.conjuration(this.id("redstone_dupe"), new ItemStack((IItemProvider)Items.field_151137_ax, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151137_ax), 5000));
        consumer.accept(FinishedRecipe.conjuration(this.id("glowstone_dupe"), new ItemStack((IItemProvider)Items.field_151114_aO, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151114_aO), 5000));
        consumer.accept(FinishedRecipe.conjuration(this.id("quartz_dupe"), new ItemStack((IItemProvider)Items.field_151128_bU, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151128_bU), 2500));
        consumer.accept(FinishedRecipe.conjuration(this.id("coal_dupe"), new ItemStack((IItemProvider)Items.field_151044_h, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151044_h), 2100));
        consumer.accept(FinishedRecipe.conjuration(this.id("snowball_dupe"), new ItemStack((IItemProvider)Items.field_151126_ay, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151126_ay), 200));
        consumer.accept(FinishedRecipe.conjuration(this.id("netherrack_dupe"), new ItemStack((IItemProvider)Blocks.field_150424_aL, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150424_aL), 200));
        consumer.accept(FinishedRecipe.conjuration(this.id("soul_sand_dupe"), new ItemStack((IItemProvider)Blocks.field_150425_aM, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150425_aM), 1500));
        consumer.accept(FinishedRecipe.conjuration(this.id("gravel_dupe"), new ItemStack((IItemProvider)Blocks.field_150351_n, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150351_n), 720));
        consumer.accept(FinishedRecipe.conjuration(this.id("oak_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196642_W, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196642_W), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("birch_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196647_Y, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196647_Y), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("spruce_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196645_X, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196645_X), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("jungle_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196648_Z, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196648_Z), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("acacia_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196572_aa, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196572_aa), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("dark_oak_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196574_ab, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196574_ab), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("grass"), new ItemStack((IItemProvider)Blocks.field_150349_c, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150349_c), 800));
    }

    protected void cycle(Consumer<IFinishedRecipe> consumer, int cost, String group, IItemProvider ... items) {
        for (int i = 0; i < items.length; ++i) {
            Ingredient in = ManaInfusionProvider.ingr(items[i]);
            ItemStack out = new ItemStack(i == items.length - 1 ? items[0] : items[i + 1]);
            String id = String.format("%s_to_%s", Registry.field_212630_s.func_177774_c((Object)items[i].func_199767_j()).func_110623_a(), Registry.field_212630_s.func_177774_c((Object)out.func_77973_b()).func_110623_a());
            consumer.accept(FinishedRecipe.alchemy(this.id(id), out, in, cost, group));
        }
    }

    protected FinishedRecipe mini(IItemProvider mini, IItemProvider full) {
        return FinishedRecipe.alchemy(this.id(Registry.field_212630_s.func_177774_c((Object)mini.func_199767_j()).func_110623_a()), new ItemStack(mini), ManaInfusionProvider.ingr(full), 2500, "botania:flower_shrinking");
    }

    protected ResourceLocation id(String s) {
        return ResourceLocationHelper.prefix("mana_infusion/" + s);
    }

    protected static Ingredient ingr(IItemProvider i) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{i});
    }

    protected static class FinishedRecipe
    implements IFinishedRecipe {
        private static final StateIngredient CONJURATION = StateIngredientHelper.of(ModBlocks.conjurationCatalyst);
        private static final StateIngredient ALCHEMY = StateIngredientHelper.of(ModBlocks.alchemyCatalyst);
        private final ResourceLocation id;
        private final Ingredient input;
        private final ItemStack output;
        private final int mana;
        private final String group;
        @Nullable
        private final StateIngredient catalyst;

        public static FinishedRecipe conjuration(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return new FinishedRecipe(id, output, input, mana, "", CONJURATION);
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return FinishedRecipe.alchemy(id, output, input, mana, "");
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            return new FinishedRecipe(id, output, input, mana, group, ALCHEMY);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            this(id, output, input, mana, "");
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            this(id, output, input, mana, group, null);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group, @Nullable StateIngredient catalyst) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.mana = mana;
            this.group = group;
            this.catalyst = catalyst;
        }

        public void func_218610_a(JsonObject json) {
            json.add("input", this.input.func_200304_c());
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            json.addProperty("mana", (Number)this.mana);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.catalyst != null) {
                json.add("catalyst", (JsonElement)this.catalyst.serialize());
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

