/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.world.MysticalFlowerConfig;
import vazkii.botania.common.world.MysticalFlowerFeature;
import vazkii.botania.common.world.MysticalMushroomConfig;
import vazkii.botania.common.world.MysticalMushroomFeature;
import vazkii.botania.common.world.WorldTypeSkyblock;

public class ModFeatures {
    public static final Feature<MysticalFlowerConfig> MYSTICAL_FLOWERS = new MysticalFlowerFeature();
    public static final Feature<MysticalMushroomConfig> MYSTICAL_MUSHROOMS = new MysticalMushroomFeature();
    public static final ConfiguredFeature<?, ?> MYSTICAL_FLOWERS_CONF = MYSTICAL_FLOWERS.func_225566_b_((IFeatureConfig)new MysticalFlowerConfig(6, 2, 2, 16, 0.05)).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
    public static final ConfiguredFeature<?, ?> MYSTICAL_MUSHROOMS_CONF = MYSTICAL_MUSHROOMS.func_225566_b_((IFeatureConfig)new MysticalMushroomConfig(40)).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));
    public static final Set<Biome.Category> TYPE_BLACKLIST = ImmutableSet.of((Object)Biome.Category.NETHER, (Object)Biome.Category.THEEND, (Object)Biome.Category.ICY, (Object)Biome.Category.MUSHROOM);

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ModBlocks.register(r, "mystical_flowers", MYSTICAL_FLOWERS);
        ModBlocks.register(r, "mystical_mushrooms", MYSTICAL_MUSHROOMS);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ResourceLocationHelper.prefix("mystical_flowers"), MYSTICAL_FLOWERS_CONF);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ResourceLocationHelper.prefix("mystical_mushrooms"), MYSTICAL_MUSHROOMS_CONF);
    }

    public static void registerWorldType(RegistryEvent.Register<ForgeWorldType> event) {
        if (Botania.gardenOfGlassLoaded) {
            ModBlocks.register(event.getRegistry(), ResourceLocationHelper.prefix("gardenofglass"), WorldTypeSkyblock.INSTANCE);
        }
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (!((Boolean)ConfigHandler.COMMON.worldgenEnabled.get()).booleanValue()) {
            return;
        }
        Biome.Category category = event.getCategory();
        if (!TYPE_BLACKLIST.contains(category)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, MYSTICAL_FLOWERS_CONF);
        }
        if (category != Biome.Category.THEEND) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, MYSTICAL_MUSHROOMS_CONF);
        }
    }
}

