/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ServerRecipePlacer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.DistExecutor;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.crafting.ContainerCraftingHalo;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class ItemCraftingHalo
extends Item {
    private static final ResourceLocation glowTexture = new ResourceLocation("botania:textures/misc/glow0.png");
    private static final ItemStack craftingTable = new ItemStack((IItemProvider)Blocks.field_150462_ai);
    public static final int SEGMENTS = 12;
    private static final String TAG_LAST_CRAFTING = "lastCrafting";
    private static final String TAG_STORED_RECIPE_PREFIX = "storedRecipe";
    private static final String TAG_EQUIPPED = "equipped";
    private static final String TAG_ROTATION_BASE = "rotationBase";

    public ItemCraftingHalo(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onItemCrafted);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(this::onRenderWorldLast));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int segment = ItemCraftingHalo.getSegmentLookedAt(stack, (LivingEntity)player);
            IRecipe<CraftingInventory> recipe = ItemCraftingHalo.getSavedRecipe(world, stack, segment);
            if (segment == 0) {
                IWorldPosCallable wp = IWorldPosCallable.func_221488_a((World)world, (BlockPos)BlockPos.field_177992_a);
                player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInv, p) -> new ContainerCraftingHalo(windowId, playerInv, wp), stack.func_200301_q()));
            } else if (recipe == null) {
                IRecipe<CraftingInventory> lastRecipe = ItemCraftingHalo.getLastRecipe(world, stack);
                if (lastRecipe != null) {
                    ItemCraftingHalo.saveRecipe(stack, lastRecipe.func_199560_c(), segment);
                }
            } else {
                this.tryCraft(player, stack, segment, true);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int pos, boolean equipped) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        boolean eqLastTick = ItemCraftingHalo.wasEquipped(stack);
        if (!equipped && living.func_184592_cb() == stack) {
            equipped = true;
        }
        if (eqLastTick != equipped) {
            ItemCraftingHalo.setEquipped(stack, equipped);
        }
        if (!equipped) {
            int angles = 360;
            int segAngles = angles / 12;
            float shift = (float)segAngles / 2.0f;
            ItemCraftingHalo.setRotationBase(stack, ItemCraftingHalo.getCheckingAngle((LivingEntity)entity) - shift);
        }
    }

    private static boolean hasRoomFor(PlayerInventory inv, ItemStack stack) {
        PlayerInventory dummy = new PlayerInventory(inv.field_70458_d);
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            dummy.field_70462_a.set(i, (Object)((ItemStack)inv.field_70462_a.get(i)).func_77946_l());
        }
        return dummy.func_70441_a(stack.func_77946_l());
    }

    private static boolean canCraftHeuristic(PlayerEntity player, IRecipe<CraftingInventory> recipe) {
        RecipeItemHelper accounter = new RecipeItemHelper();
        player.field_71071_by.func_201571_a(accounter);
        return accounter.func_194116_a(recipe, null);
    }

    void tryCraft(PlayerEntity player, ItemStack halo, int slot, boolean particles) {
        IRecipe<CraftingInventory> recipe = ItemCraftingHalo.getSavedRecipe(player.field_70170_p, halo, slot);
        if (recipe == null) {
            return;
        }
        WorkbenchContainer dummy = new WorkbenchContainer(-999, player.field_71071_by);
        CraftingInventory craftInv = (CraftingInventory)dummy.func_75139_a((int)1).field_75224_c;
        RecipePlacer placer = new RecipePlacer((RecipeBookContainer<CraftingInventory>)dummy);
        if (!placer.place((ServerPlayerEntity)player, recipe)) {
            return;
        }
        if (!recipe.func_77569_a((IInventory)craftInv, player.field_70170_p)) {
            placer.func_201511_a();
            return;
        }
        ItemStack result = recipe.func_77572_b((IInventory)craftInv);
        if (!ItemCraftingHalo.hasRoomFor(player.field_71071_by, result)) {
            placer.func_201511_a();
            return;
        }
        player.field_71071_by.func_70441_a(result);
        NonNullList remainingItems = recipe.func_179532_b((IInventory)craftInv);
        remainingItems.forEach(s -> player.field_71071_by.func_191975_a(player.field_70170_p, s));
        if (particles) {
            PacketBotaniaEffect pkt = new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.HALO_CRAFT, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.func_145782_y());
            PacketHandler.sendToNearby(player.field_70170_p, (Entity)player, (Object)pkt);
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity player) {
        int segment = ItemCraftingHalo.getSegmentLookedAt(stack, player);
        if (segment == 0) {
            return false;
        }
        IRecipe<CraftingInventory> recipe = ItemCraftingHalo.getSavedRecipe(player.field_70170_p, stack, segment);
        if (recipe != null && player.func_225608_bj_()) {
            ItemCraftingHalo.saveRecipe(stack, null, segment);
            return true;
        }
        return false;
    }

    private static int getSegmentLookedAt(ItemStack stack, LivingEntity player) {
        float yaw = ItemCraftingHalo.getCheckingAngle(player, ItemCraftingHalo.getRotationBase(stack));
        int angles = 360;
        int segAngles = angles / 12;
        for (int seg = 0; seg < 12; ++seg) {
            float calcAngle = (float)seg * (float)segAngles;
            if (!(yaw >= calcAngle) || !(yaw < calcAngle + (float)segAngles)) continue;
            return seg;
        }
        return -1;
    }

    private static float getCheckingAngle(LivingEntity player) {
        return ItemCraftingHalo.getCheckingAngle(player, 0.0f);
    }

    private static float getCheckingAngle(LivingEntity player, float base) {
        float angle;
        float yaw = MathHelper.func_76142_g((float)player.field_70177_z) + 90.0f;
        int angles = 360;
        int segAngles = angles / 12;
        float shift = segAngles / 2;
        if (yaw < 0.0f) {
            yaw = 180.0f + (180.0f + yaw);
        }
        if ((angle = 360.0f - (yaw -= 360.0f - base) + shift) < 0.0f) {
            angle = 360.0f + angle;
        }
        return angle;
    }

    @Nullable
    private static IRecipe<CraftingInventory> getSavedRecipe(World world, ItemStack halo, int position) {
        ResourceLocation id;
        String savedId = ItemNBTHelper.getString(halo, TAG_STORED_RECIPE_PREFIX + position, "");
        ResourceLocation resourceLocation = id = savedId.isEmpty() ? null : ResourceLocation.func_208304_a((String)savedId);
        if (position <= 0 || position >= 12 || id == null) {
            return null;
        }
        return ModRecipeTypes.getRecipes(world, IRecipeType.field_222149_a).get(id);
    }

    private static void saveRecipe(ItemStack halo, @Nullable ResourceLocation id, int position) {
        if (id == null) {
            ItemNBTHelper.removeEntry(halo, TAG_STORED_RECIPE_PREFIX + position);
        } else {
            ItemNBTHelper.setString(halo, TAG_STORED_RECIPE_PREFIX + position, id.toString());
        }
    }

    private static ItemStack getDisplayItem(World world, ItemStack stack, int position) {
        if (position == 0) {
            return craftingTable;
        }
        if (position >= 12) {
            return ItemStack.field_190927_a;
        }
        IRecipe<CraftingInventory> recipe = ItemCraftingHalo.getSavedRecipe(world, stack, position);
        if (recipe != null) {
            return recipe.func_77571_b();
        }
        return ItemStack.field_190927_a;
    }

    private void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        PlayerEntity player = event.getPlayer();
        Container container = player.field_71070_bA;
        IInventory inv = event.getInventory();
        if (!(container instanceof ContainerCraftingHalo) || !(inv instanceof CraftingInventory)) {
            return;
        }
        event.getPlayer().field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)((CraftingInventory)inv), player.field_70170_p).ifPresent(recipe -> {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCraftingHalo)) continue;
                ItemCraftingHalo.rememberLastRecipe(recipe.func_199560_c(), stack);
            }
        });
    }

    private static void rememberLastRecipe(ResourceLocation recipeId, ItemStack halo) {
        ItemNBTHelper.setString(halo, TAG_LAST_CRAFTING, recipeId.toString());
    }

    @Nullable
    private static IRecipe<CraftingInventory> getLastRecipe(World world, ItemStack halo) {
        String savedId = ItemNBTHelper.getString(halo, TAG_LAST_CRAFTING, "");
        ResourceLocation id = savedId.isEmpty() ? null : ResourceLocation.func_208304_a((String)savedId);
        return ModRecipeTypes.getRecipes(world, IRecipeType.field_222149_a).get(id);
    }

    private static boolean wasEquipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_EQUIPPED, false);
    }

    private static void setEquipped(ItemStack stack, boolean equipped) {
        ItemNBTHelper.setBoolean(stack, TAG_EQUIPPED, equipped);
    }

    private static float getRotationBase(ItemStack stack) {
        return ItemNBTHelper.getFloat(stack, TAG_ROTATION_BASE, 0.0f);
    }

    private static void setRotationBase(ItemStack stack, float rotation) {
        ItemNBTHelper.setFloat(stack, TAG_ROTATION_BASE, rotation);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onRenderWorldLast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = PlayerHelper.getFirstHeldItemClass((PlayerEntity)player, ItemCraftingHalo.class);
        if (!stack.func_190926_b()) {
            this.render(stack, (PlayerEntity)player, event.getMatrixStack(), event.getPartialTicks());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(ItemStack stack, PlayerEntity player, MatrixStack ms, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        double renderPosX = mc.func_175598_ae().field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = mc.func_175598_ae().field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = mc.func_175598_ae().field_217783_c.func_216785_c().func_82616_c();
        ms.func_227860_a_();
        float alpha = ((float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.2f) * 0.5f + 0.5f) * 0.4f + 0.3f;
        double posX = player.field_70169_q + (player.func_226277_ct_() - player.field_70169_q) * (double)partialTicks;
        double posY = player.field_70167_r + (player.func_226278_cu_() - player.field_70167_r) * (double)partialTicks + (double)player.func_70047_e();
        double posZ = player.field_70166_s + (player.func_226281_cx_() - player.field_70166_s) * (double)partialTicks;
        ms.func_227861_a_(posX - renderPosX, posY - renderPosY, posZ - renderPosZ);
        float base = ItemCraftingHalo.getRotationBase(stack);
        int angles = 360;
        int segAngles = angles / 12;
        float shift = base - (float)segAngles / 2.0f;
        float u = 1.0f;
        float v = 0.25f;
        float s = 3.0f;
        float m = 0.8f;
        float y = v * s * 2.0f;
        float y0 = 0.0f;
        int segmentLookedAt = ItemCraftingHalo.getSegmentLookedAt(stack, (LivingEntity)player);
        ItemCraftingHalo item = (ItemCraftingHalo)stack.func_77973_b();
        RenderType layer = RenderHelper.getHaloLayer(item.getGlowResource());
        for (int seg = 0; seg < 12; ++seg) {
            ItemStack slotStack;
            boolean inside = false;
            float rotationAngle = ((float)seg + 0.5f) * (float)segAngles + shift;
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotationAngle));
            ms.func_227861_a_((double)(s * m), -0.75, 0.0);
            if (segmentLookedAt == seg) {
                inside = true;
            }
            if (!(slotStack = ItemCraftingHalo.getDisplayItem(player.field_70170_p, stack, seg)).func_190926_b()) {
                float scale = seg == 0 ? 0.9f : 0.8f;
                ms.func_227862_a_(scale, scale, scale);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                ms.func_227861_a_(seg == 0 ? 0.5 : 0.0, seg == 0 ? (double)-0.1f : (double)0.6f, 0.0);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(slotStack, ItemCameraTransforms.TransformType.GUI, 0xF000F0, OverlayTexture.field_229196_a_, ms, (IRenderTypeBuffer)buffers);
            }
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            float a = alpha;
            if (inside) {
                a += 0.3f;
                y0 = -y;
            }
            if (seg % 2 == 0) {
                b = 0.6f;
                g = 0.6f;
                r = 0.6f;
            }
            IVertexBuilder buffer = buffers.getBuffer(layer);
            for (int i = 0; i < segAngles; ++i) {
                Matrix4f mat = ms.func_227866_c_().func_227870_a_();
                float ang = (float)(i + seg * segAngles) + shift;
                float xp = (float)Math.cos((double)ang * Math.PI / 180.0) * s;
                float zp = (float)Math.sin((double)ang * Math.PI / 180.0) * s;
                buffer.func_227888_a_(mat, xp * m, y, zp * m).func_227885_a_(r, g, b, a).func_225583_a_(u, v).func_181675_d();
                buffer.func_227888_a_(mat, xp, y0, zp).func_227885_a_(r, g, b, a).func_225583_a_(u, 0.0f).func_181675_d();
                xp = (float)Math.cos((double)(ang + 1.0f) * Math.PI / 180.0) * s;
                zp = (float)Math.sin((double)(ang + 1.0f) * Math.PI / 180.0) * s;
                buffer.func_227888_a_(mat, xp, y0, zp).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(mat, xp * m, y, zp * m).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, v).func_181675_d();
            }
            y0 = 0.0f;
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
        buffers.func_228461_a_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getGlowResource() {
        return glowTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHUD(MatrixStack ms, PlayerEntity player, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        int slot = ItemCraftingHalo.getSegmentLookedAt(stack, (LivingEntity)player);
        if (slot == 0) {
            String name = craftingTable.func_200301_q().getString();
            int l = mc.field_71466_p.func_78256_a(name);
            int x = mc.func_228018_at_().func_198107_o() / 2 - l / 2;
            int y = mc.func_228018_at_().func_198087_p() / 2 - 65;
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x22000000);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x22000000);
            mc.func_175599_af().func_180450_b(craftingTable, mc.func_228018_at_().func_198107_o() / 2 - 8, mc.func_228018_at_().func_198087_p() / 2 - 52);
            mc.field_71466_p.func_238405_a_(ms, name, (float)x, (float)y, 0xFFFFFF);
        } else {
            ITextComponent label;
            IRecipe<CraftingInventory> recipe = ItemCraftingHalo.getSavedRecipe(player.field_70170_p, stack, slot);
            boolean setRecipe = false;
            if (recipe == null) {
                label = new TranslationTextComponent("botaniamisc.unsetRecipe");
                recipe = ItemCraftingHalo.getLastRecipe(player.field_70170_p, stack);
            } else {
                label = recipe.func_77571_b().func_200301_q();
                setRecipe = true;
            }
            ItemCraftingHalo.renderRecipe(ms, label, recipe, player, setRecipe);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderRecipe(MatrixStack ms, ITextComponent label, @Nullable IRecipe<CraftingInventory> recipe, PlayerEntity player, boolean isSavedRecipe) {
        Minecraft mc = Minecraft.func_71410_x();
        if (recipe != null && !recipe.func_77571_b().func_190926_b()) {
            int x = mc.func_228018_at_().func_198107_o() / 2 - 45;
            int y = mc.func_228018_at_().func_198087_p() / 2 - 90;
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x - 6), (int)(y - 6), (int)(x + 90 + 6), (int)(y + 60), (int)0x22000000);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x - 4), (int)(y - 4), (int)(x + 90 + 4), (int)(y + 58), (int)0x22000000);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x + 66), (int)(y + 14), (int)(x + 92), (int)(y + 40), (int)0x22000000);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(x - 2), (int)(y - 2), (int)(x + 56), (int)(y + 56), (int)0x22000000);
            int wrap = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : 3;
            for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
                Ingredient ingr = (Ingredient)recipe.func_192400_c().get(i);
                if (ingr == Ingredient.field_193370_a) continue;
                ItemStack stack = ingr.func_193365_a()[ClientTickHandler.ticksInGame / 20 % ingr.func_193365_a().length];
                int xpos = x + i % wrap * 18;
                int ypos = y + i / wrap * 18;
                AbstractGui.func_238467_a_((MatrixStack)ms, (int)xpos, (int)ypos, (int)(xpos + 16), (int)(ypos + 16), (int)0x22000000);
                mc.func_175599_af().func_180450_b(stack, xpos, ypos);
            }
            mc.func_175599_af().func_180450_b(recipe.func_77571_b(), x + 72, y + 18);
            mc.func_175599_af().func_175030_a(mc.field_71466_p, recipe.func_77571_b(), x + 72, y + 18);
        }
        int yoff = 110;
        if (isSavedRecipe && recipe != null && !ItemCraftingHalo.canCraftHeuristic(player, recipe)) {
            String warning = TextFormatting.RED + I18n.func_135052_a((String)"botaniamisc.cantCraft", (Object[])new Object[0]);
            mc.field_71466_p.func_238405_a_(ms, warning, (float)mc.func_228018_at_().func_198107_o() / 2.0f - (float)mc.field_71466_p.func_78256_a(warning) / 2.0f, (float)mc.func_228018_at_().func_198087_p() / 2.0f - (float)yoff, 0xFFFFFF);
            yoff += 12;
        }
        mc.field_71466_p.func_243246_a(ms, label, (float)mc.func_228018_at_().func_198107_o() / 2.0f - (float)mc.field_71466_p.func_78256_a(label.getString()) / 2.0f, (float)mc.func_228018_at_().func_198087_p() / 2.0f - (float)yoff, 0xFFFFFF);
    }

    public static class RecipePlacer
    extends ServerRecipePlacer<CraftingInventory> {
        public RecipePlacer(RecipeBookContainer<CraftingInventory> container) {
            super(container);
        }

        public boolean place(ServerPlayerEntity player, @Nullable IRecipe<CraftingInventory> recipe) {
            if (recipe != null) {
                boolean ret;
                this.field_201514_c = player.field_71071_by;
                this.field_194331_b.func_194119_a();
                player.field_71071_by.func_201571_a(this.field_194331_b);
                this.field_201515_d.func_201771_a(this.field_194331_b);
                if (this.field_194331_b.func_194116_a(recipe, null)) {
                    this.func_201508_a(recipe, false);
                    ret = true;
                } else {
                    this.func_201511_a();
                    ret = false;
                }
                player.field_71071_by.func_70296_d();
                return ret;
            }
            return false;
        }

        public void func_201511_a() {
            super.func_201511_a();
        }
    }
}

