/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.ManaNetworkEvent;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final WeakHashMap<World, Set<TileEntity>> manaPools = new WeakHashMap();
    private final WeakHashMap<World, Set<TileEntity>> manaCollectors = new WeakHashMap();

    public void onNetworkEvent(ManaNetworkEvent event) {
        WeakHashMap<World, Set<TileEntity>> map;
        WeakHashMap<World, Set<TileEntity>> weakHashMap = map = event.type == ManaNetworkEvent.ManaBlockType.COLLECTOR ? this.manaCollectors : this.manaPools;
        if (event.action == ManaNetworkEvent.Action.ADD) {
            this.add(map, event.tile);
        } else {
            this.remove(map, event.tile);
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public TileEntity getClosestPool(BlockPos pos, World world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public TileEntity getClosestCollector(BlockPos pos, World world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    public boolean isCollectorIn(TileEntity tile) {
        return this.isIn(tile, this.manaCollectors);
    }

    public boolean isPoolIn(TileEntity tile) {
        return this.isIn(tile, this.manaPools);
    }

    private boolean isIn(TileEntity tile, Map<World, Set<TileEntity>> map) {
        Set<TileEntity> set = map.get(tile.func_145831_w());
        return set != null && set.contains(tile);
    }

    @Nullable
    private TileEntity getClosest(Set<TileEntity> tiles, BlockPos pos, int limit) {
        double minDist = Double.MAX_VALUE;
        TileEntity closest = null;
        for (TileEntity te : tiles) {
            double distance;
            if (te.func_145837_r() || !((distance = te.func_174877_v().func_177951_i((Vector3i)pos)) <= (double)(limit * limit)) || !(distance < minDist)) continue;
            minDist = distance;
            closest = te;
        }
        return closest;
    }

    private void remove(Map<World, Set<TileEntity>> map, TileEntity tile) {
        World world = tile.func_145831_w();
        if (!map.containsKey(world)) {
            return;
        }
        map.get(world).remove(tile);
    }

    private void add(Map<World, Set<TileEntity>> map, TileEntity tile) {
        World world = tile.func_145831_w();
        map.computeIfAbsent(world, k -> new HashSet()).add(tile);
    }

    @Override
    public Set<TileEntity> getAllCollectorsInWorld(World world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<TileEntity> getAllPoolsInWorld(World world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    private Set<TileEntity> getAllInWorld(Map<World, Set<TileEntity>> map, World world) {
        Set<TileEntity> ret = map.get(world);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }
}

