/*
 * Decompiled with CFR 0.152.
 */
package alsender.earthworks.main;

import alsender.earthworks.datagen.ModDatagen;
import alsender.earthworks.main.Config;
import alsender.earthworks.main.crafting.ShapelessReturnRecipe;
import alsender.earthworks.main.registry.BlockRegistry;
import alsender.earthworks.main.registry.ItemRegistry;
import alsender.earthworks.main.world.Worldgen;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

@Mod(value="earthworks")
public class Earthworks {
    public static final String mod_id = "earthworks";
    public static final IRecipeSerializer<?> shapeless_return = new ShapelessReturnRecipe.ReturnSerializer();
    public static final Config COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ItemGroup creativeTab;
    public static Logger logger;

    public Earthworks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModDatagen::start);
        bus.addGenericListener(Block.class, this::blocks);
        bus.addGenericListener(Item.class, this::items);
        bus.addGenericListener(IRecipeSerializer.class, this::recipeSerializers);
        MinecraftForge.EVENT_BUS.addListener(Worldgen::addFeatures);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    private void blocks(RegistryEvent.Register<Block> event) {
        BlockRegistry.initBlocks(event);
    }

    private void items(RegistryEvent.Register<Item> event) {
        ItemRegistry.initItems(event);
    }

    private void recipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)shapeless_return.setRegistryName(new ResourceLocation(mod_id, "shapeless_return")));
    }

    static {
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(Config::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair2.getRight();
        COMMON = (Config)specPair2.getLeft();
        creativeTab = new ItemGroup(mod_id){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)BlockRegistry.wattle_and_daub);
            }

            public boolean hasSearchBar() {
                return true;
            }
        }.func_78025_a("item_search.png");
    }
}

