/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerHelper {
    private static final ArrayList<String> knownFakePlayers = Lists.newArrayList();

    public static PlayerEntity getPlayerFromId(UUID uuid) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(uuid);
    }

    public static PlayerEntity getPlayerFromUUID(UUID uuid) {
        return PlayerHelper.getPlayerFromId(uuid);
    }

    public static UUID getUUIDFromPlayer(PlayerEntity player) {
        return player.func_146103_bH().getId();
    }

    public static String getUsernameFromUUID(UUID uuid) {
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static boolean isFakePlayer(PlayerEntity player) {
        return player instanceof FakePlayer || player != null && knownFakePlayers.contains(player.getClass().getCanonicalName());
    }
}

