/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.tile.TileExplosiveCharge;

public class TileVeinMineCharge
extends TileExplosiveCharge {
    @ObjectHolder(value="bloodmagic:veinmine_charge")
    public static TileEntityType<TileVeinMineCharge> TYPE;
    private Map<BlockPos, Boolean> veinPartsMap;
    private List<BlockPos> veinPartsCache;
    private boolean finishedAnalysis;
    private Vector3i[] diagonals = new Vector3i[]{new Vector3i(0, 1, 1), new Vector3i(0, 1, -1), new Vector3i(0, -1, 1), new Vector3i(0, -1, -1), new Vector3i(1, 0, 1), new Vector3i(-1, 0, 1), new Vector3i(1, 0, -1), new Vector3i(-1, 0, -1), new Vector3i(1, 1, 0), new Vector3i(-1, 1, 0), new Vector3i(1, -1, 0), new Vector3i(-1, -1, 0)};
    public double internalCounter = 0.0;
    public int currentBlocks = 0;
    public int maxBlocks = 128;

    public TileVeinMineCharge(TileEntityType<?> type, int maxBlocks) {
        super(type);
        this.maxBlocks = maxBlocks;
    }

    public TileVeinMineCharge() {
        this(TYPE, 192);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Direction explosiveDirection = ((Direction)this.func_195044_w().func_177229_b(BlockShapedExplosive.ATTACHED)).func_176734_d();
        BlockState attachedState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(explosiveDirection));
        Block attachedBlock = attachedState.func_177230_c();
        if (!this.isValidStartingBlock(attachedState)) {
            return;
        }
        if (this.veinPartsMap == null) {
            this.veinPartsMap = new HashMap<BlockPos, Boolean>();
            this.veinPartsMap.put(this.field_174879_c.func_177972_a(explosiveDirection), false);
            this.veinPartsCache = new LinkedList<BlockPos>();
            this.veinPartsCache.add(this.field_174879_c.func_177972_a(explosiveDirection));
            this.internalCounter = 0.0;
        }
        boolean foundNew = false;
        LinkedList<BlockPos> newPositions = new LinkedList<BlockPos>();
        for (BlockPos currentPos : this.veinPartsCache) {
            boolean isTree;
            BlockState checkState;
            BlockPos checkPos;
            if (this.veinPartsMap.getOrDefault(currentPos, false).booleanValue()) continue;
            for (Direction direction : Direction.values()) {
                checkPos = currentPos.func_177972_a(direction);
                if (this.veinPartsMap.containsKey(checkPos)) continue;
                checkState = this.field_145850_b.func_180495_p(checkPos);
                isTree = false;
                if (this.currentBlocks >= this.maxBlocks) continue;
                if (this.isValidBlock(attachedState, checkState)) {
                    ++this.currentBlocks;
                    isTree = true;
                }
                if (!isTree) continue;
                this.veinPartsMap.put(checkPos, false);
                newPositions.add(checkPos);
                foundNew = true;
            }
            if (this.checkDiagonals()) {
                for (Direction direction : this.diagonals) {
                    checkPos = currentPos.func_177971_a((Vector3i)direction);
                    if (this.veinPartsMap.containsKey(checkPos)) continue;
                    checkState = this.field_145850_b.func_180495_p(checkPos);
                    isTree = false;
                    if (this.currentBlocks >= this.maxBlocks) continue;
                    if (this.isValidBlock(attachedState, checkState)) {
                        ++this.currentBlocks;
                        isTree = true;
                    }
                    if (!isTree) continue;
                    this.veinPartsMap.put(checkPos, false);
                    newPositions.add(checkPos);
                    foundNew = true;
                }
            }
            this.veinPartsMap.put(currentPos, true);
            if (this.currentBlocks < this.maxBlocks) continue;
            this.finishedAnalysis = true;
            break;
        }
        this.veinPartsCache.addAll(newPositions);
        if (foundNew) {
            return;
        }
        this.internalCounter += 1.0;
        if (this.internalCounter == 20.0) {
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f);
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197631_x, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.02, 0.03, 0.02, 0.0);
        }
        if (this.internalCounter == 30.0) {
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (this.internalCounter < 30.0) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextDouble() < 0.3) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.internalCounter == 100.0) {
            ItemStack toolStack = this.getHarvestingTool();
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            int numParticles = 10;
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197627_t, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)explosiveDirection.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + (double)explosiveDirection.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)explosiveDirection.func_82599_e(), numParticles, 1.0, 1.0, 1.0, 0.0);
            ObjectArrayList objectarraylist = new ObjectArrayList();
            for (BlockPos blockPos : this.veinPartsCache) {
                BlockState blockState = this.field_145850_b.func_180495_p(blockPos);
                Block block = blockState.func_177230_c();
                if (blockState.isAir((IBlockReader)this.field_145850_b, blockPos)) continue;
                BlockPos blockpos1 = blockPos.func_185334_h();
                if (!(this.field_145850_b instanceof ServerWorld)) continue;
                TileEntity tileentity = blockState.hasTileEntity() ? this.field_145850_b.func_175625_s(blockPos) : null;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockPos)).func_216015_a(LootParameters.field_216289_i, (Object)toolStack).func_216021_b(LootParameters.field_216288_h, (Object)tileentity);
                blockState.func_215693_a(lootcontext$builder).forEach(stack -> TileVeinMineCharge.handleExplosionDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                this.field_145850_b.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
            this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        this.internalCounter = tag.func_74769_h("internalCounter");
        this.maxBlocks = tag.func_74762_e("maxBlocks");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        tag.func_74780_a("internalCounter", this.internalCounter);
        tag.func_74768_a("maxBlocks", this.maxBlocks);
        return tag;
    }

    public boolean isValidBlock(BlockState originalBlockState, BlockState testState) {
        return originalBlockState.func_177230_c() == testState.func_177230_c();
    }

    public boolean isValidStartingBlock(BlockState originalBlockState) {
        return true;
    }

    public boolean checkDiagonals() {
        return true;
    }
}

