/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.tile.TileExplosiveCharge;

public class TileDeforesterCharge
extends TileExplosiveCharge {
    @ObjectHolder(value="bloodmagic:deforester_charge")
    public static TileEntityType<TileDeforesterCharge> TYPE;
    private Map<BlockPos, Boolean> treePartsMap;
    private List<BlockPos> treePartsCache;
    private boolean finishedAnalysis;
    public double internalCounter = 0.0;
    public int currentLogs = 0;
    public int maxLogs = 128;

    public TileDeforesterCharge(TileEntityType<?> type, int maxLogs) {
        super(type);
        this.maxLogs = maxLogs;
    }

    public TileDeforesterCharge() {
        this(TYPE, 128);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Direction explosiveDirection = ((Direction)this.func_195044_w().func_177229_b(BlockShapedExplosive.ATTACHED)).func_176734_d();
        BlockState attachedState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(explosiveDirection));
        if (!BlockTags.field_200031_h.func_230235_a_((Object)attachedState.func_177230_c()) && !BlockTags.field_206952_E.func_230235_a_((Object)attachedState.func_177230_c())) {
            return;
        }
        if (this.treePartsMap == null) {
            this.treePartsMap = new HashMap<BlockPos, Boolean>();
            this.treePartsMap.put(this.field_174879_c.func_177972_a(explosiveDirection), false);
            this.treePartsCache = new LinkedList<BlockPos>();
            this.treePartsCache.add(this.field_174879_c.func_177972_a(explosiveDirection));
            this.internalCounter = 0.0;
        }
        boolean foundNew = false;
        LinkedList<BlockPos> newPositions = new LinkedList<BlockPos>();
        for (BlockPos currentPos : this.treePartsCache) {
            if (this.treePartsMap.getOrDefault(currentPos, false).booleanValue()) continue;
            for (Direction dir : Direction.values()) {
                BlockPos checkPos = currentPos.func_177972_a(dir);
                if (this.treePartsMap.containsKey(checkPos)) continue;
                BlockState checkState = this.field_145850_b.func_180495_p(checkPos);
                boolean isTree = false;
                if (this.currentLogs >= this.maxLogs) continue;
                if (BlockTags.field_200031_h.func_230235_a_((Object)checkState.func_177230_c())) {
                    ++this.currentLogs;
                    isTree = true;
                } else if (BlockTags.field_206952_E.func_230235_a_((Object)checkState.func_177230_c())) {
                    isTree = true;
                }
                if (!isTree) continue;
                this.treePartsMap.put(checkPos, false);
                newPositions.add(checkPos);
                foundNew = true;
            }
            this.treePartsMap.put(currentPos, true);
            if (this.currentLogs < this.maxLogs) continue;
            this.finishedAnalysis = true;
            break;
        }
        this.treePartsCache.addAll(newPositions);
        if (foundNew) {
            return;
        }
        this.internalCounter += 1.0;
        if (this.internalCounter == 20.0) {
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f);
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197631_x, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.02, 0.03, 0.02, 0.0);
        }
        if (this.internalCounter == 30.0) {
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (this.internalCounter < 30.0) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextDouble() < 0.3) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.internalCounter == 100.0) {
            ItemStack toolStack = this.getHarvestingTool();
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            int numParticles = 10;
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197627_t, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)explosiveDirection.func_82601_c(), (double)this.field_174879_c.func_177956_o() + 0.5 + (double)explosiveDirection.func_96559_d(), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)explosiveDirection.func_82599_e(), numParticles, 1.0, 1.0, 1.0, 0.0);
            ObjectArrayList objectarraylist = new ObjectArrayList();
            for (BlockPos blockPos : this.treePartsCache) {
                BlockState blockstate = this.field_145850_b.func_180495_p(blockPos);
                Block block = blockstate.func_177230_c();
                if (blockstate.isAir((IBlockReader)this.field_145850_b, blockPos)) continue;
                BlockPos blockpos1 = blockPos.func_185334_h();
                if (!(this.field_145850_b instanceof ServerWorld)) continue;
                TileEntity tileentity = blockstate.hasTileEntity() ? this.field_145850_b.func_175625_s(blockPos) : null;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockPos)).func_216015_a(LootParameters.field_216289_i, (Object)toolStack).func_216021_b(LootParameters.field_216288_h, (Object)tileentity);
                blockstate.func_215693_a(lootcontext$builder).forEach(stack -> TileDeforesterCharge.handleExplosionDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                this.field_145850_b.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
            this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        this.internalCounter = tag.func_74769_h("internalCounter");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        tag.func_74780_a("internalCounter", this.internalCounter);
        return tag;
    }
}

