/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.will.DemonWillHolder;

@RitualRegister(value="green_grove")
public class RitualGreenGrove
extends Ritual {
    public static final String GROW_RANGE = "growing";
    public static final String LEECH_RANGE = "leech";
    public static final String HYDRATE_RANGE = "hydrate";
    public static double corrosiveWillDrain = 0.2;
    public static double rawWillDrain = 0.05;
    public static double vengefulWillDrain = 0.05;
    public static double steadfastWillDrain = 0.05;
    public static int defaultRefreshTime = 20;
    public static double defaultGrowthChance = 0.3;
    public static BlockState farmlandState = (BlockState)Blocks.field_150458_ak.func_176223_P().func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7));
    public int refreshTime = 20;

    public RitualGreenGrove() {
        super("ritualGreenGrove", 0, 5000, "ritual.bloodmagic.greenGroveRitual");
        this.addBlockRange(GROW_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 2, -1), 3, 1, 3));
        this.addBlockRange(LEECH_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(HYDRATE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(GROW_RANGE, 81, 4, 4);
        this.setMaximumVolumeAndDistanceOfRange(LEECH_RANGE, 0, 15, 15);
        this.setMaximumVolumeAndDistanceOfRange(HYDRATE_RANGE, 0, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (!(world instanceof ServerWorld)) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxGrowths = currentEssence / this.getRefreshCost();
        int totalGrowths = 0;
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        double growthChance = this.getPlantGrowthChanceForWill(vengefulWill);
        boolean consumeRawWill = rawWill >= rawWillDrain && this.refreshTime != defaultRefreshTime;
        boolean consumeVengefulWill = vengefulWill >= vengefulWillDrain && growthChance != defaultGrowthChance;
        double rawDrain = 0.0;
        double vengefulDrain = 0.0;
        AreaDescriptor growingRange = masterRitualStone.getBlockRange(GROW_RANGE);
        int maxGrowthVolume = this.getMaxVolumeForRange(GROW_RANGE, willConfig, holder);
        if (!growingRange.isWithinRange(this.getMaxVerticalRadiusForRange(GROW_RANGE, willConfig, holder), this.getMaxHorizontalRadiusForRange(GROW_RANGE, willConfig, holder)) || maxGrowthVolume != 0 && growingRange.getVolume() > maxGrowthVolume) {
            return;
        }
        for (BlockPos newPos : growingRange.getContainedPositions(pos)) {
            BlockState state = world.func_180495_p(newPos);
            if (!BloodMagicAPI.INSTANCE.getBlacklist().getGreenGrove().contains(state)) {
                boolean flag;
                boolean bl = flag = state.func_177230_c() instanceof IGrowable || state.func_177230_c() instanceof CactusBlock || state.func_177230_c() instanceof SugarCaneBlock;
                if (flag && world.field_73012_v.nextDouble() < growthChance) {
                    state.func_177230_c().func_225542_b_(state, serverWorld, newPos, new Random());
                    BlockState newState = world.func_180495_p(newPos);
                    if (!newState.equals(state)) {
                        world.func_217379_c(2005, newPos, 0);
                        ++totalGrowths;
                        if (consumeRawWill) {
                            rawWill -= rawWillDrain;
                            rawDrain += rawWillDrain;
                        }
                        if (consumeVengefulWill) {
                            vengefulWill -= vengefulWillDrain;
                            vengefulDrain += vengefulWillDrain;
                        }
                    }
                }
            }
            if (!(totalGrowths >= maxGrowths || consumeRawWill && rawWill < rawWillDrain) && (!consumeVengefulWill || !(vengefulWill < vengefulWillDrain))) continue;
            break;
        }
        if (rawDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrain, true);
        }
        if (vengefulDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrain, true);
        }
        AreaDescriptor hydrateRange = masterRitualStone.getBlockRange(HYDRATE_RANGE);
        double steadfastDrain = 0.0;
        if (steadfastWill > steadfastWillDrain) {
            AxisAlignedBB aabb = hydrateRange.getAABB(pos);
            steadfastWill -= (steadfastDrain += steadfastWillDrain * (double)Utils.plantSeedsInArea(world, aabb, 2, 1));
            for (BlockPos newPos : hydrateRange.getContainedPositions(pos)) {
                int meta;
                if (steadfastWill < steadfastWillDrain) break;
                BlockState state = world.func_180495_p(newPos);
                Block block = state.func_177230_c();
                boolean hydratedBlock = false;
                if (block == Blocks.field_150346_d || block == Blocks.field_150349_c) {
                    world.func_175656_a(newPos, farmlandState);
                    hydratedBlock = true;
                } else if (block == Blocks.field_150458_ak && (meta = ((Integer)state.func_177229_b((Property)FarmlandBlock.field_176531_a)).intValue()) < 7) {
                    world.func_175656_a(newPos, farmlandState);
                    hydratedBlock = true;
                }
                if (!hydratedBlock) continue;
                steadfastWill -= steadfastWillDrain;
                steadfastDrain += steadfastWillDrain;
            }
        }
        if (steadfastDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrain, true);
        }
        double corrosiveDrain = 0.0;
        if (corrosiveWill > corrosiveWillDrain) {
            AreaDescriptor leechRange = masterRitualStone.getBlockRange(LEECH_RANGE);
            AxisAlignedBB mobArea = leechRange.getAABB(pos);
            List entityList = world.func_217357_a(LivingEntity.class, mobArea);
            for (LivingEntity entityLiving : entityList) {
                if (corrosiveWill < corrosiveWillDrain) break;
                if (entityLiving instanceof PlayerEntity || entityLiving.func_70644_a(BloodMagicPotions.PLANT_LEECH) || !entityLiving.func_70687_e(new EffectInstance(BloodMagicPotions.PLANT_LEECH))) continue;
                entityLiving.func_195064_c(new EffectInstance(BloodMagicPotions.PLANT_LEECH, 200, 0));
                corrosiveWill -= corrosiveWillDrain;
                corrosiveDrain += corrosiveWillDrain;
            }
            if (corrosiveDrain > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrain, true);
            }
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(totalGrowths * this.getRefreshCost()));
    }

    public double getPlantGrowthChanceForWill(double will) {
        if (will > 0.0) {
            return 0.3 + will / 200.0;
        }
        return defaultGrowthChance;
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill > 0.0) {
            return 10;
        }
        return defaultRefreshTime;
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public int getMaxVolumeForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (GROW_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return 81 + (int)Math.pow(destructiveWill / 4.0, 1.5);
        }
        return (Integer)this.volumeRangeMap.get(range);
    }

    @Override
    public int getMaxVerticalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (GROW_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(4.0 + destructiveWill / 10.0);
        }
        return (Integer)this.verticalRangeMap.get(range);
    }

    @Override
    public int getMaxHorizontalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (GROW_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(4.0 + destructiveWill / 10.0);
        }
        return (Integer)this.horizontalRangeMap.get(range);
    }

    @Override
    public int getRefreshCost() {
        return 20;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 1, 0, EnumRuneType.WATER);
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(PlayerEntity player) {
        return new ITextComponent[]{new TranslationTextComponent(this.getTranslationKey() + ".info"), new TranslationTextComponent(this.getTranslationKey() + ".default.info"), new TranslationTextComponent(this.getTranslationKey() + ".corrosive.info"), new TranslationTextComponent(this.getTranslationKey() + ".steadfast.info"), new TranslationTextComponent(this.getTranslationKey() + ".destructive.info"), new TranslationTextComponent(this.getTranslationKey() + ".vengeful.info")};
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualGreenGrove();
    }
}

