/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.tile.TileDemonCrystal;

@RitualRegister(value="crystal_split")
public class RitualCrystalSplit
extends Ritual {
    public RitualCrystalSplit() {
        super("ritualCrystalSplit", 0, 20000, "ritual.bloodmagic.crystalSplitRitual");
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        Direction direction = masterRitualStone.getDirection();
        BlockPos rawPos = pos.func_177981_b(2);
        TileEntity tile = world.func_175625_s(rawPos);
        if (!(tile instanceof TileDemonCrystal) || ((TileDemonCrystal)tile).getWillType() != EnumDemonWillType.DEFAULT) {
            return;
        }
        BlockState rawState = world.func_180495_p(rawPos);
        TileDemonCrystal rawTile = (TileDemonCrystal)tile;
        if (rawTile.getCrystalCount() >= 5) {
            BlockPos vengefulPos = pos.func_177972_a(this.rotateFacing(Direction.NORTH, direction)).func_177984_a();
            BlockPos corrosivePos = pos.func_177972_a(this.rotateFacing(Direction.EAST, direction)).func_177984_a();
            BlockPos steadfastPos = pos.func_177972_a(this.rotateFacing(Direction.SOUTH, direction)).func_177984_a();
            BlockPos destructivePos = pos.func_177972_a(this.rotateFacing(Direction.WEST, direction)).func_177984_a();
            int vengefulCrystals = 0;
            int corrosiveCrystals = 0;
            int steadfastCrystals = 0;
            int destructiveCrystals = 0;
            tile = world.func_175625_s(vengefulPos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.VENGEFUL && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                vengefulCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(vengefulPos)) {
                return;
            }
            tile = world.func_175625_s(corrosivePos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.CORROSIVE && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                corrosiveCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(corrosivePos)) {
                return;
            }
            tile = world.func_175625_s(steadfastPos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.STEADFAST && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                steadfastCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(steadfastPos)) {
                return;
            }
            tile = world.func_175625_s(destructivePos);
            if (tile instanceof TileDemonCrystal && ((TileDemonCrystal)tile).getWillType() == EnumDemonWillType.DESTRUCTIVE && ((TileDemonCrystal)tile).getCrystalCount() < 7) {
                destructiveCrystals = ((TileDemonCrystal)tile).getCrystalCount();
            } else if (tile instanceof TileDemonCrystal || !world.func_175623_d(destructivePos)) {
                return;
            }
            rawTile.setCrystalCount(rawTile.getCrystalCount() - 4);
            this.growCrystal(world, vengefulPos, EnumDemonWillType.VENGEFUL, vengefulCrystals);
            this.growCrystal(world, corrosivePos, EnumDemonWillType.CORROSIVE, corrosiveCrystals);
            this.growCrystal(world, steadfastPos, EnumDemonWillType.STEADFAST, steadfastCrystals);
            this.growCrystal(world, destructivePos, EnumDemonWillType.DESTRUCTIVE, destructiveCrystals);
            rawTile.func_70296_d();
            world.func_184138_a(rawPos, rawState, rawState, 3);
        }
    }

    public Direction rotateFacing(Direction facing, Direction rotation) {
        switch (rotation) {
            case EAST: {
                return facing.func_176746_e();
            }
            case SOUTH: {
                return facing.func_176746_e().func_176746_e();
            }
            case WEST: {
                return facing.func_176735_f();
            }
        }
        return facing;
    }

    public void growCrystal(World world, BlockPos pos, EnumDemonWillType type, int currentCrystalCount) {
        if (currentCrystalCount <= 0) {
            BlockState state;
            switch (type) {
                case CORROSIVE: {
                    state = ((Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get()).func_176223_P();
                    break;
                }
                case DEFAULT: {
                    state = ((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get()).func_176223_P();
                    break;
                }
                case DESTRUCTIVE: {
                    state = ((Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get()).func_176223_P();
                    break;
                }
                case STEADFAST: {
                    state = ((Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get()).func_176223_P();
                    break;
                }
                case VENGEFUL: {
                    state = ((Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get()).func_176223_P();
                    break;
                }
                default: {
                    state = ((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get()).func_176223_P();
                }
            }
            world.func_180501_a(pos, state, 3);
        } else {
            TileDemonCrystal tile = (TileDemonCrystal)world.func_175625_s(pos);
            tile.setCrystalCount(currentCrystalCount + 1);
            tile.func_70296_d();
            BlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 1000;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -1, EnumRuneType.FIRE);
        this.addRune(components, 1, 0, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 0, 1, EnumRuneType.WATER);
        this.addRune(components, -1, 0, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, -1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 1, 0, EnumRuneType.BLANK);
        this.addParallelRunes(components, 2, 0, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrystalSplit();
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(PlayerEntity player) {
        return new ITextComponent[]{new TranslationTextComponent(this.getTranslationKey() + ".info")};
    }
}

