/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockMasterRitualStone;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.IRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="crushing")
public class RitualCrushing
extends Ritual {
    public static final String CRUSHING_RANGE = "crushingRange";
    public static final String CHEST_RANGE = "chest";
    public static double rawWillDrain = 0.05;
    public static double steadfastWillDrain = 0.2;
    public static double destructiveWillDrain = 0.2;
    public static double vengefulWillDrain = 0.2;
    public static Map<ItemStack, Integer> cuttingFluidLPMap = new HashMap<ItemStack, Integer>();
    public static Map<ItemStack, Double> cuttingFluidWillMap = new HashMap<ItemStack, Double>();
    public static int defaultRefreshTime = 40;
    private FakePlayer fakePlayer;
    public int refreshTime = 40;
    private static final ItemStack mockPick = new ItemStack((IItemProvider)Items.field_151046_w, 1);

    public RitualCrushing() {
        super("ritualCrushing", 0, 5000, "ritual.bloodmagic.crushingRitual");
        this.addBlockRange(CRUSHING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, -3, -1), 3));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(CRUSHING_RANGE, 50, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        if (world.field_72995_K) {
            return;
        }
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
        if (tile != null && Utils.getNumberOfFreeSlots(tile, Direction.DOWN) < 1) {
            return;
        }
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        boolean consumeRawWill = rawWill >= rawWillDrain && this.refreshTime != defaultRefreshTime;
        boolean isSilkTouch = steadfastWill >= steadfastWillDrain;
        boolean useCuttingFluid = corrosiveWill > 0.0;
        int fortune = destructiveWill > 0.0 ? 3 : 0;
        AreaDescriptor crushingRange = masterRitualStone.getBlockRange(CRUSHING_RANGE);
        boolean hasOperated = false;
        double rawDrain = 0.0;
        for (BlockPos newPos : crushingRange.getContainedPositions(pos)) {
            BlockState state;
            Block block;
            if (world.func_175623_d(newPos) || (block = (state = world.func_180495_p(newPos)).func_177230_c()) instanceof BlockMasterRitualStone || block instanceof IRitualStone || state.func_185887_b((IBlockReader)world, newPos) == -1.0f || Utils.isBlockLiquid(state)) continue;
            boolean isBlockClaimed = false;
            if (!isBlockClaimed && isSilkTouch) {
                LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)world);
                Vector3d blockCenter = new Vector3d((double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o() + 0.5, (double)newPos.func_177952_p() + 0.5);
                List silkDrops = state.func_215693_a(lootBuilder.func_216015_a(LootParameters.field_237457_g_, (Object)blockCenter).func_216015_a(LootParameters.field_216289_i, (Object)mockPick));
                for (ItemStack item : silkDrops) {
                    ItemStack copyStack = item.func_77946_l();
                    if (tile == null) {
                        Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                        continue;
                    }
                    copyStack = Utils.insertStackIntoTile(copyStack, tile, Direction.DOWN);
                    if (copyStack.func_190926_b()) continue;
                    Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                }
                if (!(steadfastWill >= steadfastWillDrain)) continue;
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastWillDrain, true);
                steadfastWill -= steadfastWillDrain;
            } else if (!isBlockClaimed) {
                if (fortune > 0 && destructiveWill < destructiveWillDrain) {
                    fortune = 0;
                }
                ItemStack mockFortunePick = new ItemStack((IItemProvider)Items.field_151046_w, 1);
                mockFortunePick.func_77966_a(Enchantments.field_185308_t, fortune);
                LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)world);
                Vector3d blockCenter = new Vector3d((double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o() + 0.5, (double)newPos.func_177952_p() + 0.5);
                List stackList = state.func_215693_a(lootBuilder.func_216015_a(LootParameters.field_237457_g_, (Object)blockCenter).func_216015_a(LootParameters.field_216289_i, (Object)mockFortunePick));
                for (ItemStack item : stackList) {
                    ItemStack copyStack = item.func_77946_l();
                    if (tile == null) {
                        Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                        continue;
                    }
                    copyStack = Utils.insertStackIntoTile(copyStack, tile, Direction.DOWN);
                    if (copyStack.func_190926_b()) continue;
                    Utils.spawnStackAtBlock(world, pos, Direction.UP, copyStack);
                }
                if (fortune > 0) {
                    WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveWillDrain, true);
                    destructiveWill -= destructiveWillDrain;
                }
            }
            world.func_175655_b(newPos, false);
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
            hasOperated = true;
            if (!consumeRawWill) break;
            rawDrain += rawWillDrain;
            rawWill -= rawWillDrain;
            break;
        }
        if (rawDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrain, true);
        }
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill >= rawWillDrain) {
            return Math.max(1, (int)(40.0 - rawWill / 5.0));
        }
        return defaultRefreshTime;
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public int getRefreshCost() {
        return 7;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, 1, EnumRuneType.AIR);
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(PlayerEntity player) {
        return new ITextComponent[]{new TranslationTextComponent(this.getTranslationKey() + ".info"), new TranslationTextComponent(this.getTranslationKey() + ".default.info"), new TranslationTextComponent(this.getTranslationKey() + ".corrosive.info"), new TranslationTextComponent(this.getTranslationKey() + ".steadfast.info"), new TranslationTextComponent(this.getTranslationKey() + ".destructive.info"), new TranslationTextComponent(this.getTranslationKey() + ".vengeful.info")};
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrushing();
    }

    public static void registerCuttingFluid(ItemStack stack, int lpDrain, double willDrain) {
        cuttingFluidLPMap.put(stack, lpDrain);
        cuttingFluidWillMap.put(stack, willDrain);
    }

    private FakePlayer getFakePlayer(ServerWorld world) {
        return this.fakePlayer == null ? (this.fakePlayer = FakePlayerFactory.get((ServerWorld)world, (GameProfile)new GameProfile(null, "bloodmagic_ritual_crushing"))) : this.fakePlayer;
    }

    static {
        mockPick.func_77966_a(Enchantments.field_185306_r, 1);
    }
}

