/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;

public class RecipeARC
extends BloodMagicRecipe {
    public static final int MAX_RANDOM_OUTPUTS = 3;
    @Nonnull
    private final Ingredient input;
    @Nonnull
    private final Ingredient arc_tool;
    private final FluidStackIngredient inputFluid;
    @Nonnull
    private final ItemStack output;
    private final FluidStack outputFluid;
    private final boolean consumeIngredient;
    private final List<Pair<ItemStack, Double>> addedItems;

    public RecipeARC(ResourceLocation id, Ingredient input, Ingredient arc_tool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid, boolean consumeIngredient) {
        this(id, input, arc_tool, inputFluid, output, new ArrayList<Pair<ItemStack, Double>>(), outputFluid, consumeIngredient);
    }

    public RecipeARC(ResourceLocation id, Ingredient input, Ingredient arc_tool, FluidStackIngredient inputFluid, ItemStack output, List<Pair<ItemStack, Double>> addedItems, FluidStack outputFluid, boolean consumeIngredient) {
        super(id);
        this.input = input;
        this.arc_tool = arc_tool;
        this.inputFluid = inputFluid;
        this.output = output;
        this.addedItems = addedItems;
        this.outputFluid = outputFluid;
        this.consumeIngredient = consumeIngredient;
    }

    public RecipeARC addRandomOutput(ItemStack stack, double chance) {
        if (this.addedItems.size() >= 3) {
            return this;
        }
        this.addedItems.add((Pair<ItemStack, Double>)Pair.of((Object)stack, (Object)chance));
        return this;
    }

    @Nonnull
    public final Ingredient getInput() {
        return this.input;
    }

    @Nonnull
    public final Ingredient getTool() {
        return this.arc_tool;
    }

    public final FluidStackIngredient getFluidIngredient() {
        return this.inputFluid;
    }

    public final FluidStack getFluidOutput() {
        return this.outputFluid;
    }

    public final NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.getInput());
        list.add((Object)this.getTool());
        return list;
    }

    public List<ItemStack> getAllListedOutputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.output.func_77946_l());
        for (Pair<ItemStack, Double> pair : this.addedItems) {
            list.add(((ItemStack)pair.getLeft()).func_77946_l());
        }
        return list;
    }

    public List<ItemStack> getAllOutputs(Random rand) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.output.func_77946_l());
        for (Pair<ItemStack, Double> pair : this.addedItems) {
            if (!(rand.nextDouble() < (Double)pair.getRight())) continue;
            list.add(((ItemStack)pair.getLeft()).func_77946_l());
        }
        return list;
    }

    public double[] getAllOutputChances() {
        int size = this.addedItems.size();
        double[] chanceArray = new double[size];
        for (int i = 0; i < size; ++i) {
            chanceArray[i] = (Double)this.addedItems.get(i).getRight();
        }
        return chanceArray;
    }

    public boolean getConsumeIngredient() {
        return this.consumeIngredient;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.func_199564_a(buffer);
        this.arc_tool.func_199564_a(buffer);
        buffer.func_150788_a(this.output);
        buffer.writeInt(this.addedItems.size());
        for (Pair<ItemStack, Double> pair : this.addedItems) {
            buffer.func_150788_a((ItemStack)pair.getLeft());
            buffer.writeDouble(((Double)pair.getValue()).doubleValue());
        }
        buffer.writeBoolean(this.inputFluid != null);
        if (this.inputFluid != null) {
            this.inputFluid.write(buffer);
        }
        buffer.writeBoolean(this.outputFluid != null);
        if (this.outputFluid != null) {
            this.outputFluid.writeToPacket(buffer);
        }
        buffer.writeBoolean(this.consumeIngredient);
    }

    public IRecipeSerializer<RecipeARC> func_199559_b() {
        return BloodMagicRecipeSerializers.ARC.getRecipeSerializer();
    }

    public IRecipeType<RecipeARC> func_222127_g() {
        return BloodMagicRecipeType.ARC;
    }
}

