/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;

public class SigilHoldingPacket {
    private int slot;
    private int mode;

    public SigilHoldingPacket() {
    }

    public SigilHoldingPacket(int slot, int mode) {
        this.slot = slot;
        this.mode = mode;
    }

    public static void encode(SigilHoldingPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.slot);
        buf.writeInt(pkt.mode);
    }

    public static SigilHoldingPacket decode(PacketBuffer buf) {
        SigilHoldingPacket pkt = new SigilHoldingPacket(buf.readInt(), buf.readInt());
        return pkt;
    }

    public static void handle(SigilHoldingPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SigilHoldingPacket.sendKeyToServer(message, (PlayerEntity)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(SigilHoldingPacket msg, PlayerEntity playerEntity) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (msg.slot > -1 && msg.slot < 9) {
            itemStack = playerEntity.field_71071_by.func_70301_a(msg.slot);
        }
        if (!itemStack.func_190926_b()) {
            ItemSigilHolding.cycleToNextSigil(itemStack, msg.mode);
        }
    }
}

