/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.item.inventory.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.CollectionTagFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.item.routing.TagFilterKey;
import wayoftime.bloodmagic.common.routing.BasicItemFilter;
import wayoftime.bloodmagic.common.routing.BlacklistItemFilter;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemTagFilter
extends ItemRouterFilter
implements INestableItemFilterProvider {
    @Override
    protected IItemFilter getFilterTypeFromConfig(ItemStack filterStack) {
        int state = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        if (state == 1) {
            return new BlacklistItemFilter();
        }
        return new BasicItemFilter();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack filterStack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        boolean isWhitelist;
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.tagfilter.desc").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        if (filterStack.func_77978_p() == null) {
            return;
        }
        int whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        boolean bl = isWhitelist = whitelistState == 0;
        if (isWhitelist) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.whitelist").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.blacklist").func_240699_a_(TextFormatting.GRAY));
        }
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ResourceLocation tag = this.getItemTagResource(filterStack, i);
            Object display = stack.func_200301_q();
            display = tag != null ? new StringTextComponent(tag.toString()) : new TranslationTextComponent("tooltip.bloodmagic.filter.anytag", new Object[]{display});
            if (isWhitelist) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, display}));
                    continue;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.all", new Object[]{display}));
                continue;
            }
            tooltip.add((ITextComponent)display);
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        int index = this.getItemTagIndex(filterStack, slot);
        if (index == 0) {
            List<ITag<Item>> tagList = this.getAllItemTags(filterStack, slot);
            if (tagList != null && !tagList.isEmpty()) {
                return new CollectionTagFilterKey(tagList, amount);
            }
        } else {
            ITag<Item> tag = this.getItemTag(filterStack, slot);
            if (tag != null) {
                return new TagFilterKey(tag, amount);
            }
        }
        return new BasicFilterKey(ghostStack, amount);
    }

    public int getItemTagIndex(ItemStack filterStack, int slot) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            filterStack.func_77982_d(tag);
        }
        return tag.func_74762_e("button:itemtag" + slot);
    }

    public void setItemTagIndex(ItemStack filterStack, int slot, int index) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            filterStack.func_77982_d(tag);
        }
        tag.func_74768_a("button:itemtag" + slot, index);
    }

    public void cycleToNextTag(ItemStack filterStack, int slot) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.func_70301_a(slot);
        if (ghostStack.func_190926_b()) {
            return;
        }
        int index = this.getItemTagIndex(filterStack, slot);
        Set tagRLs = ghostStack.func_77973_b().getTags();
        if (++index > tagRLs.size()) {
            index = 0;
        }
        this.setItemTagIndex(filterStack, slot, index);
    }

    public ITag<Item> getItemTag(ItemStack filterStack, int slot) {
        ResourceLocation rl = this.getItemTagResource(filterStack, slot);
        if (rl == null) {
            return null;
        }
        return TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(rl);
    }

    public ResourceLocation getItemTagResource(ItemStack filterStack, int slot) {
        int index = this.getItemTagIndex(filterStack, slot);
        if (index <= 0) {
            return null;
        }
        --index;
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.func_70301_a(slot);
        if (ghostStack.func_190926_b()) {
            return null;
        }
        ArrayList tagRLs = new ArrayList(ghostStack.func_77973_b().getTags());
        if (tagRLs.size() < index) {
            return null;
        }
        ResourceLocation rl = (ResourceLocation)tagRLs.get(index);
        return rl;
    }

    public List<ITag<Item>> getAllItemTags(ItemStack filterStack, int slot) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.func_70301_a(slot);
        if (ghostStack.func_190926_b()) {
            return null;
        }
        Set tagRLs = ghostStack.func_77973_b().getTags();
        ArrayList<ITag<Item>> tagList = new ArrayList<ITag<Item>>();
        for (ResourceLocation rl : tagRLs) {
            tagList.add((ITag<Item>)TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(rl));
        }
        return tagList;
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            filterStack.func_77982_d(new CompoundNBT());
            tag = filterStack.func_77978_p();
        }
        if (buttonKey.equals("itemtag")) {
            this.cycleToNextTag(filterStack, ghostItemSlot);
        }
        return super.receiveButtonPress(filterStack, buttonKey, ghostItemSlot, currentButtonState);
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag != null && buttonKey.equals("itemtag")) {
            int state = this.getItemTagIndex(filterStack, ghostItemSlot);
            return state;
        }
        return super.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<ITextComponent> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        List<ITextComponent> componentList = super.getTextForHoverItem(filterStack, buttonKey, ghostItemSlot);
        if (ghostItemSlot < 0) {
            return componentList;
        }
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (!buttonKey.equals("itemtag")) return componentList;
        if (currentState == 0) {
            InventoryFilter inv = new InventoryFilter(filterStack);
            ItemStack ghostStack = inv.func_70301_a(ghostItemSlot);
            if (ghostStack.func_190926_b()) {
                componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.novalidtag"));
                return componentList;
            }
            Set locations = ghostStack.func_77973_b().getTags();
            if (locations.size() <= 0) {
                componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.novalidtag"));
                return componentList;
            }
            componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.anytag"));
            for (ResourceLocation rl : locations) {
                componentList.add((ITextComponent)new StringTextComponent(rl.toString()));
            }
            return componentList;
        } else {
            ResourceLocation rl = this.getItemTagResource(filterStack, ghostItemSlot);
            if (rl == null) return componentList;
            componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.specifiedtag"));
            componentList.add((ITextComponent)new StringTextComponent(rl.toString()));
        }
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.IPressable>> getButtonAction(ContainerFilter container) {
        List<Pair<String, Button.IPressable>> buttonList = super.getButtonAction(container);
        buttonList.add((Pair<String, Button.IPressable>)Pair.of((Object)"itemtag", (Object)new FilterButtonTogglePress("itemtag", container)));
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("itemtag")) {
            switch (currentButtonState) {
                case 0: {
                    return Pair.of((Object)196, (Object)20);
                }
            }
            return Pair.of((Object)196, (Object)0);
        }
        return super.getTexturePositionForState(filterStack, buttonKey, currentButtonState);
    }
}

